/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.security.AccessLevel;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingWMTSStoreInfo;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.ows.wmts.WebMapTileServer;
import org.opengis.util.ProgressListener;

public class SecuredWMTSStoreInfo
extends DecoratingWMTSStoreInfo {
    WrapperPolicy policy;

    public SecuredWMTSStoreInfo(WMTSStoreInfo delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    @Override
    public WebMapTileServer getWebMapTileServer(ProgressListener listener) throws IOException {
        WebMapTileServer wms = super.getWebMapTileServer(null);
        if (wms == null) {
            return null;
        }
        if (this.policy.level == AccessLevel.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        return (WebMapTileServer)SecuredObjects.secure(wms, this.policy);
    }
}

