/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.filter.AuthenticationCachingFilter;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class GeoServerCompositeFilter
extends GeoServerSecurityFilter {
    public static final String CACHE_KEY_ATTRIBUTE = "_geoserver_security_cache_key";
    public static final String CACHE_KEY_IDLE_SECS = "_geoserver_security_cache_key_idle_secs";
    public static final String CACHE_KEY_LIVE_SECS = "_geoserver_security_cache_key_live_secs";
    protected List<Filter> nestedFilters = new ArrayList<Filter>();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.nestedFilters == null || this.nestedFilters.size() == 0) {
            chain.doFilter(request, response);
            return;
        }
        NestedFilterChain nestedChain = new NestedFilterChain(chain);
        nestedChain.doFilter(request, response);
    }

    public List<Filter> getNestedFilters() {
        return this.nestedFilters;
    }

    public void setNestedFilters(List<Filter> nestedFilters) {
        this.nestedFilters = nestedFilters;
    }

    protected class NestedFilterChain
    implements FilterChain {
        private final FilterChain originalChain;
        private int currentPosition = 0;

        private NestedFilterChain(FilterChain chain) {
            this.originalChain = chain;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            String cacheKey;
            if (GeoServerCompositeFilter.this instanceof AuthenticationCachingFilter && this.currentPosition == 0 && (cacheKey = GeoServerCompositeFilter.this.authenticateFromCache((AuthenticationCachingFilter)((Object)GeoServerCompositeFilter.this), (HttpServletRequest)request)) != null) {
                request.setAttribute(GeoServerCompositeFilter.CACHE_KEY_ATTRIBUTE, (Object)cacheKey);
            }
            if (GeoServerCompositeFilter.this.nestedFilters == null || this.currentPosition == GeoServerCompositeFilter.this.nestedFilters.size()) {
                Authentication postAuthentication = SecurityContextHolder.getContext().getAuthentication();
                String cacheKey2 = (String)request.getAttribute(GeoServerCompositeFilter.CACHE_KEY_ATTRIBUTE);
                if (postAuthentication != null && cacheKey2 != null) {
                    Integer idleSecs = (Integer)request.getAttribute(GeoServerCompositeFilter.CACHE_KEY_IDLE_SECS);
                    Integer liveSecs = (Integer)request.getAttribute(GeoServerCompositeFilter.CACHE_KEY_LIVE_SECS);
                    GeoServerCompositeFilter.this.getSecurityManager().getAuthenticationCache().put(GeoServerCompositeFilter.this.getName(), cacheKey2, postAuthentication, idleSecs, liveSecs);
                }
                request.setAttribute(GeoServerCompositeFilter.CACHE_KEY_ATTRIBUTE, null);
                request.setAttribute(GeoServerCompositeFilter.CACHE_KEY_IDLE_SECS, null);
                request.setAttribute(GeoServerCompositeFilter.CACHE_KEY_LIVE_SECS, null);
                this.originalChain.doFilter(request, response);
            } else {
                ++this.currentPosition;
                Filter nextFilter = GeoServerCompositeFilter.this.nestedFilters.get(this.currentPosition - 1);
                nextFilter.doFilter(request, response, (FilterChain)this);
            }
        }
    }
}

