/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.event.RoleLoadedEvent;
import org.geoserver.security.event.RoleLoadedListener;
import org.geoserver.security.impl.AbstractGeoServerSecurityService;
import org.geoserver.security.impl.GeoServerRole;
import org.geotools.util.logging.Logging;
import org.springframework.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GeoServerJ2eeRoleService
extends AbstractGeoServerSecurityService
implements GeoServerRoleService {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    protected String adminRoleName;
    protected String groupAdminRoleName;
    protected SortedSet<GeoServerRole> emptySet;
    protected SortedSet<String> emptyStringSet;
    protected Map<String, String> parentMappings;
    protected HashMap<String, GeoServerRole> roleMap;
    protected SortedSet<GeoServerRole> roleSet;
    protected Set<RoleLoadedListener> listeners = Collections.synchronizedSet(new HashSet());

    protected GeoServerJ2eeRoleService() throws IOException {
        this.emptySet = Collections.unmodifiableSortedSet(new TreeSet());
        this.emptyStringSet = Collections.unmodifiableSortedSet(new TreeSet());
        this.parentMappings = new HashMap<String, String>();
        this.load();
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        this.adminRoleName = ((SecurityRoleServiceConfig)config).getAdminRoleName();
        this.groupAdminRoleName = ((SecurityRoleServiceConfig)config).getGroupAdminRoleName();
        this.load();
    }

    @Override
    public GeoServerRole getAdminRole() {
        if (!StringUtils.hasLength((String)this.adminRoleName)) {
            return null;
        }
        try {
            return this.getRoleByName(this.adminRoleName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GeoServerRole getGroupAdminRole() {
        if (!StringUtils.hasLength((String)this.groupAdminRoleName)) {
            return null;
        }
        try {
            return this.getRoleByName(this.groupAdminRoleName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GeoServerRoleStore createStore() throws IOException {
        return null;
    }

    @Override
    public void registerRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public SortedSet<GeoServerRole> getRoles() throws IOException {
        if (this.roleSet != null) {
            return this.roleSet;
        }
        return this.emptySet;
    }

    @Override
    public synchronized void load() throws IOException {
        if (this.roleMap != null) {
            return;
        }
        LOGGER.info("Start reloading roles for service named " + this.getName());
        File webXML = GeoServerExtensions.file((String)"WEB-INF/web.xml");
        if (webXML == null) {
            throw new IOException("Cannot open /WEB-INF/web.xml");
        }
        LOGGER.info("Extracting roles from: " + webXML.getCanonicalPath());
        Set<String> roles = this.parseWebXML(webXML);
        this.roleMap = new HashMap();
        for (String role : roles) {
            this.roleMap.put(role, this.createRoleObject(role));
            this.parentMappings.put(role, null);
        }
        this.roleSet = new TreeSet<GeoServerRole>();
        this.roleSet.addAll(this.roleMap.values());
        LOGGER.info("Reloading roles successful for service named " + this.getName());
        this.fireRoleLoadedEvent();
    }

    protected Set<String> parseWebXML(File file) throws IOException {
        WebXMLContentHandler handler = new WebXMLContentHandler();
        HashSet<String> result = new HashSet<String>();
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            InputSource inputSource = new InputSource(new FileInputStream(file));
            xmlReader.setContentHandler(handler);
            xmlReader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            xmlReader.parse(inputSource);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        result.addAll(handler.getInAuthConstraintRoles());
        result.addAll(handler.getInSecRoleRoles());
        result.addAll(handler.getInSecRoleRefRoles().keySet());
        result.addAll(handler.getInSecRoleRefRoles().values());
        return result;
    }

    @Override
    public SortedSet<GeoServerRole> getRolesForUser(String username) throws IOException {
        return this.emptySet;
    }

    @Override
    public SortedSet<GeoServerRole> getRolesForGroup(String groupname) throws IOException {
        return this.emptySet;
    }

    @Override
    public GeoServerRole createRoleObject(String role) throws IOException {
        return new GeoServerRole(role);
    }

    @Override
    public GeoServerRole getParentRole(GeoServerRole role) throws IOException {
        return null;
    }

    @Override
    public GeoServerRole getRoleByName(String role) throws IOException {
        if (this.roleMap != null) {
            return this.roleMap.get(role);
        }
        return null;
    }

    protected void fireRoleLoadedEvent() {
        RoleLoadedEvent event = new RoleLoadedEvent(this);
        for (RoleLoadedListener listener : this.listeners) {
            listener.rolesChanged(event);
        }
    }

    @Override
    public SortedSet<String> getGroupNamesForRole(GeoServerRole role) throws IOException {
        return this.emptyStringSet;
    }

    @Override
    public SortedSet<String> getUserNamesForRole(GeoServerRole role) throws IOException {
        return this.emptyStringSet;
    }

    @Override
    public Map<String, String> getParentMappings() throws IOException {
        return this.parentMappings;
    }

    @Override
    public Properties personalizeRoleParams(String roleName, Properties roleParams, String userName, Properties userProps) throws IOException {
        return null;
    }

    public Resource getConfigRoot() throws IOException {
        return this.getSecurityManager().role().get(this.getName());
    }

    @Override
    public int getRoleCount() throws IOException {
        if (this.roleSet != null) {
            return this.roleSet.size();
        }
        return 0;
    }

    public class WebXMLContentHandler
    implements ContentHandler {
        public static final String SECURITY_ROLE_REF = "security-role-ref";
        public static final String AUTH_CONSTRAINT = "auth-constraint";
        public static final String SECURITY_ROLE = "security-role";
        public static final String ROLE_NAME = "role-name";
        public static final String ROLE_LINK = "role-link";
        private String currentValue;
        private String roleName;
        private boolean inSecRoleRef;
        private boolean inAuthConstraint;
        private boolean inSecRole;
        private Map<String, String> inSecRoleRefRoles = new HashMap<String, String>();
        private List<String> inAuthConstraintRoles = new ArrayList<String>();
        private List<String> inSecRoleRoles = new ArrayList<String>();

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.currentValue = new String(ch, start, length);
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (SECURITY_ROLE_REF.equals(localName)) {
                this.inSecRoleRef = false;
            }
            if (AUTH_CONSTRAINT.equals(localName)) {
                this.inAuthConstraint = false;
            }
            if (SECURITY_ROLE.equals(localName)) {
                this.inSecRole = false;
            }
            if (ROLE_NAME.endsWith(localName)) {
                if (this.inSecRoleRef) {
                    this.roleName = this.currentValue.trim();
                }
                if (this.inAuthConstraint) {
                    this.inAuthConstraintRoles.add(this.currentValue.trim());
                }
                if (this.inSecRole) {
                    this.inSecRoleRoles.add(this.currentValue.trim());
                }
            }
            if (ROLE_LINK.endsWith(localName)) {
                this.inSecRoleRefRoles.put(this.roleName, this.currentValue.trim());
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (SECURITY_ROLE_REF.equals(localName)) {
                this.inSecRoleRef = true;
            }
            if (AUTH_CONSTRAINT.equals(localName)) {
                this.inAuthConstraint = true;
            }
            if (SECURITY_ROLE.equals(localName)) {
                this.inSecRole = true;
            }
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }

        public Map<String, String> getInSecRoleRefRoles() {
            return this.inSecRoleRefRoles;
        }

        public List<String> getInAuthConstraintRoles() {
            return this.inAuthConstraintRoles;
        }

        public List<String> getInSecRoleRoles() {
            return this.inSecRoleRoles;
        }
    }
}

