/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import java.io.IOException;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.password.GeoServerMultiplexingPasswordEncoder;
import org.geoserver.security.password.UserDetailsPasswordWrapper;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class DecodingUserDetailsService
implements UserDetailsService {
    protected GeoServerUserGroupService service;
    protected GeoServerMultiplexingPasswordEncoder encoder;

    public static DecodingUserDetailsService newInstance(GeoServerUserGroupService service) throws IOException {
        DecodingUserDetailsService decodingService = new DecodingUserDetailsService();
        decodingService.setGeoserverUserGroupService(service);
        return decodingService;
    }

    protected DecodingUserDetailsService() {
    }

    public void setGeoserverUserGroupService(GeoServerUserGroupService service) throws IOException {
        this.service = service;
        this.encoder = new GeoServerMultiplexingPasswordEncoder(service.getSecurityManager(), service);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        GeoServerUser user = (GeoServerUser)this.service.loadUserByUsername(username);
        if (user == null) {
            return null;
        }
        try {
            String decoded = this.encoder.decode(user.getPassword());
            return new UserDetailsPasswordWrapper(user, decoded);
        }
        catch (UnsupportedOperationException ex) {
            return new UserDetailsPasswordWrapper(user, user.getPassword());
        }
    }
}

