/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.PasswordPolicyConfig;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.password.PasswordValidator;
import org.geoserver.security.validation.AbstractSecurityValidator;
import org.geoserver.security.validation.PasswordPolicyException;

public class PasswordValidatorImpl
extends AbstractSecurityValidator
implements PasswordValidator {
    protected PasswordPolicyConfig config;
    protected static volatile Set<String> notAllowedPrefixes;
    protected static Object lock;

    public PasswordValidatorImpl(GeoServerSecurityManager securityManager) {
        super(securityManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getNotAllowedPrefixes() {
        if (notAllowedPrefixes == null) {
            Object object = lock;
            synchronized (object) {
                if (notAllowedPrefixes == null) {
                    HashSet<String> nap = new HashSet<String>();
                    for (GeoServerPasswordEncoder enc : GeoServerExtensions.extensions(GeoServerPasswordEncoder.class)) {
                        nap.add(enc.getPrefix() + ":");
                    }
                    notAllowedPrefixes = nap;
                }
            }
        }
        return notAllowedPrefixes;
    }

    public static String passwordStartsWithEncoderPrefix(char[] password) {
        if (password == null) {
            return null;
        }
        block0: for (String prefix : PasswordValidatorImpl.getNotAllowedPrefixes()) {
            if (prefix.length() > password.length) continue;
            for (int i = 0; i < prefix.length(); ++i) {
                if (prefix.charAt(i) != password[i]) continue block0;
            }
            return prefix;
        }
        return null;
    }

    @Override
    public void setConfig(PasswordPolicyConfig config) {
        this.config = config;
    }

    @Override
    public PasswordPolicyConfig getConfig() {
        return this.config;
    }

    @Override
    public void validatePassword(char[] password) throws PasswordPolicyException {
        if (password == null) {
            password = new char[]{};
        }
        if (password.length < this.config.getMinLength()) {
            throw this.createSecurityException("MIN_LENGTH", this.config.getMinLength());
        }
        if (this.config.getMaxLength() >= 0 && password.length > this.config.getMaxLength()) {
            throw this.createSecurityException("MAX_LENGTH", this.config.getMaxLength());
        }
        if (this.config.isDigitRequired() && !this.checkUsingMethod("isDigit", password)) {
            throw this.createSecurityException("NO_DIGIT", new Object[0]);
        }
        if (this.config.isUppercaseRequired() && !this.checkUsingMethod("isUpperCase", password)) {
            throw this.createSecurityException("NO_UPPERCASE", new Object[0]);
        }
        if (this.config.isLowercaseRequired() && !this.checkUsingMethod("isLowerCase", password)) {
            throw this.createSecurityException("NO_LOWERCASE", new Object[0]);
        }
        String prefix = PasswordValidatorImpl.passwordStartsWithEncoderPrefix(password);
        if (prefix != null) {
            throw this.createSecurityException("RESERVED_PREFIX", prefix);
        }
    }

    protected boolean checkUsingMethod(String methodname, char[] charArray) {
        try {
            Method m = this.getClass().getMethod(methodname, Character.class);
            for (char c : charArray) {
                Boolean result = (Boolean)m.invoke((Object)this, Character.valueOf(c));
                if (!result.booleanValue()) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            throw new RuntimeException("never should reach this point", ex);
        }
    }

    public boolean isDigit(Character c) {
        return Character.isDigit(c.charValue());
    }

    public boolean isUpperCase(Character c) {
        return Character.isUpperCase(c.charValue());
    }

    public boolean isLowerCase(Character c) {
        return Character.isLowerCase(c.charValue());
    }

    protected PasswordPolicyException createSecurityException(String errorid, Object ... args) {
        PasswordPolicyException ex = new PasswordPolicyException(errorid, args);
        return ex;
    }

    static {
        lock = new Object();
    }
}

