/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.xml;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.SortedSet;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.file.LockFile;
import org.geoserver.security.impl.AbstractUserGroupStore;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.security.xml.XMLGeoserverUser;
import org.geoserver.security.xml.XMLUserGroupService;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLUserGroupStore
extends AbstractUserGroupStore {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.xml");
    protected Resource userResource;
    protected LockFile lockFile = null;
    private boolean validatingXMLSchema = true;

    public boolean isValidatingXMLSchema() {
        return this.validatingXMLSchema;
    }

    public void setValidatingXMLSchema(boolean validatingXMLSchema) {
        this.validatingXMLSchema = validatingXMLSchema;
    }

    @Override
    public void initializeFromService(GeoServerUserGroupService service) throws IOException {
        this.userResource = ((XMLUserGroupService)service).userResource;
        this.validatingXMLSchema = ((XMLUserGroupService)service).isValidatingXMLSchema();
        super.initializeFromService(service);
    }

    @Override
    protected void serialize() throws IOException {
        DocumentBuilder builder = null;
        try {
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            builder = fac.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            throw new IOException(e1);
        }
        Document doc = builder.newDocument();
        Element userreg = doc.createElement("userRegistry");
        doc.appendChild(userreg);
        userreg.setAttribute("xmlns", "http://www.geoserver.org/security/users");
        userreg.setAttribute("version", "1.0");
        Element users = doc.createElement("users");
        userreg.appendChild(users);
        for (GeoServerUser geoServerUser : this.helper.userMap.values()) {
            Element user = doc.createElement("user");
            users.appendChild(user);
            user.setAttribute("name", geoServerUser.getUsername());
            if (geoServerUser.getPassword() != null) {
                user.setAttribute("password", geoServerUser.getPassword());
            }
            user.setAttribute("enabled", String.valueOf(geoServerUser.isEnabled()));
            for (Object key : geoServerUser.getProperties().keySet()) {
                Element property = doc.createElement("property");
                user.appendChild(property);
                property.setAttribute("name", key.toString());
                property.setTextContent(geoServerUser.getProperties().getProperty(key.toString()));
            }
        }
        Element groups = doc.createElement("groups");
        userreg.appendChild(groups);
        for (GeoServerUserGroup groupObject : this.helper.groupMap.values()) {
            Element group = doc.createElement("group");
            groups.appendChild(group);
            group.setAttribute("name", groupObject.getGroupname());
            group.setAttribute("enabled", groupObject.isEnabled() ? "true" : "false");
            SortedSet<GeoServerUser> userObjects = this.helper.group_userMap.get(groupObject);
            if (userObjects == null) continue;
            for (GeoServerUser userObject : userObjects) {
                Element member = doc.createElement("member");
                group.appendChild(member);
                member.setAttribute("username", userObject.getUsername());
            }
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "XML");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            try (BufferedOutputStream out = new BufferedOutputStream(this.userResource.out());){
                transformer.transform(new DOMSource(doc), new StreamResult(out));
                ((OutputStream)out).flush();
            }
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    protected void deserialize() throws IOException {
        super.deserialize();
        this.releaseLock();
    }

    protected void ensureLock() throws IOException {
        if (this.lockFile != null) {
            return;
        }
        this.lockFile = new LockFile(this.userResource);
        try {
            this.lockFile.writeLock();
        }
        catch (IOException ex) {
            this.lockFile = null;
            throw ex;
        }
    }

    protected void releaseLock() {
        if (this.lockFile == null) {
            return;
        }
        this.lockFile.writeUnLock();
        this.lockFile = null;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void store() throws IOException {
        this.ensureLock();
        super.store();
        this.releaseLock();
    }

    @Override
    public void addUser(GeoServerUser user) throws IOException, PasswordPolicyException {
        this.ensureLock();
        super.addUser(user);
    }

    @Override
    public void addGroup(GeoServerUserGroup group) throws IOException {
        this.ensureLock();
        super.addGroup(group);
    }

    @Override
    public void updateUser(GeoServerUser user) throws IOException, PasswordPolicyException {
        this.ensureLock();
        super.updateUser(user);
    }

    @Override
    public void updateGroup(GeoServerUserGroup group) throws IOException {
        this.ensureLock();
        super.updateGroup(group);
    }

    @Override
    public boolean removeUser(GeoServerUser user) throws IOException {
        this.ensureLock();
        return super.removeUser(user);
    }

    @Override
    public boolean removeGroup(GeoServerUserGroup group) throws IOException {
        this.ensureLock();
        return super.removeGroup(group);
    }

    @Override
    public void associateUserToGroup(GeoServerUser user, GeoServerUserGroup group) throws IOException {
        this.ensureLock();
        super.associateUserToGroup(user, group);
    }

    @Override
    public void disAssociateUserFromGroup(GeoServerUser user, GeoServerUserGroup group) throws IOException {
        this.ensureLock();
        super.disAssociateUserFromGroup(user, group);
    }

    @Override
    public void clear() throws IOException {
        this.ensureLock();
        super.clear();
    }

    @Override
    public GeoServerUser createUserObject(String username, String password, boolean isEnabled) throws IOException {
        XMLGeoserverUser user = new XMLGeoserverUser(username);
        user.setEnabled(isEnabled);
        user.setPassword(password);
        return user;
    }
}

