/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.threadlocals;

import java.util.Map;
import org.geoserver.threadlocals.ThreadLocalTransfer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthenticationThreadLocalTransfer
implements ThreadLocalTransfer {
    private static final String KEY = SecurityContext.class.getName() + "#Authentication";

    @Override
    public void collect(Map<String, Object> storage) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        storage.put(KEY, authentication);
    }

    @Override
    public void apply(Map<String, Object> storage) {
        Authentication authentication = (Authentication)storage.get(KEY);
        if (authentication != null) {
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
    }

    @Override
    public void cleanup() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }
}

