/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.threadlocals;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.geoserver.threadlocals.ThreadLocalTransfer;

public class PublicThreadLocalTransfer
implements ThreadLocalTransfer {
    Field field;
    String key;

    public PublicThreadLocalTransfer(Class theClass, String threadLocalField) throws SecurityException, NoSuchFieldException {
        this.field = theClass.getDeclaredField(threadLocalField);
        if (this.field == null) {
            throw new IllegalArgumentException("Failed to locate field " + this.field + " in class " + theClass.getName());
        }
        if (!Modifier.isStatic(this.field.getModifiers())) {
            throw new IllegalArgumentException("Field " + this.field + " in class " + theClass.getName() + " was found, but it's not a static variable");
        }
        this.key = theClass.getName() + "#" + this.field;
    }

    @Override
    public void collect(Map<String, Object> storage) {
        ThreadLocal threadLocal = this.getThreadLocal();
        if (threadLocal != null) {
            Object value = threadLocal.get();
            storage.put(this.key, value);
        }
    }

    @Override
    public void apply(Map<String, Object> storage) {
        Object value = storage.get(this.key);
        ThreadLocal threadLocal = this.getThreadLocal();
        if (threadLocal != null) {
            threadLocal.set(value);
        }
    }

    ThreadLocal getThreadLocal() {
        try {
            return (ThreadLocal)this.field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to grab thread local " + this.key + " for transfer into other threads", e);
        }
    }

    @Override
    public void cleanup() {
        ThreadLocal threadLocal = this.getThreadLocal();
        if (threadLocal != null) {
            threadLocal.remove();
        }
    }
}

