/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.awt.RenderingHints;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.geoserver.catalog.AcceptableRange;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StructuredCoverageViewReader;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.NearestMatchWarningAppender;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.NearestVisitor;
import org.geotools.util.Range;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public abstract class NearestMatchFinder {
    public static boolean ENABLE_STRUCTURED_READER_SUPPORT = true;
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    PropertyName attribute;
    PropertyName endAttribute;
    AcceptableRange acceptableRange;
    Class dataType;

    public static NearestMatchFinder get(ResourceInfo info, DimensionInfo dimensionInfo, String dimensionName) throws IOException {
        Class dataType = NearestMatchFinder.getDataTypeFromDimension(info, dimensionName);
        try {
            AcceptableRange acceptableRange = AcceptableRange.getAcceptableRange(dimensionInfo.getAcceptableInterval(), dataType);
            if (info instanceof FeatureTypeInfo) {
                FeatureTypeInfo featureType = (FeatureTypeInfo)info;
                return new Vector(featureType, dimensionInfo.getAttribute(), dimensionInfo.getEndAttribute(), acceptableRange, dataType);
            }
            if (info instanceof CoverageInfo) {
                GridCoverageReader reader = ((CoverageInfo)info).getGridCoverageReader(null, null);
                if (reader instanceof StructuredGridCoverage2DReader && ENABLE_STRUCTURED_READER_SUPPORT) {
                    StructuredGridCoverage2DReader structured = (StructuredGridCoverage2DReader)reader;
                    DimensionDescriptor dd = NearestMatchFinder.getDimensionDescriptor(structured, dimensionName);
                    return new StructuredReader(structured, dd.getStartAttribute(), dd.getEndAttribute(), acceptableRange, dataType);
                }
                if (reader instanceof GridCoverage2DReader) {
                    return new Reader((GridCoverage2DReader)reader, acceptableRange, dimensionName, dataType);
                }
            }
        }
        catch (ParseException e) {
            throw new ServiceException("Failed to apply nearest match search on " + info.prefixedName(), (Throwable)e);
        }
        throw new IllegalArgumentException("No nearest match support for " + info);
    }

    private static DimensionDescriptor getDimensionDescriptor(StructuredGridCoverage2DReader structured, String dimensionName) throws IOException {
        String coverageName = structured.getGridCoverageNames()[0];
        return structured.getDimensionDescriptors(coverageName).stream().filter(dd -> dimensionName.equalsIgnoreCase(dd.getName())).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find dimension" + dimensionName + "in grid coverage reader"));
    }

    private static Class getDataTypeFromDimension(ResourceInfo info, String dimensionName) {
        if (dimensionName.equalsIgnoreCase("time")) {
            return Date.class;
        }
        if (dimensionName.equalsIgnoreCase("elevation")) {
            return Double.class;
        }
        throw new IllegalArgumentException("Dimension " + dimensionName + " not supported for nearest match yet");
    }

    public NearestMatchFinder(String startAttribute, String endAttribute, AcceptableRange acceptableRange, Class dataType) {
        this.attribute = FF.property(startAttribute);
        this.endAttribute = endAttribute == null ? null : FF.property(endAttribute);
        this.acceptableRange = acceptableRange;
        this.dataType = dataType;
    }

    public Object getNearest(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (this.endAttribute == null && (!(value instanceof Range) || ((Range)value).getMinValue().equals(((Range)value).getMaxValue()))) {
            Date date = (Date)(value instanceof Range ? ((Range)value).getMinValue() : value);
            NearestVisitor visitor = new NearestVisitor((Expression)this.attribute, (Object)date);
            IncludeFilter filter = Filter.INCLUDE;
            if (this.acceptableRange != null) {
                Range searchRange = this.acceptableRange.getSearchRange(date);
                filter = FF.between((Expression)this.attribute, (Expression)FF.literal((Object)searchRange.getMinValue()), (Expression)FF.literal((Object)searchRange.getMaxValue()));
            }
            FeatureCollection features = this.getMatches((Filter)filter);
            features.accepts((FeatureVisitor)visitor, null);
            Object result = visitor.getResult().getValue();
            if (date.equals(result)) {
                return value;
            }
            return result;
        }
        Filter lowerFilter = this.buildComparisonFilter(value, FilterDirection.HIGHEST_AMONG_LOWERS);
        FeatureCollection lowers = this.getMatches(lowerFilter);
        MaxVisitor lowersVisitor = new MaxVisitor((Expression)(this.endAttribute == null ? this.attribute : this.endAttribute));
        lowers.accepts((FeatureVisitor)lowersVisitor, null);
        Comparable maxOfSmallers = (Comparable)lowersVisitor.getResult().getValue();
        Filter higherFilter = this.buildComparisonFilter(value, FilterDirection.LOWEST_AMONG_HIGHER);
        FeatureCollection highers = this.getMatches(higherFilter);
        MinVisitor highersVisitor = new MinVisitor((Expression)this.attribute);
        highers.accepts((FeatureVisitor)highersVisitor, null);
        Comparable minOfGreater = (Comparable)highersVisitor.getResult().getValue();
        return this.closest(value, maxOfSmallers, minOfGreater);
    }

    protected Object closest(Object value, Object maxOfSmallers, Object minOfGreater) {
        Object result;
        if (maxOfSmallers instanceof Range) {
            maxOfSmallers = ((Range)maxOfSmallers).getMaxValue();
        }
        if (minOfGreater instanceof Range) {
            minOfGreater = ((Range)minOfGreater).getMinValue();
        }
        if (maxOfSmallers == null) {
            result = minOfGreater == null ? null : minOfGreater;
        } else if (minOfGreater == null) {
            result = maxOfSmallers;
        } else if (value instanceof Range) {
            double distanceAbove;
            Range range = (Range)value;
            Comparable min = range.getMinValue();
            Comparable max = range.getMaxValue();
            double distanceBelow = this.distance(min, maxOfSmallers);
            result = distanceBelow < (distanceAbove = this.distance(max, minOfGreater)) ? maxOfSmallers : minOfGreater;
        } else {
            double distanceAbove;
            double distanceBelow = this.distance(value, minOfGreater);
            Object object = result = distanceBelow < (distanceAbove = this.distance(value, maxOfSmallers)) ? minOfGreater : maxOfSmallers;
        }
        if (result instanceof Range) {
            if (result == minOfGreater) {
                return ((Range)result).getMaxValue();
            }
            return ((Range)result).getMinValue();
        }
        return result;
    }

    protected double distance(Object a, Object b) {
        if (Number.class.isAssignableFrom(this.dataType)) {
            Number na = (Number)a;
            Number nb = (Number)b;
            return Math.abs(na.doubleValue() - nb.doubleValue());
        }
        if (Date.class.isAssignableFrom(this.dataType)) {
            Date da = (Date)a;
            Date db = (Date)b;
            return Math.abs(da.getTime() - db.getTime());
        }
        throw new IllegalArgumentException("Nearest calculations on data type " + this.dataType + " are not supported");
    }

    protected Filter buildComparisonFilter(Object value, FilterDirection direction) {
        if (value instanceof Range) {
            Range range = (Range)value;
            Literal qlower = FF.literal((Object)range.getMinValue());
            Literal qupper = FF.literal((Object)range.getMaxValue());
            return this.buildComparisonFilter(direction, qlower, qupper);
        }
        Literal valueReference = FF.literal(value);
        return this.buildComparisonFilter(direction, valueReference, valueReference);
    }

    public List<Object> getMatches(String layerName, DimensionInfo dimension, List<Object> values, String dimensionName, int maxOutputTime) throws IOException {
        long maxTime = maxOutputTime > 0 ? System.currentTimeMillis() + (long)(maxOutputTime * 1000) : -1L;
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : values) {
            Object nearest = this.getNearest(value);
            if (nearest == null) {
                NearestMatchWarningAppender.addWarning(layerName, dimensionName, null, dimension.getUnits(), NearestMatchWarningAppender.WarningType.NotFound);
                result.add(value);
            } else if (value.equals(nearest)) {
                result.add(value);
            } else {
                NearestMatchWarningAppender.addWarning(layerName, dimensionName, nearest, dimension.getUnits(), NearestMatchWarningAppender.WarningType.Nearest);
                result.add(nearest);
            }
            if (maxTime <= 0L || System.currentTimeMillis() <= maxTime) continue;
            throw new ServiceException("Nearest matching dimension values required more time than allowed and has been forcefully stopped. The max time is " + maxOutputTime + "s");
        }
        return result;
    }

    private Filter buildComparisonFilter(FilterDirection direction, Literal qlower, Literal qupper) {
        PropertyName comparisonAttribute = this.getComparisonAttribute(direction);
        if (direction == FilterDirection.HIGHEST_AMONG_LOWERS) {
            if (this.acceptableRange != null) {
                Range searchRange = this.acceptableRange.getSearchRange(qlower.getValue());
                return FF.between((Expression)comparisonAttribute, (Expression)FF.literal((Object)searchRange.getMinValue()), (Expression)qlower);
            }
            return FF.lessOrEqual((Expression)comparisonAttribute, (Expression)qlower);
        }
        if (this.acceptableRange != null) {
            Range searchRange = this.acceptableRange.getSearchRange(qupper.getValue());
            return FF.between((Expression)comparisonAttribute, (Expression)qupper, (Expression)FF.literal((Object)searchRange.getMaxValue()));
        }
        return FF.greaterOrEqual((Expression)comparisonAttribute, (Expression)qupper);
    }

    private PropertyName getComparisonAttribute(FilterDirection direction) {
        if (this.endAttribute != null && direction == FilterDirection.HIGHEST_AMONG_LOWERS) {
            return this.endAttribute;
        }
        return this.attribute;
    }

    protected abstract FeatureCollection getMatches(Filter var1) throws IOException;

    private static class Reader
    extends NearestMatchFinder {
        private final GridCoverage2DReader reader;
        private final String dimensionName;

        public Reader(GridCoverage2DReader reader, AcceptableRange acceptableRange, String dimensionName, Class dataType) {
            super(null, null, acceptableRange, dataType);
            this.reader = reader;
            this.dimensionName = dimensionName;
        }

        @Override
        public Object getNearest(Object value) throws IOException {
            TreeSet<Object> domain = this.getDimensionDomain();
            if (domain.isEmpty()) {
                return null;
            }
            Object maxOfSmallers = null;
            Object minOfGreater = null;
            Range rangeFilter = this.acceptableRange != null ? this.acceptableRange.getSearchRange(value) : null;
            for (Object d : domain) {
                if (!this.rangeFilterAccepts(rangeFilter, d)) continue;
                int result = this.compare(d, value);
                if (result < 0) {
                    maxOfSmallers = d;
                    continue;
                }
                if (result == 0) {
                    return value;
                }
                minOfGreater = d;
                break;
            }
            return this.closest(value, maxOfSmallers, minOfGreater);
        }

        private boolean rangeFilterAccepts(Range rangeFilter, Object domainValue) {
            if (rangeFilter == null) {
                return true;
            }
            if (domainValue instanceof Range) {
                return rangeFilter.intersects((Range)domainValue);
            }
            return rangeFilter.contains((Comparable)domainValue);
        }

        private int compare(Object a, Object b) {
            if (!(a instanceof Range)) {
                if (!(b instanceof Range)) {
                    return ((Comparable)a).compareTo(b);
                }
                return this.compare((Range)b, a) * -1;
            }
            if (a instanceof Range) {
                if (b instanceof Range) {
                    Range ra = (Range)a;
                    Range rb = (Range)b;
                    if (ra.intersects(rb)) {
                        return 0;
                    }
                    if (ra.getMinValue().compareTo(rb.getMaxValue()) >= 0) {
                        return 1;
                    }
                    return -1;
                }
                return this.compare((Range)a, b);
            }
            throw new IllegalArgumentException("boo");
        }

        private int compare(Range a, Object b) {
            Range ra = a;
            if (ra.getMinValue().compareTo(b) > 0) {
                return 1;
            }
            if (ra.getMaxValue().compareTo(b) < 0) {
                return -1;
            }
            return 0;
        }

        private TreeSet<Object> getDimensionDomain() throws IOException {
            ReaderDimensionsAccessor accessor = new ReaderDimensionsAccessor(this.reader);
            if ("time".equals(this.dimensionName)) {
                return accessor.getTimeDomain();
            }
            throw new IllegalArgumentException("Nearest match support on simple grid readers is supported only for time at the moment");
        }

        @Override
        protected FeatureCollection getMatches(Filter filter) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class StructuredReader
    extends NearestMatchFinder {
        private final StructuredGridCoverage2DReader reader;

        public StructuredReader(StructuredGridCoverage2DReader reader, String startAttribute, String endAttribute, AcceptableRange acceptableRange, Class dataType) {
            super(startAttribute, endAttribute, acceptableRange, dataType);
            this.reader = reader;
        }

        @Override
        protected FeatureCollection getMatches(Filter filter) throws IOException {
            GranuleSource granules = this.reader.getGranules(null, true);
            Query q = new Query(null, filter);
            q.setHints(new Hints((RenderingHints.Key)StructuredCoverageViewReader.QUERY_FIRST_BAND, (Object)true));
            return granules.getGranules(q);
        }
    }

    private static class Vector
    extends NearestMatchFinder {
        private final FeatureSource featureSource;

        public Vector(FeatureTypeInfo ftInfo, String attribute, String endAttribute, AcceptableRange acceptableRange, Class dataType) throws IOException {
            super(attribute, endAttribute, acceptableRange, dataType);
            this.featureSource = ftInfo.getFeatureSource(null, null);
        }

        @Override
        protected FeatureCollection getMatches(Filter filter) throws IOException {
            return this.featureSource.getFeatures(filter);
        }
    }

    static enum FilterDirection {
        HIGHEST_AMONG_LOWERS,
        LOWEST_AMONG_HIGHER;

    }
}

