/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.IOException;
import java.util.Objects;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;

public class GeoserverComplexFeatureSource
extends DecoratingFeatureSource<FeatureType, Feature> {
    private static final long serialVersionUID = 1L;
    protected static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2(null);
    private final FeatureTypeInfo ftypeInfo;

    public GeoserverComplexFeatureSource(FeatureSource<FeatureType, Feature> delegate, FeatureTypeInfo ftypeInfo) throws DataSourceException {
        super(delegate);
        this.ftypeInfo = Objects.requireNonNull(ftypeInfo);
    }

    @Override
    public FeatureCollection<FeatureType, Feature> getFeatures(Filter filter) throws IOException {
        filter = this.buildFilter(filter);
        return ((FeatureSource)this.delegate).getFeatures(filter);
    }

    @Override
    public FeatureCollection<FeatureType, Feature> getFeatures(Query query) throws IOException {
        query = this.buildQuery(query);
        return ((FeatureSource)this.delegate).getFeatures(query);
    }

    @Override
    public FeatureCollection<FeatureType, Feature> getFeatures() throws IOException {
        return ((FeatureSource)this.delegate).getFeatures(this.getDefaultQuery());
    }

    @Override
    public ReferencedEnvelope getBounds() throws IOException {
        return ((FeatureSource)this.delegate).getBounds(this.getDefaultQuery());
    }

    protected Query getDefaultQuery() throws DataSourceException {
        return new Query(this.ftypeInfo.getQualifiedNativeName().getLocalPart(), this.buildFilter((Filter)Filter.INCLUDE));
    }

    @Override
    public ReferencedEnvelope getBounds(Query query) throws IOException {
        query = this.buildQuery(query);
        return ((FeatureSource)this.delegate).getBounds(query);
    }

    @Override
    public int getCount(Query query) throws IOException {
        query = this.buildQuery(query);
        return ((FeatureSource)this.delegate).getCount(query);
    }

    protected Query buildQuery(Query query) throws DataSourceException {
        Filter filter = this.buildFilter(query.getFilter());
        Query newQuery = new Query(query);
        newQuery.setFilter(filter);
        return newQuery;
    }

    private Filter buildFilter(Filter filter) throws DataSourceException {
        Filter newFilter = filter = this.nullSafeCheck(filter);
        try {
            Filter definitionQuery = this.nullSafeCheck(this.ftypeInfo.filter());
            if (definitionQuery == Filter.INCLUDE) {
                return filter;
            }
            SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
            Filter simplifiedDefinitionQuery = (Filter)definitionQuery.accept((FilterVisitor)visitor, null);
            if (filter == Filter.INCLUDE) {
                newFilter = simplifiedDefinitionQuery;
            } else if (simplifiedDefinitionQuery != Filter.INCLUDE) {
                newFilter = FF.and(simplifiedDefinitionQuery, filter);
            }
        }
        catch (Exception ex) {
            throw new DataSourceException("Can't create the definition filter", (Throwable)ex);
        }
        return newFilter;
    }

    private Filter nullSafeCheck(Filter filter) {
        if (filter == null) {
            return Filter.INCLUDE;
        }
        return filter;
    }
}

