/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.util.ResponseUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class SLDValidator {
    static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver");
    EntityResolver entityResolver;

    public List validateSLD(InputStream xml) {
        return this.validateSLD(new InputSource(xml));
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public static String getErrorMessage(InputStream xml, List errors) {
        return SLDValidator.getErrorMessage(new InputStreamReader(xml), errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorMessage(Reader xml, List errors) {
        BufferedReader reader = null;
        StringBuffer result = new StringBuffer();
        result.append("Your SLD is not valid.\n");
        result.append("Most common problems are: \n(1) no namespaces - use <ows:GetMap>, <sld:Rule>, <ogc:Filter>, <gml:Point>  - the part before the ':' is important\n");
        result.append("(2) capitialization - use '<And>' not '<and>' \n");
        result.append("(3) Order - The order of elements is important \n");
        result.append("(4) Make sure your first tag imports the correct namespaces.  ie. xmlns:sld=\"http://www.opengis.net/sld\" for EVERY NAMESPACE \n");
        result.append("\n");
        try {
            SAXParseException sax;
            reader = new BufferedReader(xml);
            String line = reader.readLine();
            int linenumber = 1;
            int exceptionNum = 0;
            if (errors.size() > 0 && (sax = (SAXParseException)errors.get(0)).getLineNumber() < 0) {
                result.append("   INVALID XML: " + sax.getLocalizedMessage() + "\n");
                result.append(" \n");
                exceptionNum = 1;
            }
            while (line != null) {
                line = line.replace('\n', ' ');
                line = line.replace('\r', ' ');
                String header = linenumber + ": ";
                result.append(header + line + "\n");
                boolean keep_going = true;
                while (keep_going) {
                    if (exceptionNum < errors.size()) {
                        SAXParseException sax2 = (SAXParseException)errors.get(exceptionNum);
                        if (sax2.getLineNumber() <= linenumber) {
                            String head = "---------------------".substring(0, header.length() - 1);
                            String body = "--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------";
                            int colNum = sax2.getColumnNumber();
                            if (colNum < 1) {
                                colNum = 1;
                            }
                            if (colNum > body.length() && colNum > (body = body + body + body + body + body + body).length()) {
                                colNum = body.length();
                            }
                            result.append(head + body.substring(0, colNum - 1) + "^\n");
                            result.append("       (line " + sax2.getLineNumber() + ", column " + sax2.getColumnNumber() + ")" + sax2.getLocalizedMessage() + "\n");
                            ++exceptionNum;
                            continue;
                        }
                        keep_going = false;
                        continue;
                    }
                    keep_going = false;
                }
                line = reader.readLine();
                ++linenumber;
            }
            for (int t = exceptionNum; t < errors.size(); ++t) {
                SAXParseException sax3 = (SAXParseException)errors.get(t);
                result.append("       (line " + sax3.getLineNumber() + ", column " + sax3.getColumnNumber() + ")" + sax3.getLocalizedMessage() + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result.toString();
    }

    public List validateSLD(InputSource xml) {
        URL schemaURL = SLDValidator.class.getResource("/schemas/sld/StyledLayerDescriptor.xsd");
        return ResponseUtils.validate(xml, schemaURL, false, this.entityResolver);
    }
}

