/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.RetypeFeatureTypeCallback;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.security.decorators.DecoratingSimpleFeatureSource;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.vfny.geoserver.global.GeoServerFeatureSource;

public class RetypeFeatureTypeCallbackTest
extends GeoServerSystemTestSupport {
    public static final String LONG_LAT_NO_GEOM_ON_THE_FLY_LAYER_FILE = "longlat.properties";
    public static final QName LONG_LAT_NO_GEOM_ON_THE_FLY_QNAME = new QName(MockData.DEFAULT_PREFIX, "longlat", MockData.DEFAULT_PREFIX);
    public static final QName LONG_LAT_NO_GEOM_ON_THE_FLY_QNAME_REPROJECTED = new QName(MockData.DEFAULT_PREFIX, "longlat_reprojected", MockData.DEFAULT_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        TestRetypeFeatureTypeCallback o2 = new TestRetypeFeatureTypeCallback();
        GeoServerExtensionsHelper.singleton("retypeFeatureTypeCallbackTest", o2, RetypeFeatureTypeCallback.class);
        super.onSetUp(testData);
        this.setUpNonGeometryLayer(testData);
        this.setReprojectedUpNonGeometryLayer(testData);
    }

    private void setUpNonGeometryLayer(SystemTestData testData) throws IOException {
        HashMap<SystemTestData.LayerProperty, Object> props = new HashMap<SystemTestData.LayerProperty, Object>();
        testData.addVectorLayer(LONG_LAT_NO_GEOM_ON_THE_FLY_QNAME, props, LONG_LAT_NO_GEOM_ON_THE_FLY_LAYER_FILE, this.getClass(), this.getCatalog());
    }

    private void setReprojectedUpNonGeometryLayer(SystemTestData testData) throws IOException {
        HashMap<SystemTestData.LayerProperty, Object> props = new HashMap<SystemTestData.LayerProperty, Object>();
        props.put(SystemTestData.LayerProperty.PROJECTION_POLICY, ProjectionPolicy.REPROJECT_TO_DECLARED);
        props.put(SystemTestData.LayerProperty.SRS, 900913);
        testData.addVectorLayer(LONG_LAT_NO_GEOM_ON_THE_FLY_QNAME_REPROJECTED, props, LONG_LAT_NO_GEOM_ON_THE_FLY_LAYER_FILE, this.getClass(), this.getCatalog());
    }

    @Test
    public void testGeometryCreation() throws Exception {
        ResourcePool pool = ResourcePool.create((Catalog)this.getCatalog());
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(LONG_LAT_NO_GEOM_ON_THE_FLY_QNAME.getNamespaceURI(), LONG_LAT_NO_GEOM_ON_THE_FLY_QNAME.getLocalPart());
        FeatureType ft1 = pool.getFeatureType(info);
        Assert.assertTrue((boolean)ft1.getUserData().containsKey("RETYPED"));
        Assert.assertEquals((Object)ft1.getGeometryDescriptor().getType().getBinding(), Point.class);
        FeatureSource retyped = pool.getFeatureSource(info, null);
        Assert.assertTrue((boolean)(retyped instanceof GeoServerFeatureSource));
        Assert.assertEquals((Object)retyped.getSchema().getGeometryDescriptor().getType().getBinding(), Point.class);
        try (FeatureIterator iterator = retyped.getFeatures().features();){
            while (iterator.hasNext()) {
                Feature feature = iterator.next();
                Assert.assertTrue((boolean)(feature.getDefaultGeometryProperty().getValue() instanceof Point));
            }
        }
    }

    @Test
    public void testReProjection() throws Exception {
        ResourcePool pool = ResourcePool.create((Catalog)this.getCatalog());
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(LONG_LAT_NO_GEOM_ON_THE_FLY_QNAME_REPROJECTED.getNamespaceURI(), LONG_LAT_NO_GEOM_ON_THE_FLY_QNAME_REPROJECTED.getLocalPart());
        FeatureSource retyped = pool.getFeatureSource(info, null);
        CoordinateReferenceSystem reprojected = CRS.decode((String)"EPSG:900913");
        try (FeatureIterator iterator = retyped.getFeatures().features();){
            while (iterator.hasNext()) {
                Feature feature = iterator.next();
                Assert.assertFalse((boolean)CRS.isTransformationRequired((CoordinateReferenceSystem)reprojected, (CoordinateReferenceSystem)feature.getType().getCoordinateReferenceSystem()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCQLFilter() throws Exception {
        ResourcePool pool = ResourcePool.create((Catalog)this.getCatalog());
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(LONG_LAT_NO_GEOM_ON_THE_FLY_QNAME.getNamespaceURI(), LONG_LAT_NO_GEOM_ON_THE_FLY_QNAME.getLocalPart());
        pool.getFeatureType(info);
        info.setCqlFilter("data = 'd1'");
        this.getCatalog().save((ResourceInfo)info);
        FeatureSource retyped = pool.getFeatureSource(info, null);
        try {
            int count = retyped.getFeatures().size();
            Assert.assertEquals((long)1L, (long)count);
        }
        finally {
            info.setCqlFilter(null);
            this.getCatalog().save((ResourceInfo)info);
        }
    }

    public static class RetypeHelper {
        public static Logger LOGGER = Logger.getLogger(RetypeHelper.class.getCanonicalName());
        private final GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();

        public SimpleFeature generateGeometry(FeatureTypeInfo info, SimpleFeatureType schema, SimpleFeature simpleFeature) {
            if (simpleFeature != null) {
                try {
                    SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(schema);
                    Double x = Double.valueOf(this.getAsString(simpleFeature, "lon"));
                    Double y = Double.valueOf(this.getAsString(simpleFeature, "lat"));
                    Point point = this.geometryFactory.createPoint(new Coordinate(x.doubleValue(), y.doubleValue()));
                    point.setSRID(4326);
                    featureBuilder.add((Object)point);
                    for (Property prop : simpleFeature.getProperties()) {
                        featureBuilder.set(prop.getName(), prop.getValue());
                    }
                    simpleFeature = featureBuilder.buildFeature(simpleFeature.getID());
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            return simpleFeature;
        }

        private String getAsString(SimpleFeature simpleFeature, String name) {
            return Optional.ofNullable(simpleFeature.getProperty(name)).flatMap(property -> Optional.ofNullable(property.getValue())).map(Object::toString).orElseThrow(() -> new IllegalArgumentException(String.format("cannot get value of property [%s]", name)));
        }

        public SimpleFeatureType defineGeometryAttributeFor(FeatureTypeInfo info, SimpleFeatureType src) throws Exception {
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            builder.setName(src.getName());
            builder.setCRS(CRS.decode((String)"EPSG:4326"));
            builder.add("GENERATED_POINT", Point.class);
            for (AttributeDescriptor ad : src.getAttributeDescriptors()) {
                if (ad.getLocalName().equalsIgnoreCase("GENERATED_POINT")) continue;
                builder.add(ad);
            }
            SimpleFeatureType simpleFeatureType = builder.buildFeatureType();
            return simpleFeatureType;
        }

        public Query convertQuery(FeatureTypeInfo info, Query query) {
            Query q = new Query(query);
            List<Object> properties = new ArrayList();
            try {
                if (query.getPropertyNames() == null) {
                    properties = info.getFeatureType().getDescriptors().stream().filter(propertyDescriptor -> !propertyDescriptor.getName().toString().equals("GENERATED_POINT")).map(propertyDescriptor -> propertyDescriptor.getName().toString()).collect(Collectors.toList());
                } else {
                    LinkedList<String> existingProperties = new LinkedList<String>(Arrays.asList(query.getPropertyNames()));
                    existingProperties.remove("GENERATED_POINT");
                    if (!existingProperties.contains("lon")) {
                        existingProperties.add("lon");
                    }
                    if (!existingProperties.contains("lat")) {
                        existingProperties.add("lat");
                    }
                    properties = new ArrayList<String>(existingProperties);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred when converting the query for re-typed tyoe " + info.getName(), e);
            }
            q.setPropertyNames(properties);
            return q;
        }
    }

    public static class TestRetypedFeatureCollection
    extends DecoratingSimpleFeatureCollection {
        private final FeatureTypeInfo featureTypeInfo;
        private final SimpleFeatureType schema;

        TestRetypedFeatureCollection(SimpleFeatureCollection delegate, FeatureTypeInfo featureTypeInfo, SimpleFeatureType schema) {
            super(delegate);
            this.featureTypeInfo = featureTypeInfo;
            this.schema = schema;
        }

        public SimpleFeatureType getSchema() {
            return this.schema;
        }

        public SimpleFeatureIterator features() {
            return new GeometryGenerationCollectionIterator(super.features());
        }

        private class GeometryGenerationCollectionIterator
        implements SimpleFeatureIterator {
            private final SimpleFeatureIterator delegate;
            RetypeHelper converter = new RetypeHelper();

            private GeometryGenerationCollectionIterator(SimpleFeatureIterator delegate) {
                this.delegate = delegate;
            }

            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            public SimpleFeature next() throws NoSuchElementException {
                SimpleFeature feature = (SimpleFeature)this.delegate.next();
                return this.converter.generateGeometry(TestRetypedFeatureCollection.this.featureTypeInfo, TestRetypedFeatureCollection.this.schema, feature);
            }

            public void close() {
                this.delegate.close();
            }
        }
    }

    public static class TestRetypedSource
    extends DecoratingSimpleFeatureSource {
        private final FeatureTypeInfo featureTypeInfo;
        SimpleFeatureSource delegate;
        RetypeHelper converter = new RetypeHelper();

        public TestRetypedSource(FeatureTypeInfo featureTypeInfo, SimpleFeatureSource delegate) {
            super(delegate);
            this.featureTypeInfo = featureTypeInfo;
            this.delegate = delegate;
        }

        public SimpleFeatureType getSchema() {
            SimpleFeatureType src = super.getSchema();
            try {
                return this.converter.defineGeometryAttributeFor(this.featureTypeInfo, src);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error in TestRetypedSource.getSchema while adding Geometry attribute to  schema:" + src.getName(), e);
                return src;
            }
        }

        public SimpleFeatureCollection getFeatures() throws IOException {
            SimpleFeatureCollection features = this.getFeatures(Query.ALL);
            return new TestRetypedFeatureCollection(features, this.featureTypeInfo, this.getSchema());
        }

        public SimpleFeatureCollection getFeatures(Filter srcFilter) throws IOException {
            Query query = new Query(Query.ALL);
            query.setFilter(srcFilter);
            Query newQuery = this.converter.convertQuery(this.featureTypeInfo, query);
            SimpleFeatureCollection features = super.getFeatures(newQuery);
            return new TestRetypedFeatureCollection(features, this.featureTypeInfo, this.getSchema());
        }

        public SimpleFeatureCollection getFeatures(Query srcQuery) throws IOException {
            Query newQuery = this.converter.convertQuery(this.featureTypeInfo, srcQuery);
            SimpleFeatureCollection features = super.getFeatures(newQuery);
            return new TestRetypedFeatureCollection(features, this.featureTypeInfo, this.getSchema());
        }

        public int getCount(Query srcQuery) throws IOException {
            Query newQuery = this.converter.convertQuery(this.featureTypeInfo, srcQuery);
            return super.getCount(newQuery);
        }
    }

    public static class TestRetypeFeatureTypeCallback
    implements RetypeFeatureTypeCallback {
        public static Logger LOGGER = Logger.getLogger(TestRetypeFeatureTypeCallback.class.getCanonicalName());
        public static final String RETYPED = "RETYPED";
        public static final String RETYPED_GEOM_COLUMN = "GENERATED_POINT";
        public static final String LONG_FIELD = "lon";
        public static final String LAT_FIELD = "lat";
        public static final int EPSG_CODE = 4326;

        public FeatureType retypeFeatureType(FeatureTypeInfo featureTypeInfo, FeatureType src) {
            try {
                CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
                SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                builder.setName(src.getName());
                builder.setCRS(crs);
                builder.add(RETYPED_GEOM_COLUMN, Point.class);
                for (PropertyDescriptor ad : src.getDescriptors()) {
                    builder.add((AttributeDescriptor)ad);
                }
                SimpleFeatureType newType = builder.buildFeatureType();
                newType.getUserData().put(RETYPED, true);
                return newType;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error in TestRetypeFeatureTypeCallback:retypeFeatureType", e);
                return src;
            }
        }

        public <T extends FeatureType, U extends Feature> FeatureSource<T, U> wrapFeatureSource(FeatureTypeInfo featureTypeInfo, FeatureSource<T, U> featureSource) {
            TestRetypedSource wrapped = new TestRetypedSource(featureTypeInfo, (SimpleFeatureSource)featureSource);
            return wrapped;
        }
    }
}

