/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.CascadeRemovalReporter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CascadeVisitorAbstractTest;
import org.geoserver.data.test.MockData;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;

public class CascadeRemovalReporterTest
extends CascadeVisitorAbstractTest {
    public void setNativeBox(Catalog catalog, String name) throws Exception {
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(name);
        fti.setNativeBoundingBox(fti.getFeatureSource(null, null).getBounds());
        fti.setLatLonBoundingBox(new ReferencedEnvelope((Envelope)fti.getNativeBoundingBox(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        catalog.save((ResourceInfo)fti);
    }

    @Test
    public void testCascadeLayer() {
        Catalog catalog = this.getCatalog();
        CascadeRemovalReporter visitor = new CascadeRemovalReporter(catalog);
        String name = this.getLayerId(MockData.LAKES);
        LayerInfo layer = catalog.getLayerByName(name);
        Assert.assertNotNull((Object)layer);
        visitor.visit(layer);
        Assert.assertEquals((long)4L, (long)visitor.getObjects(null, new CascadeRemovalReporter.ModificationType[0]).size());
        Assert.assertEquals((Object)catalog.getLayerByName(name), visitor.getObjects(LayerInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE}).get(0));
        Assert.assertEquals((Object)catalog.getResourceByName(name, ResourceInfo.class), visitor.getObjects(ResourceInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE}).get(0));
        Assert.assertTrue((boolean)visitor.getObjects(LayerGroupInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.GROUP_CHANGED}).contains(catalog.getLayerGroupByName("lakesGroup")));
        Assert.assertTrue((boolean)visitor.getObjects(LayerGroupInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.GROUP_CHANGED}).contains(catalog.getLayerGroupByName("nestGroup")));
    }

    @Test
    public void testCascadeStore() {
        Catalog catalog = this.getCatalog();
        CascadeRemovalReporter visitor = new CascadeRemovalReporter(catalog);
        String citeStore = MockData.CITE_PREFIX;
        StoreInfo store = catalog.getStoreByName(citeStore, StoreInfo.class);
        String buildings = this.getLayerId(MockData.BUILDINGS);
        String lakes = this.getLayerId(MockData.LAKES);
        LayerInfo bl = catalog.getLayerByName(buildings);
        ResourceInfo br = catalog.getResourceByName(buildings, ResourceInfo.class);
        LayerInfo ll = catalog.getLayerByName(lakes);
        ResourceInfo lr = catalog.getResourceByName(lakes, ResourceInfo.class);
        visitor.visit((DataStoreInfo)store);
        Assert.assertEquals((Object)store, visitor.getObjects(StoreInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE}).get(0));
        List layers = visitor.getObjects(LayerInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE});
        Assert.assertTrue((boolean)layers.contains(bl));
        Assert.assertTrue((boolean)layers.contains(ll));
        List resources = visitor.getObjects(ResourceInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE});
        Assert.assertTrue((boolean)resources.contains(br));
        Assert.assertTrue((boolean)resources.contains(lr));
    }

    @Test
    public void testCascadeWorkspace() {
        Catalog catalog = this.getCatalog();
        CascadeRemovalReporter visitor = new CascadeRemovalReporter(catalog);
        WorkspaceInfo ws = catalog.getWorkspaceByName(MockData.CITE_PREFIX);
        Assert.assertNotNull((Object)ws);
        List stores = this.getCatalog().getStoresByWorkspace(ws, StoreInfo.class);
        List styles = this.getCatalog().getStylesByWorkspace(ws);
        List layerGroups = this.getCatalog().getLayerGroupsByWorkspace(ws);
        ArrayList<LayerGroupInfo> changedLayerGroups = new ArrayList<LayerGroupInfo>();
        List totalLayerGroups = this.getCatalog().getLayerGroups();
        for (LayerGroupInfo info : totalLayerGroups) {
            List layers = info.getLayers();
            int size = this.countStores(info, stores);
            if (size == layers.size()) {
                if (layerGroups.contains(info)) continue;
                layerGroups.add(info);
                continue;
            }
            changedLayerGroups.add(info);
        }
        ws.accept((CatalogVisitor)visitor);
        Assert.assertTrue((boolean)stores.containsAll(visitor.getObjects(StoreInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE})));
        Assert.assertTrue((boolean)styles.containsAll(visitor.getObjects(StyleInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE})));
        Assert.assertTrue((boolean)layerGroups.containsAll(visitor.getObjects(LayerGroupInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE})));
        Assert.assertTrue((boolean)changedLayerGroups.containsAll(visitor.getObjects(LayerGroupInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.GROUP_CHANGED})));
    }

    private int countStores(LayerGroupInfo lg, List<StoreInfo> stores) {
        List layers = lg.getLayers();
        int size = 0;
        for (PublishedInfo l : layers) {
            if (l instanceof LayerInfo) {
                if (!stores.contains(((LayerInfo)l).getResource().getStore())) continue;
                ++size;
                continue;
            }
            if (!(l instanceof LayerGroupInfo) || this.countStores((LayerGroupInfo)l, stores) != ((LayerGroupInfo)l).getLayers().size()) continue;
            ++size;
        }
        return size;
    }

    @Test
    public void testCascadeStyle() {
        Catalog catalog = this.getCatalog();
        CascadeRemovalReporter visitor = new CascadeRemovalReporter(catalog);
        StyleInfo style = catalog.getStyleByName(MockData.LAKES.getLocalPart());
        LayerInfo buildings = catalog.getLayerByName(this.getLayerId(MockData.BUILDINGS));
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        visitor.visit(style);
        Assert.assertEquals((Object)style, visitor.getObjects(StyleInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE}).get(0));
        Assert.assertEquals((Object)lakes, visitor.getObjects(LayerInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.STYLE_RESET}).get(0));
        Assert.assertEquals((Object)buildings, visitor.getObjects(LayerInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.EXTRA_STYLE_REMOVED}).get(0));
    }
}

