/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import javax.media.jai.ImageLayout;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.TestHttpClientProvider;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.testreader.CustomFormat;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.MockTestData;
import org.geoserver.test.GeoServerMockTestSupport;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.http.HTTPClient;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Point;

public class CatalogBuilderTest
extends GeoServerMockTestSupport {
    @Override
    protected MockTestData createTestData() throws Exception {
        MockTestData testData = new MockTestData();
        testData.setIncludeRaster(true);
        return testData;
    }

    @Test
    public void testFeatureTypeNoSRS() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.BRIDGES.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.BRIDGES));
        Assert.assertEquals((Object)"EPSG:404000", (Object)fti.getSRS());
        Assert.assertNull((Object)fti.getNativeCRS());
        Assert.assertNull((Object)fti.getNativeBoundingBox());
        Assert.assertNull((Object)fti.getLatLonBoundingBox());
        cb.setupBounds((ResourceInfo)fti);
        Assert.assertNotNull((Object)fti.getNativeBoundingBox());
        Assert.assertNull((Object)fti.getNativeBoundingBox().getCoordinateReferenceSystem());
        Assert.assertNotNull((Object)fti.getLatLonBoundingBox());
    }

    @Test
    public void testGetBoundsFromCRS() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.LINES.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.LINES));
        CoordinateReferenceSystem resourceCRS = fti.getCRS();
        Assert.assertNotNull((Object)resourceCRS);
        Assert.assertEquals((Object)"EPSG:32615", (Object)fti.getSRS());
        ReferencedEnvelope crsBounds = cb.getBoundsFromCRS((ResourceInfo)fti);
        Assert.assertNotNull((Object)crsBounds);
        CoordinateReferenceSystem exptectedCRS = CRS.decode((String)"EPSG:32615");
        Assert.assertEquals((Object)new ReferencedEnvelope(CRS.getEnvelope((CoordinateReferenceSystem)exptectedCRS)), (Object)crsBounds);
        fti.setSRS("EPSG:4326");
        fti.setProjectionPolicy(ProjectionPolicy.NONE);
        crsBounds = cb.getBoundsFromCRS((ResourceInfo)fti);
        Assert.assertEquals((Object)new ReferencedEnvelope(CRS.getEnvelope((CoordinateReferenceSystem)exptectedCRS)), (Object)crsBounds);
        fti.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        crsBounds = cb.getBoundsFromCRS((ResourceInfo)fti);
        Assert.assertNotEquals((Object)new ReferencedEnvelope(CRS.getEnvelope((CoordinateReferenceSystem)exptectedCRS)), (Object)crsBounds);
        CoordinateReferenceSystem crs4326 = CRS.decode((String)"EPSG:4326");
        Assert.assertEquals((Object)new ReferencedEnvelope(CRS.getEnvelope((CoordinateReferenceSystem)crs4326)), (Object)crsBounds);
        fti.setProjectionPolicy(ProjectionPolicy.REPROJECT_TO_DECLARED);
        Assert.assertEquals((Object)new ReferencedEnvelope(CRS.getEnvelope((CoordinateReferenceSystem)crs4326)), (Object)crsBounds);
    }

    @Test
    public void testFindNativeCRS() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.LINES.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.LINES));
        CoordinateReferenceSystem resourceCRS = fti.getCRS();
        Assert.assertNotNull((Object)resourceCRS);
        Assert.assertEquals((Object)"EPSG:32615", (Object)fti.getSRS());
        fti.setNativeCRS(CRS.decode((String)"EPSG:26713"));
        Assert.assertEquals((Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)cb.getNativeCRS((ResourceInfo)fti), (boolean)false), (Object)32615);
    }

    @Test
    public void testFeatureType() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.LINES.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.LINES));
        Assert.assertEquals((Object)"EPSG:32615", (Object)fti.getSRS());
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:32615", (boolean)true), (Object)fti.getCRS());
        Assert.assertNull((Object)fti.getNativeBoundingBox());
        Assert.assertNull((Object)fti.getLatLonBoundingBox());
        cb.setupBounds((ResourceInfo)fti);
        Assert.assertNotNull((Object)fti.getNativeBoundingBox());
        Assert.assertNotNull((Object)fti.getNativeBoundingBox().getCoordinateReferenceSystem());
        Assert.assertNotNull((Object)fti.getLatLonBoundingBox());
    }

    @Test
    public void testGenericStyle() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.GENERICENTITY.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.GENERICENTITY));
        LayerInfo li = cb.buildLayer(fti);
        Assert.assertEquals((Object)"generic", (Object)li.getDefaultStyle().getName());
    }

    @Test
    public void testGeometryless() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.GEOMETRYLESS.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.GEOMETRYLESS));
        LayerInfo layer = cb.buildLayer(fti);
        cb.setupBounds((ResourceInfo)fti);
        Assert.assertEquals((Object)"EPSG:404000", (Object)fti.getSRS());
        Assert.assertNotNull((Object)fti.getNativeBoundingBox());
        Assert.assertTrue((boolean)fti.getNativeBoundingBox().isEmpty());
        Assert.assertNotNull((Object)fti.getLatLonBoundingBox());
        Assert.assertFalse((boolean)fti.getLatLonBoundingBox().isEmpty());
        Assert.assertNull((Object)layer.getDefaultStyle());
    }

    @Test
    public void testSingleBandedCoverage() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getCoverageStoreByName(MockData.TASMANIA_DEM.getLocalPart()));
        CoverageInfo ci = cb.buildCoverage();
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326", (boolean)true), (Object)ci.getCRS());
        Assert.assertEquals((Object)"EPSG:4326", (Object)ci.getSRS());
        Assert.assertNotNull((Object)ci.getNativeCRS());
        Assert.assertNotNull((Object)ci.getNativeBoundingBox());
        Assert.assertNotNull((Object)ci.getLatLonBoundingBox());
        List dimensions = ci.getDimensions();
        Assert.assertEquals((long)1L, (long)dimensions.size());
        CoverageDimensionInfo dimension = (CoverageDimensionInfo)dimensions.get(0);
        Assert.assertEquals((Object)"GRAY_INDEX", (Object)dimension.getName());
        Assert.assertEquals((long)1L, (long)dimension.getNullValues().size());
        Assert.assertEquals((double)-9999.0, (double)((Double)dimension.getNullValues().get(0)), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)dimension.getRange().getMinimum(), (double)0.0);
        Assert.assertNull((Object)dimension.getUnit());
    }

    @Test
    public void testInitCoverageSRSLookup_GEOS8973() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getCoverageStoreByName(MockData.WORLD.getLocalPart()));
        CoverageInfo cinfo = cb.buildCoverage();
        cinfo.setSRS(null);
        String wkt = "GEOGCS[\"ED50\",\n  DATUM[\"European Datum 1950\",\n  SPHEROID[\"International 1924\", 6378388.0, 297.0]],\nPRIMEM[\"Greenwich\", 0.0],\nUNIT[\"degree\", 0.017453292519943295]]";
        CoordinateReferenceSystem testCRS = CRS.parseWKT((String)wkt);
        cinfo.setNativeCRS(testCRS);
        cb.initCoverage(cinfo, "srs lookup");
        Assert.assertEquals((Object)"EPSG:4230", (Object)cinfo.getSRS());
    }

    @Test
    public void testInitCoverage_DoesntOverwriteSRS() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getCoverageStoreByName(MockData.WORLD.getLocalPart()));
        CoverageInfo cinfo = cb.buildCoverage();
        cinfo.setNativeCRS(CRS.decode((String)"EPSG:26713"));
        cinfo.setSRS("EPSG:4230");
        cinfo.setProjectionPolicy(ProjectionPolicy.REPROJECT_TO_DECLARED);
        cb.initCoverage(cinfo, "srs given");
        Assert.assertEquals((Object)"EPSG:4230", (Object)cinfo.getSRS());
        Assert.assertEquals((Object)ProjectionPolicy.REPROJECT_TO_DECLARED, (Object)cinfo.getProjectionPolicy());
    }

    @Test
    public void testCoverageNativeSRSLookup() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getCoverageStoreByName(MockData.WORLD.getLocalPart()));
        CoverageInfo cinfo = cb.buildCoverage();
        cinfo.setNativeCRS(CRS.decode((String)"EPSG:26713"));
        cinfo.setSRS("EPSG:26713");
        Assert.assertEquals((Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)cb.getNativeCRS((ResourceInfo)cinfo), (boolean)false), (Object)4326);
    }

    @Test
    public void testNativeBoundsDefensiveCopy() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getCoverageStoreByName(MockData.TASMANIA_DEM.getLocalPart()));
        CoverageInfo ci = cb.buildCoverage();
        ReferencedEnvelope nativeBounds = ci.getNativeBoundingBox();
        for (ProjectionPolicy pp : ProjectionPolicy.values()) {
            ci.setProjectionPolicy(pp);
            ReferencedEnvelope bbox = ci.boundingBox();
            Assert.assertNotSame((Object)nativeBounds, (Object)bbox);
        }
    }

    @Test
    public void testBoundingBoxGeneration() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getCoverageStoreByName(MockData.TASMANIA_DEM.getLocalPart()));
        CoverageInfo ci = cb.buildCoverage();
        ReferencedEnvelope bbox = ci.getNativeBoundingBox();
        Assert.assertNotNull((Object)bbox.getCoordinateReferenceSystem());
        ci.setNativeBoundingBox(ReferencedEnvelope.create((Bounds)bbox, null));
        Assert.assertEquals((Object)ci.getNativeCRS(), (Object)ci.boundingBox().getCoordinateReferenceSystem());
        ci.setNativeBoundingBox(null);
        ci.setSRS(null);
        Assert.assertNull((Object)ci.boundingBox());
    }

    @Test
    public void testSingleBandedCoverage_GEOS7311() throws Exception {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(new Locale("es", "ES"));
        this.testSingleBandedCoverage();
        Locale.setDefault(new Locale("fr", "FR"));
        this.testSingleBandedCoverage();
        Locale.setDefault(defaultLocale);
    }

    @Test
    public void testMultiBandCoverage() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getCoverageStoreByName(MockData.TASMANIA_BM.getLocalPart()));
        CoverageInfo ci = cb.buildCoverage();
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326", (boolean)true), (Object)ci.getCRS());
        Assert.assertEquals((Object)"EPSG:4326", (Object)ci.getSRS());
        Assert.assertNotNull((Object)ci.getNativeCRS());
        Assert.assertNotNull((Object)ci.getNativeBoundingBox());
        Assert.assertNotNull((Object)ci.getLatLonBoundingBox());
        List dimensions = ci.getDimensions();
        Assert.assertEquals((long)3L, (long)dimensions.size());
        CoverageDimensionInfo dimension = (CoverageDimensionInfo)dimensions.get(0);
        Assert.assertEquals((Object)"RED_BAND", (Object)dimension.getName());
        Assert.assertEquals((long)0L, (long)dimension.getNullValues().size());
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)dimension.getRange().getMinimum(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)dimension.getRange().getMaximum(), (double)0.0);
        Assert.assertEquals((Object)"W.m-2.Sr-1", (Object)dimension.getUnit());
    }

    @Test
    public void testEmptyBounds() throws Exception {
        Catalog cat = this.getCatalog();
        FeatureTypeInfo fti = cat.getFeatureTypeByName(this.toString(MockData.POINTS));
        Assert.assertEquals(Point.class, (Object)fti.getFeatureType().getGeometryDescriptor().getType().getBinding());
        Assert.assertEquals((long)1L, (long)fti.getFeatureSource(null, null).getCount(Query.ALL));
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore(cat.getStoreByName(MockData.CGF_PREFIX, DataStoreInfo.class));
        FeatureTypeInfo built = cb.buildFeatureType(fti.getQualifiedName());
        cb.setupBounds((ResourceInfo)built);
        Assert.assertTrue((built.getNativeBoundingBox().getWidth() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((built.getNativeBoundingBox().getHeight() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testEmptyLayerGroupBounds() throws Exception {
        Catalog cat = this.getCatalog();
        LayerGroupInfo group = cat.getFactory().createLayerGroup();
        group.setName("empty_group");
        Assert.assertNull((Object)group.getBounds());
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.calculateLayerGroupBounds(group);
        Assert.assertNull((Object)group.getBounds());
    }

    @Test
    public void testLayerGroupBounds() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.LINES.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.LINES));
        cb.setupBounds((ResourceInfo)fti);
        LayerInfo layer = cat.getFactory().createLayer();
        layer.setResource((ResourceInfo)fti);
        layer.setName(fti.getName());
        layer.setEnabled(true);
        layer.setType(PublishedType.VECTOR);
        LayerGroupInfo group = cat.getFactory().createLayerGroup();
        group.setName("group");
        group.getLayers().add(layer);
        group.getStyles().add(null);
        Assert.assertNull((Object)group.getBounds());
        cb.calculateLayerGroupBounds(group);
        Assert.assertNotNull((Object)group.getBounds());
        Assert.assertEquals((Object)fti.getNativeBoundingBox(), (Object)group.getBounds());
    }

    @Test
    public void testLayerGroupEoBounds() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.LINES.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.LINES));
        cb.setupBounds((ResourceInfo)fti);
        LayerInfo layer = cat.getFactory().createLayer();
        layer.setResource((ResourceInfo)fti);
        layer.setName(fti.getName());
        layer.setEnabled(true);
        layer.setType(PublishedType.VECTOR);
        LayerGroupInfo group = cat.getFactory().createLayerGroup();
        group.setMode(LayerGroupInfo.Mode.EO);
        group.setName("group_EO");
        group.setRootLayer(layer);
        Assert.assertNull((Object)group.getBounds());
        cb.calculateLayerGroupBounds(group);
        Assert.assertNotNull((Object)group.getBounds());
        Assert.assertEquals((Object)fti.getNativeBoundingBox(), (Object)group.getBounds());
    }

    @Test
    public void testWMS() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable(LOGGER)) {
            LOGGER.warning("Remote OWS tests disabled, skipping catalog builder wms tests");
            return;
        }
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        WMSStoreInfo wms = cb.buildWMSStore("demo");
        wms.setCapabilitiesURL("http://demo.opengeo.org/geoserver/wms?service=WMS&request=GetCapabilities&version=1.1.0");
        cb.setStore((StoreInfo)wms);
        WMSLayerInfo wmsLayer = cb.buildWMSLayer("topp:states");
        this.assertWMSLayer(wmsLayer);
        LayerInfo layer = cb.buildLayer(wmsLayer);
        Assert.assertEquals((Object)PublishedType.WMS, (Object)layer.getType());
        wmsLayer = cat.getFactory().createWMSLayer();
        wmsLayer.setName("states");
        wmsLayer.setNativeName("topp:states");
        cb.initWMSLayer(wmsLayer);
        this.assertWMSLayer(wmsLayer);
    }

    void assertWMSLayer(WMSLayerInfo wmsLayer) throws Exception {
        Assert.assertEquals((Object)"states", (Object)wmsLayer.getName());
        Assert.assertEquals((Object)"topp:states", (Object)wmsLayer.getNativeName());
        Assert.assertEquals((Object)"EPSG:4326", (Object)wmsLayer.getSRS());
        Assert.assertEquals((Object)"USA Population", (Object)wmsLayer.getTitle());
        Assert.assertEquals((Object)"2000 census data for United States.", (Object)wmsLayer.getAbstract());
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)wmsLayer.getNativeCRS());
        Assert.assertNotNull((Object)wmsLayer.getNativeBoundingBox());
        Assert.assertNotNull((Object)wmsLayer.getLatLonBoundingBox());
        Assert.assertFalse((boolean)wmsLayer.getKeywords().isEmpty());
    }

    @Test
    public void testLookupSRSDetached() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        DataStoreInfo sf = cat.getDataStoreByName("sf");
        FeatureSource fs = sf.getDataStore(null).getFeatureSource(this.toName(MockData.PRIMITIVEGEOFEATURE));
        FeatureTypeInfo ft = cat.getFactory().createFeatureType();
        ft.setNativeName("PrimitiveGeoFeature");
        Assert.assertNull((Object)ft.getSRS());
        Assert.assertNull((Object)ft.getCRS());
        cb.lookupSRS(ft, fs, true);
        Assert.assertNotNull((Object)ft.getSRS());
        Assert.assertNotNull((Object)ft.getCRS());
    }

    @Test
    public void testSetupBoundsDetached() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        DataStoreInfo sf = cat.getDataStoreByName("sf");
        FeatureSource fs = sf.getDataStore(null).getFeatureSource(this.toName(MockData.PRIMITIVEGEOFEATURE));
        FeatureTypeInfo ft = cat.getFactory().createFeatureType();
        ft.setNativeName("PrimitiveGeoFeature");
        Assert.assertNull((Object)ft.getNativeBoundingBox());
        Assert.assertNull((Object)ft.getLatLonBoundingBox());
        cb.lookupSRS(ft, fs, true);
        cb.setupBounds(ft, fs);
        Assert.assertNotNull((Object)ft.getNativeBoundingBox());
        Assert.assertNotNull((Object)ft.getLatLonBoundingBox());
    }

    @Test
    public void testMetadataFromFeatueSource() throws Exception {
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        cb.setStore((StoreInfo)cb.buildDataStore("fooStore"));
        FeatureType ft = (FeatureType)EasyMock.createMock(FeatureType.class);
        EasyMock.expect((Object)ft.getName()).andReturn((Object)new NameImpl("foo")).anyTimes();
        EasyMock.expect((Object)ft.getCoordinateReferenceSystem()).andReturn(null).anyTimes();
        EasyMock.expect((Object)ft.getGeometryDescriptor()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{ft});
        org.geotools.api.data.ResourceInfo rInfo = (org.geotools.api.data.ResourceInfo)EasyMock.createMock(org.geotools.api.data.ResourceInfo.class);
        EasyMock.expect((Object)rInfo.getTitle()).andReturn((Object)"foo title");
        EasyMock.expect((Object)rInfo.getDescription()).andReturn((Object)"foo description");
        EasyMock.expect((Object)rInfo.getKeywords()).andReturn(new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz", ""))).anyTimes();
        EasyMock.replay((Object[])new Object[]{rInfo});
        FeatureSource fs = (FeatureSource)EasyMock.createMock(FeatureSource.class);
        EasyMock.expect((Object)fs.getSchema()).andReturn((Object)ft).anyTimes();
        EasyMock.expect((Object)fs.getInfo()).andReturn((Object)rInfo).anyTimes();
        EasyMock.expect((Object)fs.getName()).andReturn((Object)ft.getName()).anyTimes();
        EasyMock.replay((Object[])new Object[]{fs});
        FeatureTypeInfo ftInfo = cb.buildFeatureType(fs);
        Assert.assertEquals((Object)"foo title", (Object)ftInfo.getTitle());
        Assert.assertEquals((Object)"foo description", (Object)ftInfo.getDescription());
        Assert.assertTrue((boolean)ftInfo.getKeywords().contains(new Keyword("foo")));
        Assert.assertTrue((boolean)ftInfo.getKeywords().contains(new Keyword("bar")));
        Assert.assertTrue((boolean)ftInfo.getKeywords().contains(new Keyword("baz")));
    }

    @Test
    public void testSetupMetadataResourceInfoException() throws Exception {
        FeatureTypeInfo ftInfo = (FeatureTypeInfo)EasyMock.createMock(FeatureTypeInfo.class);
        EasyMock.expect((Object)ftInfo.getTitle()).andReturn((Object)"foo");
        EasyMock.expect((Object)ftInfo.getDescription()).andReturn((Object)"foo");
        EasyMock.expect((Object)ftInfo.getKeywords()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{ftInfo});
        FeatureSource fs = (FeatureSource)EasyMock.createMock(FeatureSource.class);
        EasyMock.expect((Object)fs.getInfo()).andThrow((Throwable)new UnsupportedOperationException());
        EasyMock.replay((Object[])new Object[]{fs});
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        cb.setupMetadata(ftInfo, fs);
    }

    @Test
    public void testLatLonBounds() throws Exception {
        ReferencedEnvelope nativeBounds = new ReferencedEnvelope(700000.0, 800000.0, 4000000.0, 4100000.0, null);
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:32632", (boolean)true);
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        ReferencedEnvelope re = cb.getLatLonBounds(nativeBounds, crs);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)re.getCoordinateReferenceSystem());
        Assert.assertEquals((double)11.22, (double)re.getMinX(), (double)0.01);
        Assert.assertEquals((double)36.1, (double)re.getMinY(), (double)0.01);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWMSLayer111() throws Exception {
        TestHttpClientProvider.startTest();
        try {
            String baseURL = "http://mock.test.geoserver.org/wms11";
            MockHttpClient client = new MockHttpClient();
            URL capsURL = new URL(baseURL + "?service=WMS&request=GetCapabilities&version=1.1.0");
            client.expectGet(capsURL, new MockHttpResponse(this.getClass().getResource("caps111.xml"), "text/xml", new String[0]));
            TestHttpClientProvider.bind((HTTPClient)client, (URL)capsURL);
            CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
            WMSStoreInfo store = cb.buildWMSStore("test-store");
            store.setCapabilitiesURL(capsURL.toExternalForm());
            cb.setStore((StoreInfo)store);
            WMSLayerInfo layer = cb.buildWMSLayer("world4326");
            layer.reset();
            Assert.assertEquals((Object)"EPSG:4326", (Object)layer.getSRS());
            ReferencedEnvelope bbox = layer.getLatLonBoundingBox();
            Assert.assertEquals((double)-180.0, (double)bbox.getMinX(), (double)0.0);
            Assert.assertEquals((double)-90.0, (double)bbox.getMinY(), (double)0.0);
            Assert.assertEquals((double)180.0, (double)bbox.getMaxX(), (double)0.0);
            Assert.assertEquals((double)90.0, (double)bbox.getMaxY(), (double)0.0);
            Assert.assertFalse((boolean)layer.availableFormats().isEmpty());
            Assert.assertTrue((boolean)layer.getStyles().isEmpty());
            Assert.assertTrue((boolean)layer.getDefaultStyle().getName().isEmpty());
            layer.setNativeCRS(CRS.decode((String)"EPSG:26713"));
            Assert.assertEquals((Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)cb.getNativeCRS((ResourceInfo)layer), (boolean)false), (Object)4326);
        }
        finally {
            TestHttpClientProvider.endTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWMSLayer130() throws Exception {
        TestHttpClientProvider.startTest();
        try {
            String baseURL = "http://mock.test.geoserver.org/wms13";
            MockHttpClient client = new MockHttpClient();
            URL capsURL = new URL(baseURL + "?service=WMS&request=GetCapabilities&version=1.3.0");
            client.expectGet(capsURL, new MockHttpResponse(this.getClass().getResource("caps130.xml"), "text/xml", new String[0]));
            TestHttpClientProvider.bind((HTTPClient)client, (URL)capsURL);
            CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
            WMSStoreInfo store = cb.buildWMSStore("test-store");
            store.setCapabilitiesURL(capsURL.toExternalForm());
            cb.setStore((StoreInfo)store);
            WMSLayerInfo layer = cb.buildWMSLayer("world4326");
            Assert.assertEquals((Object)"EPSG:4326", (Object)layer.getSRS());
            ReferencedEnvelope bbox = layer.getLatLonBoundingBox();
            Assert.assertEquals((double)-180.0, (double)bbox.getMinX(), (double)0.0);
            Assert.assertEquals((double)-90.0, (double)bbox.getMinY(), (double)0.0);
            Assert.assertEquals((double)180.0, (double)bbox.getMaxX(), (double)0.0);
            Assert.assertEquals((double)90.0, (double)bbox.getMaxY(), (double)0.0);
            Assert.assertFalse((boolean)layer.availableFormats().isEmpty());
            Assert.assertTrue((boolean)layer.getStyles().isEmpty());
            Assert.assertTrue((boolean)layer.getDefaultStyle().getName().isEmpty());
            layer.setNativeCRS(CRS.decode((String)"EPSG:26713"));
            Assert.assertEquals((Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)cb.getNativeCRS((ResourceInfo)layer), (boolean)false), (Object)4326);
        }
        finally {
            TestHttpClientProvider.endTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWMSLayer130crs84() throws Exception {
        TestHttpClientProvider.startTest();
        try {
            String baseURL = "http://mock.test.geoserver.org/wms13";
            MockHttpClient client = new MockHttpClient();
            URL capsURL = new URL(baseURL + "?service=WMS&request=GetCapabilities&version=1.3.0");
            client.expectGet(capsURL, new MockHttpResponse(this.getClass().getResource("caps130_crs84.xml"), "text/xml", new String[0]));
            TestHttpClientProvider.bind((HTTPClient)client, (URL)capsURL);
            CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
            WMSStoreInfo store = cb.buildWMSStore("test-store");
            store.setCapabilitiesURL(capsURL.toExternalForm());
            cb.setStore((StoreInfo)store);
            WMSLayerInfo layer = cb.buildWMSLayer("world4326");
            Assert.assertEquals((Object)"EPSG:4326", (Object)layer.getSRS());
            ReferencedEnvelope bbox = layer.getLatLonBoundingBox();
            Assert.assertEquals((double)-180.0, (double)bbox.getMinX(), (double)0.0);
            Assert.assertEquals((double)-90.0, (double)bbox.getMinY(), (double)0.0);
            Assert.assertEquals((double)180.0, (double)bbox.getMaxX(), (double)0.0);
            Assert.assertEquals((double)90.0, (double)bbox.getMaxY(), (double)0.0);
            Assert.assertFalse((boolean)layer.availableFormats().isEmpty());
            Assert.assertTrue((boolean)layer.getStyles().isEmpty());
            Assert.assertTrue((boolean)layer.getDefaultStyle().getName().isEmpty());
        }
        finally {
            TestHttpClientProvider.endTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWMTSLayer100() throws Exception {
        TestHttpClientProvider.startTest();
        try {
            String baseURL = "http://mock.test.geoserver.org/wmts100";
            MockHttpClient client = new MockHttpClient();
            URL capsURL = new URL(baseURL + "?REQUEST=GetCapabilities&VERSION=1.0.0&SERVICE=WMTS");
            client.expectGet(capsURL, new MockHttpResponse(this.getClass().getResource("nasa.getcapa.xml"), "text/xml", new String[0]));
            TestHttpClientProvider.bind((HTTPClient)client, (URL)capsURL);
            CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
            WMTSStoreInfo store = cb.buildWMTSStore("test-wmts-store");
            store.setCapabilitiesURL(capsURL.toExternalForm());
            cb.setStore((StoreInfo)store);
            WMTSLayerInfo layer = cb.buildWMTSLayer("AMSR2_Wind_Speed_Night");
            Assert.assertEquals((Object)"Wind Speed (Night, AMSR2, GCOM-W1)", (Object)layer.getTitle());
            Assert.assertEquals((Object)"EPSG:4326", (Object)layer.getSRS());
            ReferencedEnvelope bbox = layer.getLatLonBoundingBox();
            Assert.assertEquals((double)-180.0, (double)bbox.getMinX(), (double)0.0);
            Assert.assertEquals((double)-90.0, (double)bbox.getMinY(), (double)0.0);
            Assert.assertEquals((double)180.0, (double)bbox.getMaxX(), (double)0.0);
            Assert.assertEquals((double)90.0, (double)bbox.getMaxY(), (double)0.0);
        }
        finally {
            TestHttpClientProvider.endTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWgs84BoundsFromCompoundCRS() throws Exception {
        try {
            MapProjection.SKIP_SANITY_CHECKS = true;
            CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
            ReferencedEnvelope3D bounds = new ReferencedEnvelope3D(142892.0, 470783.0, 16.0, 142900.0, 470790.0, 20.0, CRS.decode((String)"EPSG:7415"));
            ReferencedEnvelope latLonBounds = cb.getLatLonBounds((ReferencedEnvelope)bounds, bounds.getCoordinateReferenceSystem());
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:4326"), (Object)latLonBounds.getCoordinateReferenceSystem()));
        }
        finally {
            MapProjection.SKIP_SANITY_CHECKS = false;
        }
    }

    @Test
    public void testSetupCoverageOnEmptyRead() throws Exception {
        ReferencedEnvelope envelope = MockTestData.DEFAULT_LATLON_ENVELOPE;
        BufferedImage bi = new BufferedImage(360, 180, 5);
        ImageLayout layout = new ImageLayout((RenderedImage)bi);
        GridEnvelope2D gridRange = new GridEnvelope2D(0, 0, 360, 180);
        GridToEnvelopeMapper mapper = new GridToEnvelopeMapper((GridEnvelope)gridRange, (Bounds)envelope);
        AffineTransform gridToWorld = mapper.createAffineTransform();
        String rasterSource = "http://www.geoserver.org/foo";
        AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)EasyMock.createMock(AbstractGridCoverage2DReader.class);
        AbstractGridFormat format = (AbstractGridFormat)EasyMock.createMock(AbstractGridFormat.class);
        EasyMock.expect((Object)reader.getOriginalEnvelope()).andReturn((Object)new GeneralBounds((Bounds)envelope)).anyTimes();
        EasyMock.expect((Object)reader.getCoordinateReferenceSystem()).andReturn((Object)envelope.getCoordinateReferenceSystem()).anyTimes();
        EasyMock.expect((Object)reader.getOriginalGridRange()).andReturn((Object)gridRange).anyTimes();
        EasyMock.expect((Object)reader.getImageLayout()).andReturn((Object)layout).anyTimes();
        EasyMock.expect((Object)reader.getFormat()).andReturn((Object)format).anyTimes();
        EasyMock.expect((Object)reader.getGridCoverageCount()).andReturn((Object)1);
        EasyMock.expect((Object)reader.getOriginalGridToWorld((PixelInCell)EasyMock.anyObject(PixelInCell.class))).andReturn((Object)new AffineTransform2D(gridToWorld)).anyTimes();
        EasyMock.expect((Object)reader.read((GeneralParameterValue[])EasyMock.anyObject(GeneralParameterValue[].class))).andReturn(null);
        EasyMock.expect((Object)reader.getGridCoverageNames()).andReturn((Object)new String[]{"TheCoverage"});
        EasyMock.replay((Object[])new Object[]{reader});
        EasyMock.expect((Object)format.getReader(EasyMock.eq((Object)"http://www.geoserver.org/foo"), (Hints)EasyMock.anyObject(Hints.class))).andReturn((Object)reader).anyTimes();
        EasyMock.expect((Object)format.getName()).andReturn((Object)"TheFormat").anyTimes();
        EasyMock.expect((Object)format.getReadParameters()).andReturn((Object)new CustomFormat().getReadParameters()).anyTimes();
        EasyMock.replay((Object[])new Object[]{format});
        CoverageStoreInfo csi = (CoverageStoreInfo)EasyMock.createMock(CoverageStoreInfo.class);
        EasyMock.expect((Object)csi.getURL()).andReturn((Object)"http://www.geoserver.org/foo").anyTimes();
        EasyMock.expect((Object)csi.getFormat()).andReturn((Object)format).anyTimes();
        EasyMock.expect((Object)csi.getId()).andReturn((Object)"ThisIsMe").anyTimes();
        EasyMock.expect((Object)csi.getName()).andReturn((Object)"ThisIsMe").anyTimes();
        EasyMock.expect((Object)csi.getWorkspace()).andReturn((Object)this.getCatalog().getDefaultWorkspace()).anyTimes();
        EasyMock.replay((Object[])new Object[]{csi});
        CatalogImpl cat = new CatalogImpl();
        ResourcePool rp = new ResourcePool((Catalog)cat){

            public CoverageStoreInfo clone(CoverageStoreInfo source, boolean allowEnvParametrization) {
                return source;
            }
        };
        cat.setResourcePool(rp);
        CatalogBuilder cb = new CatalogBuilder((Catalog)cat);
        cb.setStore((StoreInfo)csi);
        CoverageInfo ci = cb.buildCoverage();
        Assert.assertEquals((Object)"TheCoverage", (Object)ci.getName());
        List dimensions = ci.getDimensions();
        Assert.assertEquals((long)3L, (long)dimensions.size());
        Assert.assertEquals((Object)"RED_BAND", (Object)((CoverageDimensionInfo)dimensions.get(0)).getName());
        Assert.assertEquals((Object)"GREEN_BAND", (Object)((CoverageDimensionInfo)dimensions.get(1)).getName());
        Assert.assertEquals((Object)"BLUE_BAND", (Object)((CoverageDimensionInfo)dimensions.get(2)).getName());
    }

    @Test
    public void testLookupSRSPlanetary() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.LINES.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.LINES));
        fti.setNativeCRS(CRS.decode((String)"IAU:1000"));
        cb.lookupSRS(fti, false);
        Assert.assertEquals((Object)"IAU:1000", (Object)fti.getSRS());
    }

    @Test
    public void testLookupSRSPlanetaryExtensive() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.LINES.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.LINES));
        String wkt = "GEOGCS[\"Sun (2015) - Sphere / Ocentric\",\n    DATUM[\"Sun (2015) - Sphere\",\n        SPHEROID[\"Sun (2015) - Sphere\",695700000,0,\n            AUTHORITY[\"IAU\",\"1000\"]],\n        AUTHORITY[\"IAU\",\"1000\"]],\n    PRIMEM[\"Reference Meridian\",0,\n        AUTHORITY[\"IAU\",\"1000\"]],\n    UNIT[\"degree\",0.0174532925199433,\n        AUTHORITY[\"EPSG\",\"9122\"]]]";
        CoordinateReferenceSystem crs = CRS.parseWKT((String)wkt);
        fti.setNativeCRS(crs);
        cb.lookupSRS(fti, true);
        Assert.assertEquals((Object)"IAU:1000", (Object)fti.getSRS());
    }

    @Test
    public void testNanNoData() throws Exception {
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        CoverageStoreInfo ratStore = cb.buildCoverageStore("ratStore");
        ratStore.setURL("src/test/resources/org/geoserver/catalog/impl/rat.tiff");
        ratStore.setType("GeoTIFF");
        cb.setStore((StoreInfo)ratStore);
        CoverageInfo rat = cb.buildCoverage();
        Assert.assertEquals((long)1L, (long)rat.getDimensions().size());
        CoverageDimensionInfo dim = (CoverageDimensionInfo)rat.getDimensions().get(0);
        Assert.assertEquals((Object)"GRAY_INDEX", (Object)dim.getName());
        Assert.assertEquals((long)1L, (long)dim.getNullValues().size());
        Assert.assertEquals((double)Double.NaN, (double)((Double)dim.getNullValues().get(0)), (double)0.0);
    }
}

