/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.config.DefaultGeoServerLoader;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.URLs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultGeoServerLoaderTest {
    DefaultGeoServerLoader loader;
    Catalog catalog;
    XStreamPersister xp;
    boolean helloServiceSaved = false;

    @Before
    public void setUp() {
        URL url = DefaultGeoServerLoaderTest.class.getResource("/data_dir/nested_layer_groups");
        GeoServerResourceLoader resourceLoader = new GeoServerResourceLoader(URLs.urlToFile((URL)url)){

            public File createFile(File parentFile, String location) throws IOException {
                if ("hello.xml".equals(location)) {
                    DefaultGeoServerLoaderTest.this.helloServiceSaved = true;
                }
                return super.createFile(parentFile, location);
            }
        };
        GeoServerExtensionsHelper.singleton("resourceLoader", resourceLoader, GeoServerResourceLoader.class);
        this.loader = new DefaultGeoServerLoader(resourceLoader);
        this.catalog = new CatalogImpl();
        this.catalog.setResourceLoader(resourceLoader);
        XStreamPersisterFactory xpf = new XStreamPersisterFactory();
        this.xp = xpf.createXMLPersister();
        HelloServiceXStreamLoader helloLoader = new HelloServiceXStreamLoader(resourceLoader, "hello");
        GeoServerExtensionsHelper.singleton("helloLoader", (Object)helloLoader, XStreamServiceLoader.class);
    }

    @After
    public void tearDown() {
        GeoServerExtensionsHelper.clear();
    }

    @Test
    public void testGeneratedStyles() throws Exception {
        XStreamPersisterFactory xpf = new XStreamPersisterFactory();
        XStreamPersister xp = xpf.createXMLPersister();
        xp.setCatalog(this.catalog);
        this.loader.initializeStyles(this.catalog, xp);
        StyleInfo polygon = this.catalog.getStyleByName("polygon");
        Assert.assertEquals((Object)"default_polygon.sld", (Object)polygon.getFilename());
    }

    @Test
    public void testLoadNestedLayerGroups() throws Exception {
        GeoServerResourceLoader resources = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        Assert.assertSame((Object)this.catalog.getResourceLoader(), (Object)resources);
        this.loader.readCatalog(this.catalog, this.xp);
        LayerGroupInfo simpleLayerGroup = this.catalog.getLayerGroupByName("topp", "simplegroup");
        Assert.assertNotNull((Object)simpleLayerGroup);
        Assert.assertEquals((long)101L, (long)simpleLayerGroup.getAttribution().getLogoWidth());
        Assert.assertEquals((long)102L, (long)simpleLayerGroup.getAttribution().getLogoHeight());
        Assert.assertEquals((long)2L, (long)simpleLayerGroup.getMetadataLinks().size());
        Assert.assertEquals((Object)"http://my/metadata/link/1", (Object)((MetadataLinkInfo)simpleLayerGroup.getMetadataLinks().get(0)).getContent());
        Assert.assertEquals((Object)"text/html", (Object)((MetadataLinkInfo)simpleLayerGroup.getMetadataLinks().get(0)).getType());
        LayerGroupInfo nestedLayerGroup = this.catalog.getLayerGroupByName("topp", "nestedgroup");
        Assert.assertNotNull((Object)nestedLayerGroup);
        Assert.assertNotNull((Object)nestedLayerGroup.getLayers());
        Assert.assertEquals((long)2L, (long)nestedLayerGroup.getLayers().size());
        Assert.assertTrue((boolean)(nestedLayerGroup.getLayers().get(0) instanceof LayerGroupInfo));
        Assert.assertNotNull((Object)((LayerGroupInfo)nestedLayerGroup.getLayers().get(0)).getLayers());
        Assert.assertTrue((boolean)(nestedLayerGroup.getLayers().get(1) instanceof LayerInfo));
    }

    @Test
    public void testLoadWithoutResaving() throws Exception {
        GeoServerImpl gs = new GeoServerImpl();
        gs.setCatalog(this.catalog);
        this.loader.postProcessBeforeInitialization((Object)gs, "geoServer");
        this.loader.reload();
        Assert.assertFalse((String)"hello.xml should not have been saved during load", (boolean)this.helloServiceSaved);
    }

    static final class HelloServiceXStreamLoader
    extends XStreamServiceLoader<HelloServiceInfo> {
        public HelloServiceXStreamLoader(GeoServerResourceLoader resourceLoader, String filenameBase) {
            super(resourceLoader, filenameBase);
        }

        public Class<HelloServiceInfo> getServiceClass() {
            return HelloServiceInfo.class;
        }

        protected HelloServiceInfo createServiceFromScratch(GeoServer gs) {
            return new HelloServiceInfoImpl();
        }
    }

    static final class HelloServiceInfoImpl
    extends ServiceInfoImpl
    implements HelloServiceInfo {
        HelloServiceInfoImpl() {
        }

        public String getType() {
            return "Hello";
        }
    }

    static interface HelloServiceInfo
    extends ServiceInfo {
    }
}

