/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.FileExistsMatcher;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.logging.LoggingInitializer;
import org.geoserver.logging.LoggingUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.SystemTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.w3c.dom.Document;

@Category(value={SystemTest.class})
public class GeoServerPersistersTest
extends GeoServerSystemTestSupport {
    Catalog catalog;

    @Before
    public void initCatalog() {
        this.catalog = this.getCatalog();
    }

    @Before
    public void revertCatalog() throws Exception {
        this.removeLayerGroup(null, "lg");
        this.removeLayerGroup("gs", "lg");
        this.removeLayerGroup("acme", "lg");
        this.removeWorkspace("acme");
        this.removeNamespace("bar");
        this.removeStyle(null, "foostyle");
        this.removeStyle("gs", "foostyle");
        this.removeStyle(null, "boostyle");
        this.getCatalog().setDefaultWorkspace(this.getCatalog().getWorkspaceByName("gs"));
    }

    @Test
    public void testAddWorkspace() throws Exception {
        File ws = new File(testData.getDataDirectoryRoot(), "workspaces/acme");
        Assert.assertFalse((boolean)ws.exists());
        WorkspaceInfo acme = this.catalog.getFactory().createWorkspace();
        acme.setName("acme");
        this.catalog.add(acme);
        Assert.assertTrue((boolean)ws.exists());
    }

    @Test
    public void testRemoveWorkspace() throws Exception {
        this.testAddWorkspace();
        File ws = new File(testData.getDataDirectoryRoot(), "workspaces/acme");
        Assert.assertTrue((boolean)ws.exists());
        WorkspaceInfo acme = this.catalog.getWorkspaceByName("acme");
        this.catalog.remove(acme);
        Assert.assertFalse((boolean)ws.exists());
    }

    @Test
    public void testDefaultWorkspace() throws Exception {
        this.testAddWorkspace();
        WorkspaceInfo ws = this.catalog.getWorkspaceByName("acme");
        this.catalog.setDefaultWorkspace(ws);
        File dws = new File(testData.getDataDirectoryRoot(), "workspaces/default.xml");
        Assert.assertTrue((boolean)dws.exists());
        Document dom = this.dom(dws);
        XMLAssert.assertXpathEvaluatesTo((String)"acme", (String)"/workspace/name", (Document)dom);
    }

    @Test
    public void testAddDataStore() throws Exception {
        this.testAddWorkspace();
        File dir = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore");
        Assert.assertFalse((boolean)dir.exists());
        DataStoreInfo ds = this.catalog.getFactory().createDataStore();
        ds.setName("foostore");
        ds.setWorkspace(this.catalog.getWorkspaceByName("acme"));
        this.catalog.add((StoreInfo)ds);
        Assert.assertTrue((boolean)dir.exists());
        Assert.assertTrue((boolean)new File(dir, "datastore.xml").exists());
    }

    @Test
    public void testModifyDataStore() throws Exception {
        this.testAddDataStore();
        DataStoreInfo ds = this.catalog.getDataStoreByName("acme", "foostore");
        Assert.assertTrue((boolean)ds.getConnectionParameters().isEmpty());
        ds.getConnectionParameters().put("foo", "bar");
        this.catalog.save((StoreInfo)ds);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/datastore.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathExists((String)"/dataStore/connectionParameters/entry[@key='foo']", (Document)dom);
    }

    @Test
    public void testChangeDataStoreWorkspace() throws Exception {
        this.testAddDataStore();
        File f1 = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/datastore.xml");
        Assert.assertTrue((boolean)f1.exists());
        WorkspaceInfo nws = this.catalog.getFactory().createWorkspace();
        nws.setName("topp");
        this.catalog.add(nws);
        DataStoreInfo ds = this.catalog.getDataStoreByName("acme", "foostore");
        ds.setWorkspace(nws);
        this.catalog.save((StoreInfo)ds);
        Assert.assertFalse((boolean)f1.exists());
        File f2 = new File(testData.getDataDirectoryRoot(), "workspaces/topp/foostore/datastore.xml");
        Assert.assertTrue((boolean)f2.exists());
    }

    @Test
    public void testRemoveDataStore() throws Exception {
        this.testAddDataStore();
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore");
        Assert.assertTrue((boolean)f.exists());
        DataStoreInfo ds = this.catalog.getDataStoreByName("acme", "foostore");
        this.catalog.remove((StoreInfo)ds);
        Assert.assertFalse((boolean)f.exists());
    }

    @Test
    public void testAddFeatureType() throws Exception {
        this.testAddDataStore();
        File d = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo");
        Assert.assertFalse((boolean)d.exists());
        NamespaceInfo ns = this.catalog.getFactory().createNamespace();
        ns.setPrefix("bar");
        ns.setURI("http://bar");
        this.catalog.add(ns);
        FeatureTypeInfo ft = this.catalog.getFactory().createFeatureType();
        ft.setName("foo");
        ft.setNamespace(ns);
        ft.setStore((StoreInfo)this.catalog.getDataStoreByName("acme", "foostore"));
        this.catalog.add((ResourceInfo)ft);
        Assert.assertTrue((boolean)d.exists());
    }

    @Test
    public void testChangeFeatureTypeStore() throws Exception {
        this.testAddFeatureType();
        File f1 = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo/featuretype.xml");
        Assert.assertTrue((boolean)f1.exists());
        DataStoreInfo ds = this.catalog.getFactory().createDataStore();
        ds.setName("barstore");
        ds.setWorkspace(this.catalog.getWorkspaceByName("acme"));
        this.catalog.add((StoreInfo)ds);
        FeatureTypeInfo ft = this.catalog.getFeatureTypeByName("foo");
        ft.setStore((StoreInfo)ds);
        this.catalog.save((ResourceInfo)ft);
        Assert.assertFalse((boolean)f1.exists());
        File f2 = new File(testData.getDataDirectoryRoot(), "workspaces/acme/barstore/foo/featuretype.xml");
        Assert.assertTrue((boolean)f2.exists());
    }

    @Test
    public void testModifyFeatureType() throws Exception {
        this.testAddFeatureType();
        FeatureTypeInfo ft = this.catalog.getFeatureTypeByName("bar", "foo");
        ft.setTitle("fooTitle");
        this.catalog.save((ResourceInfo)ft);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo/featuretype.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"fooTitle", (String)"/featureType/title", (Document)dom);
    }

    @Test
    public void testRemoveFeatureType() throws Exception {
        this.testAddFeatureType();
        File d = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo");
        Assert.assertTrue((boolean)d.exists());
        FeatureTypeInfo ft = this.catalog.getFeatureTypeByName("bar", "foo");
        this.catalog.remove((ResourceInfo)ft);
        Assert.assertFalse((boolean)d.exists());
    }

    @Test
    public void testAddCoverageStore() throws Exception {
        this.testAddWorkspace();
        File dir = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore");
        Assert.assertFalse((boolean)dir.exists());
        CoverageStoreInfo cs = this.catalog.getFactory().createCoverageStore();
        cs.setName("foostore");
        cs.setWorkspace(this.catalog.getWorkspaceByName("acme"));
        this.catalog.add((StoreInfo)cs);
        Assert.assertTrue((boolean)dir.exists());
        Assert.assertTrue((boolean)new File(dir, "coveragestore.xml").exists());
    }

    @Test
    public void testModifyCoverageStore() throws Exception {
        this.testAddCoverageStore();
        CoverageStoreInfo cs = this.catalog.getCoverageStoreByName("acme", "foostore");
        Assert.assertNull((Object)cs.getURL());
        cs.setURL("file:data/foo.tiff");
        this.catalog.save((StoreInfo)cs);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/coveragestore.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"file:data/foo.tiff", (String)"/coverageStore/url/text()", (Document)dom);
    }

    @Test
    public void testRemoveCoverageStore() throws Exception {
        this.testAddCoverageStore();
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore");
        Assert.assertTrue((boolean)f.exists());
        CoverageStoreInfo cs = this.catalog.getCoverageStoreByName("acme", "foostore");
        this.catalog.remove((StoreInfo)cs);
        Assert.assertFalse((boolean)f.exists());
    }

    @Test
    public void testAddCoverage() throws Exception {
        this.testAddCoverageStore();
        File d = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo");
        Assert.assertFalse((boolean)d.exists());
        NamespaceInfo ns = this.catalog.getFactory().createNamespace();
        ns.setPrefix("bar");
        ns.setURI("http://bar");
        this.catalog.add(ns);
        CoverageInfo ft = this.catalog.getFactory().createCoverage();
        ft.setName("foo");
        ft.setNamespace(ns);
        ft.setStore((StoreInfo)this.catalog.getCoverageStoreByName("acme", "foostore"));
        this.catalog.add((ResourceInfo)ft);
        Assert.assertTrue((boolean)d.exists());
    }

    @Test
    public void testModifyCoverage() throws Exception {
        this.testAddCoverage();
        CoverageInfo ft = this.catalog.getCoverageByName("bar", "foo");
        ft.setTitle("fooTitle");
        this.catalog.save((ResourceInfo)ft);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo/coverage.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"fooTitle", (String)"/coverage/title", (Document)dom);
    }

    @Test
    public void testRemoveCoverage() throws Exception {
        this.testAddCoverage();
        File d = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo");
        Assert.assertTrue((boolean)d.exists());
        CoverageInfo ft = this.catalog.getCoverageByName("bar", "foo");
        this.catalog.remove((ResourceInfo)ft);
        Assert.assertFalse((boolean)d.exists());
    }

    @Test
    public void testAddWMSStore() throws Exception {
        this.testAddWorkspace();
        File dir = new File(testData.getDataDirectoryRoot(), "workspaces/acme/demowms");
        Assert.assertFalse((boolean)dir.exists());
        WMSStoreInfo wms = this.catalog.getFactory().createWebMapServer();
        wms.setName("demowms");
        wms.setWorkspace(this.catalog.getWorkspaceByName("acme"));
        this.catalog.add((StoreInfo)wms);
        Assert.assertTrue((boolean)dir.exists());
        Assert.assertTrue((boolean)new File(dir, "wmsstore.xml").exists());
    }

    @Test
    public void testModifyWMSStore() throws Exception {
        this.testAddWMSStore();
        WMSStoreInfo wms = (WMSStoreInfo)this.catalog.getStoreByName("acme", "demowms", WMSStoreInfo.class);
        Assert.assertNull((Object)wms.getCapabilitiesURL());
        String capsURL = "http://demo.opengeo.org:8080/geoserver/wms?request=GetCapabilites&service=WMS";
        wms.setCapabilitiesURL(capsURL);
        this.catalog.save((StoreInfo)wms);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/demowms/wmsstore.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)capsURL, (String)"/wmsStore/capabilitiesURL/text()", (Document)dom);
    }

    @Test
    public void testRemoveWMSStore() throws Exception {
        this.testAddWMSStore();
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/demowms");
        Assert.assertTrue((boolean)f.exists());
        WMSStoreInfo wms = (WMSStoreInfo)this.catalog.getStoreByName("acme", "demowms", WMSStoreInfo.class);
        this.catalog.remove((StoreInfo)wms);
        Assert.assertFalse((boolean)f.exists());
    }

    @Test
    public void testAddWMSLayer() throws Exception {
        this.testAddWMSStore();
        File d = new File(testData.getDataDirectoryRoot(), "workspaces/acme/demowms/foo");
        Assert.assertFalse((boolean)d.exists());
        NamespaceInfo ns = this.catalog.getFactory().createNamespace();
        ns.setPrefix("bar");
        ns.setURI("http://bar");
        this.catalog.add(ns);
        WMSLayerInfo wms = this.catalog.getFactory().createWMSLayer();
        wms.setName("foo");
        wms.setNamespace(ns);
        wms.setStore(this.catalog.getStoreByName("acme", "demowms", WMSStoreInfo.class));
        this.catalog.add((ResourceInfo)wms);
        Assert.assertTrue((boolean)d.exists());
        Assert.assertTrue((boolean)new File(d, "wmslayer.xml").exists());
    }

    @Test
    public void testModifyWMSLayer() throws Exception {
        this.testAddWMSLayer();
        WMSLayerInfo wli = (WMSLayerInfo)this.catalog.getResourceByName("bar", "foo", WMSLayerInfo.class);
        wli.setTitle("fooTitle");
        this.catalog.save((ResourceInfo)wli);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/demowms/foo/wmslayer.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"fooTitle", (String)"/wmsLayer/title", (Document)dom);
    }

    @Test
    public void testRemoveWMSLayer() throws Exception {
        this.testAddWMSLayer();
        File d = new File(testData.getDataDirectoryRoot(), "workspaces/acme/demowms/foo");
        Assert.assertTrue((boolean)d.exists());
        WMSLayerInfo wli = (WMSLayerInfo)this.catalog.getResourceByName("bar", "foo", WMSLayerInfo.class);
        this.catalog.remove((ResourceInfo)wli);
        Assert.assertFalse((boolean)d.exists());
    }

    @Test
    public void testAddWMTSStore() throws Exception {
        this.testAddWorkspace();
        File dir = new File(testData.getDataDirectoryRoot(), "workspaces/acme/demowmts");
        Assert.assertFalse((boolean)dir.exists());
        WMTSStoreInfo wmts = this.catalog.getFactory().createWebMapTileServer();
        wmts.setName("demowmts");
        wmts.setWorkspace(this.catalog.getWorkspaceByName("acme"));
        this.catalog.add((StoreInfo)wmts);
        Assert.assertTrue((boolean)dir.exists());
        Assert.assertTrue((boolean)new File(dir, "wmtsstore.xml").exists());
    }

    @Test
    public void testModifyWMTSStore() throws Exception {
        this.testAddWMTSStore();
        WMTSStoreInfo wmts = (WMTSStoreInfo)this.catalog.getStoreByName("acme", "demowmts", WMTSStoreInfo.class);
        Assert.assertNull((Object)wmts.getCapabilitiesURL());
        String capsURL = "http://demo.opengeo.org:8080/geoserver/gwc?request=GetCapabilites&service=WMTS";
        wmts.setCapabilitiesURL(capsURL);
        this.catalog.save((StoreInfo)wmts);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/demowmts/wmtsstore.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)capsURL, (String)"/wmtsStore/capabilitiesURL/text()", (Document)dom);
    }

    @Test
    public void testRemoveWMTSStore() throws Exception {
        this.testAddWMTSStore();
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/demowmts");
        Assert.assertTrue((boolean)f.exists());
        WMTSStoreInfo wmts = (WMTSStoreInfo)this.catalog.getStoreByName("acme", "demowmts", WMTSStoreInfo.class);
        this.catalog.remove((StoreInfo)wmts);
        Assert.assertFalse((boolean)f.exists());
    }

    @Test
    public void testAddWMTSLayer() throws Exception {
        this.testAddWMTSStore();
        File d = new File(testData.getDataDirectoryRoot(), "workspaces/acme/demowmts/foo_wmts");
        Assert.assertFalse((boolean)d.exists());
        NamespaceInfo ns = this.catalog.getFactory().createNamespace();
        ns.setPrefix("bar");
        ns.setURI("http://bar");
        this.catalog.add(ns);
        WMTSLayerInfo wmts = this.catalog.getFactory().createWMTSLayer();
        wmts.setName("foo_wmts");
        wmts.setNamespace(ns);
        wmts.setStore(this.catalog.getStoreByName("acme", "demowmts", WMTSStoreInfo.class));
        this.catalog.add((ResourceInfo)wmts);
        Assert.assertTrue((boolean)d.exists());
        Assert.assertTrue((boolean)new File(d, "wmtslayer.xml").exists());
    }

    @Test
    public void testModifyWMTSLayer() throws Exception {
        this.testAddWMTSLayer();
        WMTSLayerInfo wli = (WMTSLayerInfo)this.catalog.getResourceByName("bar", "foo_wmts", WMTSLayerInfo.class);
        wli.setTitle("fooTitle");
        this.catalog.save((ResourceInfo)wli);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/demowmts/foo_wmts/wmtslayer.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"fooTitle", (String)"/wmtsLayer/title", (Document)dom);
    }

    @Test
    public void testRemoveWMTSLayer() throws Exception {
        this.testAddWMTSLayer();
        File d = new File(testData.getDataDirectoryRoot(), "workspaces/acme/demowmts/foo_wmts");
        Assert.assertTrue((boolean)d.exists());
        WMTSLayerInfo wli = (WMTSLayerInfo)this.catalog.getResourceByName("bar", "foo_wmts", WMTSLayerInfo.class);
        this.catalog.remove((ResourceInfo)wli);
        Assert.assertFalse((boolean)d.exists());
    }

    @Test
    public void testAddLayer() throws Exception {
        this.testAddFeatureType();
        this.testAddStyle();
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo/layer.xml");
        Assert.assertFalse((boolean)f.exists());
        LayerInfo l = this.catalog.getFactory().createLayer();
        l.setResource((ResourceInfo)this.catalog.getFeatureTypeByName("bar", "foo"));
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        l.setDefaultStyle(s);
        this.catalog.add(l);
        Assert.assertTrue((boolean)f.exists());
    }

    @Test
    public void testModifyLayer() throws Exception {
        this.testAddLayer();
        LayerInfo l = this.catalog.getLayerByName("foo");
        l.setPath("/foo/bar");
        this.catalog.save(l);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo/layer.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"/foo/bar", (String)"/layer/path", (Document)dom);
    }

    @Test
    public void testRemoveLayer() throws Exception {
        this.testAddLayer();
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo/layer.xml");
        Assert.assertTrue((boolean)f.exists());
        LayerInfo l = this.catalog.getLayerByName("foo");
        this.catalog.remove(l);
        Assert.assertFalse((boolean)f.exists());
    }

    @Test
    public void testAddStyle() throws Exception {
        File f = new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml");
        Assert.assertFalse((boolean)f.exists());
        StyleInfo s = this.catalog.getFactory().createStyle();
        s.setName("foostyle");
        s.setFilename("foostyle.sld");
        this.catalog.add(s);
        Assert.assertTrue((boolean)f.exists());
    }

    @Test
    public void testAddStyleWithWorkspace() throws Exception {
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.xml");
        Assert.assertFalse((boolean)f.exists());
        StyleInfo s = this.catalog.getFactory().createStyle();
        s.setName("foostyle");
        s.setFilename("foostyle.sld");
        s.setWorkspace(this.catalog.getDefaultWorkspace());
        this.catalog.add(s);
        Assert.assertTrue((boolean)f.exists());
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)this.catalog.getDefaultWorkspace().getId(), (String)"/style/workspace/id", (Document)dom);
    }

    @Test
    public void testModifyStyle() throws Exception {
        this.testAddStyle();
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setFilename("foostyle2.sld");
        this.catalog.save(s);
        File f = new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"foostyle2.sld", (String)"/style/filename", (Document)dom);
    }

    @Test
    public void testRenameStyle() throws Exception {
        this.testAddStyle();
        File sldFile = new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld");
        sldFile.createNewFile();
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setName("boostyle");
        this.catalog.save(s);
        File f = new File(testData.getDataDirectoryRoot(), "styles/boostyle.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"boostyle.sld", (String)"/style/filename", (Document)dom);
        File renamedSldFile = new File(testData.getDataDirectoryRoot(), "styles/boostyle.sld");
        MatcherAssert.assertThat((Object)sldFile, (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)renamedSldFile, FileExistsMatcher.fileExists());
    }

    @Test
    public void testRenameStyleNotUnnecessarily() throws Exception {
        this.testAddStyle();
        File sldFile = new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld");
        sldFile.createNewFile();
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setName("foostyle");
        this.catalog.save(s);
        Assert.assertEquals((Object)"foostyle.sld", (Object)s.getFilename());
    }

    @Test
    public void testRenameStyleConflict() throws Exception {
        this.testAddStyle();
        File sldFile = new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld");
        sldFile.createNewFile();
        File conflictingFile = new File(testData.getDataDirectoryRoot(), "styles/boostyle.sld");
        conflictingFile.createNewFile();
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setName("boostyle");
        this.catalog.save(s);
        File f = new File(testData.getDataDirectoryRoot(), "styles/boostyle.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"boostyle1.sld", (String)"/style/filename", (Document)dom);
        File renamedSldFile = new File(testData.getDataDirectoryRoot(), "styles/boostyle1.sld");
        MatcherAssert.assertThat((Object)sldFile, (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)renamedSldFile, FileExistsMatcher.fileExists());
    }

    protected void addBarStyle() throws Exception {
        StyleInfo s = this.catalog.getFactory().createStyle();
        s.setName("barstyle");
        s.setFilename("barstyle.sld");
        this.catalog.add(s);
    }

    @Test
    public void testRenameStyleWithExistingIncrementedVersion() throws Exception {
        this.addBarStyle();
        File sldFileOld = new File(testData.getDataDirectoryRoot(), "styles/barstyle.sld");
        sldFileOld.createNewFile();
        File sldFileNew = new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld");
        sldFileNew.createNewFile();
        File sldFile1 = new File(testData.getDataDirectoryRoot(), "styles/foostyle1.sld");
        sldFile1.createNewFile();
        File xmlFile1 = new File(testData.getDataDirectoryRoot(), "styles/foostyle1.xml");
        xmlFile1.createNewFile();
        MatcherAssert.assertThat((Object)sldFileOld, FileExistsMatcher.fileExists());
        File sldFile2 = new File(testData.getDataDirectoryRoot(), "styles/foostyle2.sld");
        StyleInfo s = this.catalog.getStyleByName("barstyle");
        s.setName("foostyle");
        this.catalog.save(s);
        MatcherAssert.assertThat((Object)sldFileOld, (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)sldFileNew, FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)sldFile1, FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)xmlFile1, FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)sldFile2, FileExistsMatcher.fileExists());
        sldFile1.delete();
        xmlFile1.delete();
    }

    @Test
    public void testRenameSLDFileOnlyIfNotFound() throws Exception {
        this.testAddStyle();
        File sldFile = new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld");
        sldFile.createNewFile();
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setName("foostyle");
        this.catalog.save(s);
        File f = new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"foostyle.sld", (String)"/style/filename", (Document)dom);
        MatcherAssert.assertThat((Object)sldFile, FileExistsMatcher.fileExists());
    }

    @Test
    public void testModifyStyleChangeWorkspace() throws Exception {
        this.testAddStyle();
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setFilename("foostyle2.sld");
        s.setWorkspace(this.catalog.getDefaultWorkspace());
        this.catalog.save(s);
        File f = new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml");
        Assert.assertFalse((boolean)f.exists());
        f = new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"foostyle2.sld", (String)"/style/filename", (Document)dom);
    }

    @Test
    public void testModifyStyleChangeWorkspace2() throws Exception {
        this.testAddStyle();
        FileUtils.copyURLToFile((URL)this.getClass().getResource("default_line.sld"), (File)new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld"));
        Assert.assertTrue((boolean)new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml").exists());
        Assert.assertTrue((boolean)new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld").exists());
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setWorkspace(this.catalog.getDefaultWorkspace());
        this.catalog.save(s);
        Assert.assertFalse((boolean)new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml").exists());
        Assert.assertFalse((boolean)new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld").exists());
        Assert.assertTrue((boolean)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.xml").exists());
        Assert.assertTrue((boolean)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.sld").exists());
    }

    @Test
    public void testModifyStyleChangeWorkspaceToGlobal() throws Exception {
        this.testAddStyleWithWorkspace();
        FileUtils.copyURLToFile((URL)this.getClass().getResource("default_line.sld"), (File)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.sld"));
        Assert.assertTrue((boolean)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.xml").exists());
        Assert.assertTrue((boolean)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.sld").exists());
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setWorkspace(null);
        this.catalog.save(s);
        Assert.assertTrue((boolean)new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml").exists());
        Assert.assertTrue((boolean)new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld").exists());
        Assert.assertFalse((boolean)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.xml").exists());
        Assert.assertFalse((boolean)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.sld").exists());
    }

    @Test
    public void testModifyStyleWithResourceChangeWorkspace() throws Exception {
        this.testAddStyle();
        FileUtils.copyURLToFile((URL)this.getClass().getResource("burg.sld"), (File)new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld"));
        FileUtils.copyURLToFile((URL)this.getClass().getResource("burg02.svg"), (File)new File(testData.getDataDirectoryRoot(), "styles/burg02.svg"));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/burg02.svg"), FileExistsMatcher.fileExists());
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setWorkspace(this.catalog.getDefaultWorkspace());
        this.catalog.save(s);
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/burg02.svg"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.xml"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.sld"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/burg02.svg"), FileExistsMatcher.fileExists());
    }

    @Test
    public void testModifyStyleWithResourcesInParentDirChangeWorkspace() throws Exception {
        this.testAddStyle();
        FileUtils.copyURLToFile((URL)this.getClass().getResource("burgParentReference.sld"), (File)new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld"));
        FileUtils.copyURLToFile((URL)this.getClass().getResource("burg02.svg"), (File)new File(testData.getDataDirectoryRoot(), "styles/burg02.svg"));
        FileUtils.copyURLToFile((URL)this.getClass().getResource("burg02.svg"), (File)new File(testData.getDataDirectoryRoot(), "burg03.svg"));
        new File(testData.getDataDirectoryRoot(), "styles/burg03.svg").delete();
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/burg02.svg"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "burg03.svg"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/burg03.svg"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setWorkspace(this.catalog.getDefaultWorkspace());
        this.catalog.save(s);
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "burg03.svg"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/burg02.svg"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.xml"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.sld"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/burg03.svg"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/burg03.svg"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/burg02.svg"), FileExistsMatcher.fileExists());
    }

    @Test
    public void testModifyStyleWithResourcesAbsoluteChangeWorkspace() throws Exception {
        this.testAddStyle();
        File styleFile = new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld");
        FileUtils.copyURLToFile((URL)this.getClass().getResource("burgParentReference.sld"), (File)styleFile);
        FileUtils.copyURLToFile((URL)this.getClass().getResource("burg02.svg"), (File)new File(testData.getDataDirectoryRoot(), "styles/burg02.svg"));
        File target = new File(testData.getDataDirectoryRoot(), "burg03.svg");
        FileUtils.copyURLToFile((URL)this.getClass().getResource("burg02.svg"), (File)target);
        String content = new String(Files.readAllBytes(styleFile.toPath()), StandardCharsets.UTF_8);
        content = content.replaceAll("./burg03.svg", "http://doesnotexist.example.org/burg03.svg");
        Files.write(styleFile.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        new File(testData.getDataDirectoryRoot(), "styles/burg03.svg").delete();
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/burg02.svg"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)target, FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/burg03.svg"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setWorkspace(this.catalog.getDefaultWorkspace());
        this.catalog.save(s);
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)target, FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/burg02.svg"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.xml"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.sld"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/burg03.svg"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/burg03.svg"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs" + target.getPath()), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles" + target.getPath()), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/burg02.svg"), FileExistsMatcher.fileExists());
    }

    @Test
    public void testModifyStyleWithResourcesRemoteChangeWorkspace() throws Exception {
        this.testAddStyle();
        File styleFile = new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld");
        FileUtils.copyURLToFile((URL)this.getClass().getResource("burgRemoteReference.sld"), (File)styleFile);
        FileUtils.copyURLToFile((URL)this.getClass().getResource("burg02.svg"), (File)new File(testData.getDataDirectoryRoot(), "styles/burg02.svg"));
        new File(testData.getDataDirectoryRoot(), "styles/burg03.svg").delete();
        new File(testData.getDataDirectoryRoot(), "burg03.svg").delete();
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/burg02.svg"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/burg03.svg"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "burg03.svg"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setWorkspace(this.catalog.getDefaultWorkspace());
        this.catalog.save(s);
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles/burg02.svg"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.xml"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.sld"), FileExistsMatcher.fileExists());
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/burg03.svg"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/burg03.svg"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/example.com/burg03.svg"), (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/burg02.svg"), FileExistsMatcher.fileExists());
    }

    @Test
    public void testRemoveStyle() throws Exception {
        this.testAddStyle();
        File f = new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml");
        Assert.assertTrue((boolean)f.exists());
        File sf = new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld");
        sf.createNewFile();
        Assert.assertTrue((boolean)sf.exists());
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        this.catalog.remove(s);
        MatcherAssert.assertThat((Object)f, (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)sf, (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        File sfb = new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld.bak");
        MatcherAssert.assertThat((Object)sfb, FileExistsMatcher.fileExists());
        this.testAddStyle();
        sf = new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld");
        sf.createNewFile();
        Assert.assertTrue((boolean)sf.exists());
        s = this.catalog.getStyleByName("foostyle");
        this.catalog.remove(s);
        MatcherAssert.assertThat((Object)f, (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        MatcherAssert.assertThat((Object)sf, (Matcher)Matchers.not(FileExistsMatcher.fileExists()));
        sfb = new File(testData.getDataDirectoryRoot(), "styles/foostyle.sld.bak.1");
        MatcherAssert.assertThat((Object)sfb, FileExistsMatcher.fileExists());
    }

    @Test
    public void testRemoveStyleWithWorkspace() throws Exception {
        StyleInfo s = this.catalog.getFactory().createStyle();
        s.setName("foostyle");
        s.setFilename("foostyle.sld");
        s.setWorkspace(this.catalog.getDefaultWorkspace());
        this.catalog.add(s);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/gs/styles/foostyle.xml");
        Assert.assertTrue((boolean)f.exists());
        s = this.catalog.getStyleByName("foostyle");
        Assert.assertNotNull((Object)s);
        s = this.catalog.getStyleByName(this.catalog.getDefaultWorkspace(), "foostyle");
        this.catalog.remove(s);
        Assert.assertFalse((boolean)f.exists());
    }

    @Test
    public void testRemoveStyleWithBadFilename() throws Exception {
        this.testAddStyle();
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setFilename("/");
        this.catalog.remove(s);
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles"), FileExistsMatcher.fileExists());
    }

    @Test
    public void testRemoveStyleWithNullFilename() throws Exception {
        this.testAddStyle();
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setFilename(null);
        this.catalog.remove(s);
        MatcherAssert.assertThat((Object)new File(testData.getDataDirectoryRoot(), "styles"), FileExistsMatcher.fileExists());
    }

    @Test
    public void testAddLayerGroup() throws Exception {
        this.testAddLayer();
        File f = new File(testData.getDataDirectoryRoot(), "layergroups/lg.xml");
        Assert.assertFalse((boolean)f.exists());
        LayerGroupInfo lg = this.catalog.getFactory().createLayerGroup();
        lg.setName("lg");
        lg.getLayers().add(this.catalog.getLayerByName("foo"));
        lg.getStyles().add(this.catalog.getStyleByName("foostyle"));
        lg.getLayers().add(this.catalog.getLayerByName("foo"));
        lg.getStyles().add(null);
        lg.getLayers().add(this.catalog.getLayerByName("foo"));
        lg.getStyles().add(this.catalog.getStyleByName("foostyle"));
        this.catalog.add(lg);
        Assert.assertTrue((boolean)f.exists());
    }

    private File file(File base, String unixPath) {
        File file = base;
        for (String item : unixPath.split("/")) {
            file = new File(file, item);
        }
        return file;
    }

    @Test
    public void testAddLayerGroupWithWorkspace() throws Exception {
        File f = this.file(testData.getDataDirectoryRoot(), "workspaces/acme/layergroups/foolayergroup.xml");
        Assert.assertFalse((boolean)f.exists());
        this.testAddLayer();
        LayerGroupInfo lg = this.catalog.getFactory().createLayerGroup();
        lg.setName("foolayergroup");
        lg.setWorkspace(this.catalog.getWorkspaceByName("acme"));
        lg.getLayers().add(this.catalog.getLayerByName("foo"));
        lg.getStyles().add(null);
        this.catalog.add(lg);
        Assert.assertTrue((boolean)f.exists());
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)this.catalog.getWorkspaceByName("acme").getId(), (String)"/layerGroup/workspace/id", (Document)dom);
    }

    @Test
    public void testModifyLayerGroup() throws Exception {
        this.testAddLayerGroup();
        LayerGroupInfo lg = this.catalog.getLayerGroupByName("lg");
        StyleInfo s = this.catalog.getFactory().createStyle();
        s.setName("foostyle2");
        s.setFilename("foostyle2.sld");
        this.catalog.add(s);
        lg.getStyles().set(0, s);
        this.catalog.save(lg);
        File f = new File(testData.getDataDirectoryRoot(), "layergroups/lg.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)s.getId(), (String)"/layerGroup/styles/style/id", (Document)dom);
    }

    @Test
    public void testModifyLayerGroupChangeWorkspace() throws Exception {
        this.testAddLayerGroup();
        File f = new File(testData.getDataDirectoryRoot(), "layergroups/lg.xml");
        Assert.assertTrue((boolean)f.exists());
        LayerGroupInfo lg = this.catalog.getLayerGroupByName("lg");
        WorkspaceInfo workspace = this.catalog.getWorkspaceByName("acme");
        Assert.assertNotNull((Object)workspace);
        lg.setWorkspace(workspace);
        this.catalog.save(lg);
        Assert.assertFalse((boolean)f.exists());
        String path = testData.getDataDirectoryRoot().getAbsolutePath();
        Assert.assertTrue((String)("data directory " + path), (boolean)testData.getDataDirectoryRoot().exists());
        File file = new File(testData.getDataDirectoryRoot(), "workspaces/acme/layergroups/lg.xml");
        Assert.assertTrue((String)file.getPath(), (boolean)file.exists());
    }

    @Test
    public void testRemoveLayerGroup() throws Exception {
        this.testAddLayerGroup();
        File dataDirectoryRoot = testData.getDataDirectoryRoot();
        File f = new File(dataDirectoryRoot, "layergroups/lg.xml");
        Assert.assertTrue((boolean)f.exists());
        LayerGroupInfo lg = this.catalog.getLayerGroupByName("lg");
        this.catalog.remove(lg);
        Assert.assertFalse((String)"removed lg", (boolean)f.exists());
    }

    @Test
    public void testRemoveLayerGroupWithWorkspace() throws Exception {
        this.testModifyLayerGroupChangeWorkspace();
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/layergroups/lg.xml");
        Assert.assertTrue((boolean)f.exists());
        LayerGroupInfo lg = this.catalog.getLayerGroupByName("lg");
        Assert.assertNull((Object)lg);
        lg = this.catalog.getLayerGroupByName("acme:lg");
        Assert.assertNotNull((Object)lg);
        this.catalog.remove(lg);
        Assert.assertFalse((boolean)f.exists());
    }

    @Test
    public void testModifyGlobal() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setAdminUsername("roadRunner");
        global.getSettings().setTitle("ACME");
        this.getGeoServer().save(global);
        File f = new File(testData.getDataDirectoryRoot(), "global.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"roadRunner", (String)"/global/adminUsername", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ACME", (String)"/global/settings/title", (Document)dom);
    }

    @Test
    public void testAddSettings() throws Exception {
        this.testAddWorkspace();
        WorkspaceInfo ws = this.catalog.getWorkspaceByName("acme");
        SettingsInfo settings = this.getGeoServer().getFactory().createSettings();
        settings.setTitle("ACME");
        settings.setWorkspace(ws);
        File f = this.catalog.getResourceLoader().find(new String[]{"workspaces", ws.getName(), "settings.xml"});
        Assert.assertNull((Object)f);
        this.getGeoServer().add(settings);
        f = this.catalog.getResourceLoader().find(new String[]{"workspaces", ws.getName(), "settings.xml"});
        Assert.assertNotNull((Object)f);
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"ACME", (String)"/settings/title", (Document)dom);
    }

    @Test
    public void testModifySettings() throws Exception {
        this.testAddSettings();
        WorkspaceInfo ws = this.catalog.getWorkspaceByName("acme");
        SettingsInfo settings = this.getGeoServer().getSettings(ws);
        settings.setTitle("FOO");
        this.getGeoServer().save(settings);
        File f = this.catalog.getResourceLoader().find(new String[]{"workspaces", ws.getName(), "settings.xml"});
        Assert.assertNotNull((Object)f);
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"FOO", (String)"/settings/title", (Document)dom);
    }

    @Test
    public void testModifySettingsChangeWorkspace() throws Exception {
        this.testAddSettings();
        WorkspaceInfo ws1 = this.catalog.getWorkspaceByName("acme");
        WorkspaceInfo ws2 = this.catalog.getFactory().createWorkspace();
        ws2.setName("foo");
        this.catalog.add(ws2);
        SettingsInfo settings = this.getGeoServer().getSettings(ws1);
        settings.setWorkspace(ws2);
        this.getGeoServer().save(settings);
        File f = this.catalog.getResourceLoader().find(new String[]{"workspaces", ws1.getName(), "settings.xml"});
        Assert.assertNull((Object)f);
        f = this.catalog.getResourceLoader().find(new String[]{"workspaces", ws2.getName(), "settings.xml"});
        Assert.assertNotNull((Object)f);
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)ws2.getId(), (String)"/settings/workspace/id", (Document)dom);
    }

    @Test
    public void testModifyLoggingAndReload() throws Exception {
        GeoServerResourceLoader loader = this.getDataDirectory().getResourceLoader();
        LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)"DEFAULT_LOGGING.xml", (boolean)false, (boolean)true, (String)"logs/geoserver.log");
        String path = this.getDataDirectory().getResourceLoader().getBaseDirectory().getPath();
        LoggingInfo logging = this.getGeoServer().getLogging();
        File logFile = new File(path, "logging.xml");
        logging.setLocation("logs/geoserver.log");
        logging.setStdOutLogging(true);
        logging.setLevel("VERBOSE_LOGGING.xml");
        this.getGeoServer().save(logging);
        LoggingInfo currentLogging = this.getGeoServer().getLogging();
        Assert.assertEquals((Object)currentLogging, (Object)logging);
        String content = null;
        try (FileInputStream fis = new FileInputStream(logFile);){
            content = IOUtils.toString((InputStream)fis, (Charset)Charset.defaultCharset());
        }
        String newLevel = "QUIET_LOGGING.xml";
        content = content.replace("VERBOSE_LOGGING.xml", newLevel);
        try (FileOutputStream fos = new FileOutputStream(logFile);){
            IOUtils.write((String)content, (OutputStream)fos, (Charset)Charset.defaultCharset());
        }
        this.getGeoServer().reload();
        LoggingInitializer.LoggingListener listener = (LoggingInitializer.LoggingListener)this.getGeoServer().getListeners().stream().filter(l -> l instanceof LoggingInitializer.LoggingListener).findAny().get();
        LoggingInfo newLogging = listener.getCurrentLogging();
        Assert.assertEquals((Object)newLogging.getLevel(), (Object)newLevel);
    }

    @Test
    public void testRemoveSettings() throws Exception {
        this.testAddSettings();
        WorkspaceInfo ws = this.catalog.getWorkspaceByName("acme");
        File f = this.catalog.getResourceLoader().find(new String[]{"workspaces", ws.getName(), "settings.xml"});
        Assert.assertNotNull((Object)f);
        SettingsInfo settings = this.getGeoServer().getSettings(ws);
        this.getGeoServer().remove(settings);
        f = this.catalog.getResourceLoader().find(new String[]{"workspaces", ws.getName(), "settings.xml"});
        Assert.assertNull((Object)f);
    }

    Document dom(File f) throws Exception {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f);
    }
}

