/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.geoserver.config.SpringResourceAdaptor;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpringResourceAdaptorTest {
    Resource directoryResource;
    Resource missingResource;
    Resource existingResource;
    static final String CONTENT = "content";

    @Before
    public void setUp() throws Exception {
        FileSystemResourceStore target = new FileSystemResourceStore(new File("target"));
        this.missingResource = target.get("missingFile");
        Assert.assertFalse((boolean)Resources.exists((Resource)this.missingResource));
        this.existingResource = target.get("existingFile");
        Resources.createNewFile((Resource)this.existingResource);
        this.existingResource.setContents(CONTENT.getBytes(StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)Resources.exists((Resource)this.existingResource));
        this.directoryResource = this.existingResource.parent();
        Assert.assertTrue((boolean)Resources.exists((Resource)this.directoryResource));
    }

    @After
    public void tearDown() throws Exception {
        this.existingResource.delete();
        this.missingResource.delete();
    }

    @Test
    public void testExistingResource() throws IOException {
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)this.existingResource.getType());
        Assert.assertTrue((boolean)Resources.exists((Resource)this.existingResource));
        SpringResourceAdaptor springResource = new SpringResourceAdaptor(this.existingResource);
        Assert.assertTrue((boolean)springResource.isReadable());
        Assert.assertEquals((long)springResource.contentLength(), (long)CONTENT.length());
        Assert.assertNotNull((Object)springResource.getFile());
        try (InputStream is = springResource.getInputStream();){
            Assert.assertNotNull((Object)is);
            String content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            Assert.assertEquals((Object)content, (Object)CONTENT);
        }
    }

    @Test
    public void testDirectoryResource() throws IOException {
        Assert.assertEquals((Object)Resource.Type.DIRECTORY, (Object)this.directoryResource.getType());
        Assert.assertTrue((boolean)Resources.exists((Resource)this.directoryResource));
        SpringResourceAdaptor springResource = new SpringResourceAdaptor(this.directoryResource);
        Assert.assertFalse((boolean)springResource.isReadable());
        Assert.assertEquals((long)springResource.contentLength(), (long)0L);
        Assert.assertNotNull((Object)springResource.getFile());
        Assert.assertThrows(FileNotFoundException.class, () -> springResource.getInputStream().close());
    }

    @Test
    public void testMissingResource() {
        Assert.assertEquals((Object)Resource.Type.UNDEFINED, (Object)this.missingResource.getType());
        Assert.assertFalse((boolean)Resources.exists((Resource)this.missingResource));
        SpringResourceAdaptor springResource = new SpringResourceAdaptor(this.missingResource);
        Assert.assertFalse((boolean)springResource.isReadable());
        Assert.assertEquals((long)springResource.contentLength(), (long)0L);
        Assert.assertThrows(FileNotFoundException.class, () -> ((SpringResourceAdaptor)springResource).getFile());
        Assert.assertThrows(FileNotFoundException.class, () -> springResource.getInputStream().close());
        Assert.assertFalse((boolean)Resources.exists((Resource)this.missingResource));
    }
}

