/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.datadir;

import javax.servlet.ServletContext;
import org.geoserver.config.datadir.DataDirectoryGeoServerLoader;
import org.geoserver.config.datadir.ExecutorFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.EnvironmentVariables;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class DataDirectoryGeoServerLoaderConfigurationTest {
    @Rule
    public final EnvironmentVariables environmentVariables = new EnvironmentVariables();

    @Before
    public void setUp() {
        this.cleanUp();
    }

    @After
    public void tearDown() {
        System.clearProperty("GEOSERVER_DATA_DIR_LOADER_ENABLED");
        System.clearProperty("GEOSERVER_DATA_DIR_LOADER_THREADS");
        this.environmentVariables.clear(new String[]{"GEOSERVER_DATA_DIR_LOADER_ENABLED", "GEOSERVER_DATA_DIR_LOADER_THREADS"});
    }

    private void cleanUp() {
        this.environmentVariables.clear(new String[]{"GEOSERVER_DATA_DIR_LOADER_ENABLED", "GEOSERVER_DATA_DIR_LOADER_THREADS"});
        System.clearProperty("GEOSERVER_DATA_DIR_LOADER_ENABLED");
        System.clearProperty("GEOSERVER_DATA_DIR_LOADER_THREADS");
    }

    @Test
    public void testEnabledByDefault() {
        Assert.assertTrue((boolean)DataDirectoryGeoServerLoader.isEnabled(null));
    }

    @Test
    public void testEnabledWithSystemProperty() {
        System.setProperty("GEOSERVER_DATA_DIR_LOADER_ENABLED", "true");
        Assert.assertTrue((boolean)DataDirectoryGeoServerLoader.isEnabled(null));
    }

    @Test
    public void testDisabledWithSystemProperty() {
        System.setProperty("GEOSERVER_DATA_DIR_LOADER_ENABLED", "false");
        Assert.assertFalse((boolean)DataDirectoryGeoServerLoader.isEnabled(null));
    }

    @Test
    public void testEnvironmentVariable() {
        this.environmentVariables.set("GEOSERVER_DATA_DIR_LOADER_ENABLED", "false");
        Assert.assertFalse((boolean)DataDirectoryGeoServerLoader.isEnabled(null));
        this.environmentVariables.set("GEOSERVER_DATA_DIR_LOADER_ENABLED", "non-true");
        Assert.assertFalse((boolean)DataDirectoryGeoServerLoader.isEnabled(null));
        this.environmentVariables.set("GEOSERVER_DATA_DIR_LOADER_ENABLED", "");
        Assert.assertFalse((boolean)DataDirectoryGeoServerLoader.isEnabled(null));
        this.environmentVariables.set("GEOSERVER_DATA_DIR_LOADER_ENABLED", "true");
        Assert.assertTrue((boolean)DataDirectoryGeoServerLoader.isEnabled(null));
        this.environmentVariables.set("GEOSERVER_DATA_DIR_LOADER_ENABLED", "TRUE");
        Assert.assertTrue((boolean)DataDirectoryGeoServerLoader.isEnabled(null));
    }

    @Test
    public void testServletContext() {
        WebApplicationContext appContext = (WebApplicationContext)Mockito.mock(WebApplicationContext.class);
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)appContext.getServletContext()).thenReturn((Object)servletContext);
        Mockito.when((Object)servletContext.getInitParameter("GEOSERVER_DATA_DIR_LOADER_ENABLED")).thenReturn((Object)"false");
        Assert.assertFalse((boolean)DataDirectoryGeoServerLoader.isEnabled((ApplicationContext)appContext));
        Mockito.when((Object)servletContext.getInitParameter("GEOSERVER_DATA_DIR_LOADER_ENABLED")).thenReturn((Object)"non-true");
        Assert.assertFalse((boolean)DataDirectoryGeoServerLoader.isEnabled((ApplicationContext)appContext));
        Mockito.when((Object)servletContext.getInitParameter("GEOSERVER_DATA_DIR_LOADER_ENABLED")).thenReturn((Object)"true");
        Assert.assertTrue((boolean)DataDirectoryGeoServerLoader.isEnabled((ApplicationContext)appContext));
        Mockito.when((Object)servletContext.getInitParameter("GEOSERVER_DATA_DIR_LOADER_ENABLED")).thenReturn((Object)"TRUE");
        Assert.assertTrue((boolean)DataDirectoryGeoServerLoader.isEnabled((ApplicationContext)appContext));
    }

    @Test
    public void testDetermineParallelismDefault() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int expected = Math.min(availableProcessors, 16);
        Assert.assertEquals((long)expected, (long)ExecutorFactory.determineParallelism());
    }

    @Test
    public void testDetermineParallelismBadArgument() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int expected = Math.min(availableProcessors, 16);
        System.setProperty("GEOSERVER_DATA_DIR_LOADER_THREADS", "N.a.N.");
        Assert.assertEquals((long)expected, (long)ExecutorFactory.determineParallelism());
        System.setProperty("GEOSERVER_DATA_DIR_LOADER_THREADS", "0");
        Assert.assertEquals((long)expected, (long)ExecutorFactory.determineParallelism());
        System.clearProperty("GEOSERVER_DATA_DIR_LOADER_THREADS");
        this.environmentVariables.set("GEOSERVER_DATA_DIR_LOADER_THREADS", "not an int");
        Assert.assertEquals((long)expected, (long)ExecutorFactory.determineParallelism());
        this.environmentVariables.set("GEOSERVER_DATA_DIR_LOADER_THREADS", "0");
        Assert.assertEquals((long)expected, (long)ExecutorFactory.determineParallelism());
    }

    @Test
    public void testDetermineParallelism() {
        int max = Runtime.getRuntime().availableProcessors();
        System.setProperty("GEOSERVER_DATA_DIR_LOADER_THREADS", "1");
        Assert.assertEquals((long)1L, (long)ExecutorFactory.determineParallelism());
        System.setProperty("GEOSERVER_DATA_DIR_LOADER_THREADS", String.valueOf(max));
        Assert.assertEquals((long)max, (long)ExecutorFactory.determineParallelism());
        System.clearProperty("GEOSERVER_DATA_DIR_LOADER_THREADS");
        this.environmentVariables.set("GEOSERVER_DATA_DIR_LOADER_THREADS", "1");
        Assert.assertEquals((long)1L, (long)ExecutorFactory.determineParallelism());
        this.environmentVariables.set("GEOSERVER_DATA_DIR_LOADER_THREADS", String.valueOf(max));
        Assert.assertEquals((long)max, (long)ExecutorFactory.determineParallelism());
    }

    @Test
    public void testDetermineParallellismTooMany() {
        int max = Runtime.getRuntime().availableProcessors();
        int tooMany = 1 + max;
        System.setProperty("GEOSERVER_DATA_DIR_LOADER_THREADS", String.valueOf(tooMany));
        Assert.assertEquals((long)max, (long)ExecutorFactory.determineParallelism());
    }
}

