/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.datadir;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.MetadataLinkInfoImpl;
import org.geoserver.catalog.impl.WMSStoreInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerConfigPersister;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.ServicePersister;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.config.impl.SettingsInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.security.SecureCatalogImpl;
import org.geotools.api.util.InternationalString;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.util.GrowableInternationalString;
import org.geotools.util.Version;
import org.springframework.lang.Nullable;

class DataDirectoryLoaderTestSupport {
    public final TestService1Loader serviceLoader1;
    public final TestService2Loader serviceLoader2;
    private Catalog catalog;
    private GeoServer geoServer;

    public DataDirectoryLoaderTestSupport(Catalog catalog, GeoServer geoServer) {
        this.catalog = catalog;
        this.geoServer = geoServer;
        this.serviceLoader1 = new TestService1Loader(geoServer.getCatalog().getResourceLoader());
        this.serviceLoader2 = new TestService2Loader(geoServer.getCatalog().getResourceLoader());
    }

    public static DataDirectoryLoaderTestSupport withPersistence(File dataDirectory) {
        DataDirectoryLoaderTestSupport support = DataDirectoryLoaderTestSupport.withNoPersistence(dataDirectory);
        Catalog catalog = support.catalog;
        GeoServer geoServer = support.geoServer;
        XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
        xp.setCatalog(catalog);
        GeoServerConfigPersister configPersister = new GeoServerConfigPersister(catalog.getResourceLoader(), xp);
        catalog.addListener((CatalogListener)configPersister);
        geoServer.addListener((ConfigurationListener)configPersister);
        return support;
    }

    public static DataDirectoryLoaderTestSupport withNoPersistence(File dataDirectory) {
        GeoServerResourceLoader rl = new GeoServerResourceLoader(dataDirectory);
        CatalogImpl tmpCatalog = new CatalogImpl();
        tmpCatalog.setResourceLoader(rl);
        GeoServerImpl tmpGeoServer = new GeoServerImpl();
        tmpGeoServer.setCatalog((Catalog)tmpCatalog);
        XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
        xp.setCatalog((Catalog)tmpCatalog);
        return new DataDirectoryLoaderTestSupport((Catalog)tmpCatalog, (GeoServer)tmpGeoServer);
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public GeoServer getGeoServer() {
        return this.geoServer;
    }

    public void setUpServiceLoaders() {
        this.setUpServiceLoaders(this.geoServer);
    }

    public void setUpServiceLoaders(GeoServer geoServer) {
        GeoServerExtensionsHelper.singleton("testServiceLoader1", (Object)this.serviceLoader1, XStreamServiceLoader.class);
        GeoServerExtensionsHelper.singleton("testServiceLoader2", (Object)this.serviceLoader2, XStreamServiceLoader.class);
        geoServer.removeListener((ConfigurationListener)geoServer.getListeners().stream().filter(ServicePersister.class::isInstance).findFirst().orElse(null));
        List<XStreamServiceLoader<ServiceInfo>> loaders = this.findServiceLoaders();
        geoServer.addListener((ConfigurationListener)new ServicePersister(loaders, geoServer));
    }

    public List<XStreamServiceLoader<ServiceInfo>> findServiceLoaders() {
        return GeoServerExtensions.extensions(XStreamServiceLoader.class);
    }

    public void tearDown() {
        this.cleanUp();
    }

    public void cleanUp() {
        GeoServerExtensionsHelper.init(null);
    }

    public TestService1 serviceInfo1(WorkspaceInfo workspace, String name, GeoServer geoServer) {
        return this.serviceInfo(workspace, name, () -> (TestService1)this.serviceLoader1.create(geoServer));
    }

    public TestService2 serviceInfo2(WorkspaceInfo workspace, String name, GeoServer geoServer) {
        return this.serviceInfo(workspace, name, () -> (TestService2)this.serviceLoader2.create(geoServer));
    }

    public <S extends ServiceInfo> S serviceInfo(WorkspaceInfo workspace, String name, Supplier<S> factory) {
        ServiceInfo s = (ServiceInfo)factory.get();
        String id = String.format("%s:%s-id", workspace == null ? null : workspace.getName(), name);
        OwsUtils.set((Object)s, (String)"id", (Object)id);
        s.setName(name);
        s.setWorkspace(workspace);
        s.setTitle(name + " Title");
        s.setAbstract(name + " Abstract");
        s.setInternationalTitle((InternationalString)this.internationalString(Locale.ENGLISH, name + " english title", Locale.CANADA_FRENCH, name + "titre anglais"));
        s.setInternationalAbstract((InternationalString)this.internationalString(Locale.ENGLISH, name + " english abstract", Locale.CANADA_FRENCH, name + "r\u00e9sum\u00e9 anglais"));
        s.setAccessConstraints("NONE");
        s.setCiteCompliant(true);
        s.setEnabled(true);
        s.getExceptionFormats().add("fake-" + name + "-exception-format");
        s.setFees("NONE");
        s.setMaintainer("Claudious whatever");
        MetadataLinkInfoImpl metadataLink = new MetadataLinkInfoImpl();
        metadataLink.setAbout("about");
        metadataLink.setContent("content");
        metadataLink.setId("medatata-link-" + name);
        metadataLink.setMetadataType("fake");
        metadataLink.setType("void");
        s.setMetadataLink((MetadataLinkInfo)metadataLink);
        s.setOnlineResource("http://geoserver.org/" + name);
        s.setOutputStrategy("SPEED");
        s.setSchemaBaseURL("file:data/" + name);
        s.setVerbose(true);
        ArrayList versions = Lists.newArrayList((Object[])new Version[]{new Version("1.0.0"), new Version("2.0.0")});
        s.getVersions().addAll(versions);
        return (S)s;
    }

    private GrowableInternationalString internationalString(Locale l1, String val1, Locale l2, String val2) {
        GrowableInternationalString s = new GrowableInternationalString();
        s.add(l1, val1);
        s.add(l2, val2);
        return s;
    }

    public WorkspaceInfoImpl createWorkspace(String name) {
        CatalogFactory factory = this.catalog.getFactory();
        WorkspaceInfo ws = factory.createWorkspace();
        ws = (WorkspaceInfo)SecureCatalogImpl.unwrap((Object)ws);
        ws.setName(name);
        return (WorkspaceInfoImpl)ws;
    }

    public WorkspaceInfo addWorkspace(String name) {
        CatalogFactory factory = this.catalog.getFactory();
        WorkspaceInfoImpl ws = this.createWorkspace(name);
        NamespaceInfo ns = factory.createNamespace();
        ns.setPrefix(ws.getName());
        ns.setURI("http://" + name + ".test.com");
        this.catalog.add((WorkspaceInfo)ws);
        this.catalog.add(ns);
        return this.catalog.getWorkspaceByName(name);
    }

    public DataStoreInfoImpl createPostgisStore(WorkspaceInfo ws) {
        DataStoreInfo ds = this.catalog.getFactory().createDataStore();
        ds = (DataStoreInfo)SecureCatalogImpl.unwrap((Object)ds);
        ds.setWorkspace(ws);
        ds.setName("postgis");
        ds.setType(new PostgisNGDataStoreFactory().getDisplayName());
        Map params = ds.getConnectionParameters();
        params.put(PostgisNGDataStoreFactory.DBTYPE.key, (String)PostgisNGDataStoreFactory.DBTYPE.getDefaultValue());
        params.put(JDBCDataStoreFactory.HOST.key, "localhost");
        params.put(JDBCDataStoreFactory.DATABASE.key, "test");
        params.put(JDBCDataStoreFactory.USER.key, "test");
        params.put(JDBCDataStoreFactory.PASSWD.key, "s3cr3t");
        return (DataStoreInfoImpl)ds;
    }

    public SettingsInfo createSettings() {
        return this.createSettings(null);
    }

    public SettingsInfo createSettings(@Nullable WorkspaceInfo workspace) {
        SettingsInfoImpl s = new SettingsInfoImpl();
        s.setWorkspace(workspace);
        String id = workspace == null ? "global-settings-id" : workspace.getName() + "-settings-id";
        OwsUtils.set((Object)s, (String)"id", (Object)id);
        s.setTitle((String)(workspace == null ? "Global Settings" : workspace.getName() + " Settings"));
        s.setCharset("UTF-8");
        s.setNumDecimals(9);
        s.setOnlineResource("http://geoserver.org");
        s.setProxyBaseUrl("http://test.geoserver.org");
        s.setSchemaBaseUrl("file:data/schemas");
        s.setVerbose(true);
        s.setVerboseExceptions(true);
        return s;
    }

    public LayerGroupInfoImpl createLayerGroup(String name, List<? extends PublishedInfo> layers) {
        LayerGroupInfo lg = this.catalog.getFactory().createLayerGroup();
        lg = (LayerGroupInfo)SecureCatalogImpl.unwrap((Object)lg);
        lg.setName(name);
        lg.setTitle(name);
        lg.getLayers().addAll(layers);
        return (LayerGroupInfoImpl)lg;
    }

    public WMSStoreInfoImpl createWmsStore(WorkspaceInfo ws) {
        WMSStoreInfo wms = this.catalog.getFactory().createWebMapServer();
        wms = (WMSStoreInfo)SecureCatalogImpl.unwrap((Object)wms);
        wms.setName("wms-store");
        wms.setWorkspace(ws);
        wms.setCapabilitiesURL("http://test.com/wms?");
        return (WMSStoreInfoImpl)wms;
    }

    public static final class TestService2Loader
    extends XStreamServiceLoader<TestService2> {
        public TestService2Loader(GeoServerResourceLoader resourceLoader) {
            super(resourceLoader, "service2");
        }

        public Class<TestService2> getServiceClass() {
            return TestService2.class;
        }

        protected TestService2 createServiceFromScratch(GeoServer gs) {
            TestService2.TestService2Impl s = new TestService2.TestService2Impl();
            s.setName("TestService2");
            return s;
        }
    }

    public static final class TestService1Loader
    extends XStreamServiceLoader<TestService1> {
        public TestService1Loader(GeoServerResourceLoader resourceLoader) {
            super(resourceLoader, "service1");
        }

        public Class<TestService1> getServiceClass() {
            return TestService1.class;
        }

        protected TestService1 createServiceFromScratch(GeoServer gs) {
            TestService1.TestService1Impl s = new TestService1.TestService1Impl();
            s.setName("TestService1");
            return s;
        }
    }

    public static interface TestService2
    extends ServiceInfo {

        public static class TestService2Impl
        extends ServiceInfoImpl
        implements TestService2 {
            public boolean equals(Object o) {
                return o instanceof TestService2Impl && super.equals(o);
            }

            public int hashCode() {
                return Objects.hash(this.getClass(), this);
            }
        }
    }

    public static interface TestService1
    extends ServiceInfo {

        public static class TestService1Impl
        extends ServiceInfoImpl
        implements TestService1 {
            public boolean equals(Object o) {
                return o instanceof TestService1Impl && super.equals(o);
            }

            public int hashCode() {
                return Objects.hash(this.getClass(), this);
            }
        }
    }
}

