/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import org.easymock.Capture;
import org.geoserver.config.util.SecureXStream;
import org.geoserver.util.PropertyRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.AllOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class SecureXStreamTest {
    @Rule
    public PropertyRule whitelistProperty = PropertyRule.system((String)"GEOSERVER_XSTREAM_WHITELIST");

    @Test
    public void testPropertyCanAllow() throws Exception {
        this.whitelistProperty.setValue("org.easymock.**");
        SecureXStream xs = new SecureXStream();
        Object o = xs.fromXML("<" + Capture.class.getCanonicalName() + " />");
        MatcherAssert.assertThat((Object)o, (Matcher)Matchers.instanceOf(Capture.class));
        Assert.assertThrows(SecureXStream.ForbiddenClassExceptionEx.class, () -> xs.fromXML("<" + AllOf.class.getCanonicalName() + " />"));
    }

    @Test
    public void testPropertyCanAllowMultiple() throws Exception {
        this.whitelistProperty.setValue("org.easymock.**; org.junit.**");
        SecureXStream xs = new SecureXStream();
        Object o1 = xs.fromXML("<" + Capture.class.getCanonicalName() + " />");
        MatcherAssert.assertThat((Object)o1, (Matcher)Matchers.instanceOf(Capture.class));
        Object o2 = xs.fromXML("<" + TestName.class.getCanonicalName() + " />");
        MatcherAssert.assertThat((Object)o2, (Matcher)Matchers.instanceOf(TestName.class));
        Assert.assertThrows(SecureXStream.ForbiddenClassExceptionEx.class, () -> xs.fromXML("<" + AllOf.class.getCanonicalName() + " />"));
    }

    @Test
    public void testErrorMessage() throws Exception {
        SecureXStream xs = new SecureXStream();
        try {
            xs.fromXML("<" + Capture.class.getCanonicalName() + " />");
        }
        catch (SecureXStream.ForbiddenClassExceptionEx e) {
            Assert.assertEquals((Object)"Unauthorized class found, see logs for more details on how to handle it: org.easymock.Capture", (Object)e.getMessage());
        }
    }
}

