/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.coverage;

import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.config.CoverageAccessInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.impl.CoverageAccessInfoImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.coverage.CoverageAccessInitializer;
import org.junit.Assert;
import org.junit.Test;

public class CoverageAccessInitializerTest {
    @Test
    public void testChangePoolSize() throws Exception {
        CoverageAccessInfoImpl caInfo = new CoverageAccessInfoImpl();
        caInfo.setCorePoolSize(5);
        caInfo.setMaxPoolSize(5);
        GeoServerInfoImpl gsInfo = new GeoServerInfoImpl();
        gsInfo.setCoverageAccess((CoverageAccessInfo)caInfo);
        GeoServer gs = (GeoServer)EasyMock.createNiceMock(GeoServer.class);
        Catalog catalog = (Catalog)EasyMock.createNiceMock(Catalog.class);
        ResourcePool rp = ResourcePool.create((Catalog)catalog);
        EasyMock.expect((Object)gs.getCatalog()).andReturn((Object)catalog).anyTimes();
        EasyMock.expect((Object)gs.getGlobal()).andReturn((Object)gsInfo).anyTimes();
        EasyMock.expect((Object)catalog.getResourcePool()).andReturn((Object)rp).anyTimes();
        EasyMock.replay((Object[])new Object[]{gs});
        EasyMock.replay((Object[])new Object[]{catalog});
        CoverageAccessInitializer initializer = new CoverageAccessInitializer();
        initializer.initialize(gs);
        Assert.assertEquals((long)5L, (long)rp.getCoverageExecutor().getCorePoolSize());
        Assert.assertEquals((long)5L, (long)rp.getCoverageExecutor().getMaximumPoolSize());
        caInfo.setCorePoolSize(32);
        caInfo.setMaxPoolSize(32);
        initializer.initialize(gs);
        Assert.assertEquals((long)32L, (long)rp.getCoverageExecutor().getCorePoolSize());
        Assert.assertEquals((long)32L, (long)rp.getCoverageExecutor().getMaximumPoolSize());
        caInfo.setCorePoolSize(5);
        caInfo.setMaxPoolSize(5);
        initializer.initialize(gs);
        Assert.assertEquals((long)5L, (long)rp.getCoverageExecutor().getCorePoolSize());
        Assert.assertEquals((long)5L, (long)rp.getCoverageExecutor().getMaximumPoolSize());
    }
}

