/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.test;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.data.property.PropertyDataStoreFactory;
import org.junit.Assert;
import org.junit.Test;

public class PropertyDataStoreRelativeUrlTest
extends GeoServerSystemTestSupport {
    @Test
    public void testPropertyDataStoreRelativeUrl() throws IOException {
        File testDS = new File(testData.getDataDirectoryRoot(), "testDS").getCanonicalFile();
        testDS.mkdir();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PropertyDataStoreFactory.DIRECTORY.key, "file:./testDS");
        params.put(PropertyDataStoreFactory.NAMESPACE.key, "http://www.geotools.org/test");
        DataStoreInfoImpl info = new DataStoreInfoImpl(this.getGeoServer().getCatalog());
        info.setConnectionParameters(params);
        DataAccessFactory f = this.getGeoServer().getCatalog().getResourcePool().getDataStoreFactory((DataStoreInfo)info);
        Assert.assertNotNull((Object)f);
        Assert.assertTrue((boolean)(f instanceof PropertyDataStoreFactory));
        DataAccess store = this.getGeoServer().getCatalog().getResourcePool().getDataStore((DataStoreInfo)info);
        Assert.assertEquals((Object)testDS.toURI().toString().toLowerCase(), (Object)store.getInfo().getSource().toString().replace("/./", "/").toLowerCase());
    }
}

