/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.csp;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.SettingsInfoImpl;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.ows.ProxifyingURLMangler;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.csp.CSPConfiguration;
import org.geoserver.security.csp.CSPHeaderDAO;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class CSPHeaderDAOTest {
    @ClassRule
    public static TemporaryFolder folder = new TemporaryFolder();
    private static XStreamPersisterFactory xpf = null;
    private static GeoServerDataDirectory dd = null;
    private static CSPHeaderDAO dao = null;
    private static SettingsInfo settings = null;

    @BeforeClass
    public static void initDAO() throws IOException {
        dd = new GeoServerDataDirectory(folder.getRoot());
        xpf = new XStreamPersisterFactory();
        GeoServer geoServer = (GeoServer)Mockito.mock(GeoServer.class);
        settings = new SettingsInfoImpl();
        settings.setUseHeadersProxyURL(Boolean.valueOf(false));
        Mockito.when((Object)geoServer.getSettings()).thenReturn((Object)settings);
        dao = new CSPHeaderDAO(geoServer, dd, xpf);
        GeoServerExtensionsHelper.singleton("proxyfier", new ProxifyingURLMangler(geoServer), URLMangler.class);
    }

    @AfterClass
    public static void clearExtensions() {
        GeoServerExtensionsHelper.clear();
    }

    @Before
    public void resetDAO() throws Exception {
        dao.reset();
        CSPConfiguration config = dao.getConfig();
        config.setReportOnly(false);
        dao.setConfig(config);
    }

    @After
    public void remoteThreadLocal() {
        CSPHeaderDAO.removeProxyPolicy();
    }

    @Before
    @After
    public void resetProperties() {
        System.clearProperty("geoserver.csp.remoteResources");
        System.clearProperty("PROXY_BASE_URL");
    }

    @Test
    public void testInitializeFromExistingFiles() throws Exception {
        long configLastModified = CSPHeaderDAOTest.configFile().lastmodified();
        long defaultLastModified = CSPHeaderDAOTest.defaultFile().lastmodified();
        Thread.sleep(5L);
        new CSPHeaderDAO(null, dd, xpf);
        Assert.assertEquals((String)"csp.xml was unexpectedly updated", (long)configLastModified, (long)CSPHeaderDAOTest.configFile().lastmodified());
        Assert.assertEquals((String)"csp_default.xml was unexpectedly updated", (long)defaultLastModified, (long)CSPHeaderDAOTest.defaultFile().lastmodified());
    }

    @Test
    public void testInitializeDoNotUpdatedFile() throws Exception {
        Files.write(CSPHeaderDAOTest.configFile().file().toPath(), "<config></config>".getBytes(), new OpenOption[0]);
        long configLastModified = CSPHeaderDAOTest.configFile().lastmodified();
        long defaultLastModified = CSPHeaderDAOTest.defaultFile().lastmodified();
        Thread.sleep(5L);
        new CSPHeaderDAO(null, dd, xpf);
        Assert.assertEquals((String)"csp.xml was unexpectedly updated", (long)configLastModified, (long)CSPHeaderDAOTest.configFile().lastmodified());
        Assert.assertEquals((String)"csp_default.xml was unexpectedly updated", (long)defaultLastModified, (long)CSPHeaderDAOTest.defaultFile().lastmodified());
    }

    @Test
    public void testInitializeWithMissingDefaultFile() throws Exception {
        long configLastModified = CSPHeaderDAOTest.configFile().lastmodified();
        Files.delete(CSPHeaderDAOTest.defaultFile().file().toPath());
        Thread.sleep(5L);
        new CSPHeaderDAO(null, dd, xpf);
        Assert.assertEquals((String)"csp.xml was unexpectedly updated", (long)configLastModified, (long)CSPHeaderDAOTest.configFile().lastmodified());
        Assert.assertEquals((String)"csp_default.xml was not re-created", (Object)Resource.Type.RESOURCE, (Object)CSPHeaderDAOTest.defaultFile().getType());
    }

    @Test
    public void testInitializeUpdateOutdatedFiles() throws Exception {
        Files.write(CSPHeaderDAOTest.configFile().file().toPath(), "<config></config>".getBytes(), new OpenOption[0]);
        Files.write(CSPHeaderDAOTest.defaultFile().file().toPath(), "<config></config>".getBytes(), new OpenOption[0]);
        long configLastModified = CSPHeaderDAOTest.configFile().lastmodified();
        long defaultLastModified = CSPHeaderDAOTest.defaultFile().lastmodified();
        Thread.sleep(5L);
        new CSPHeaderDAO(null, dd, xpf);
        Assert.assertNotEquals((String)"csp.xml was not updated", (long)configLastModified, (long)CSPHeaderDAOTest.configFile().lastmodified());
        Assert.assertNotEquals((String)"csp_default.xml was not updated", (long)defaultLastModified, (long)CSPHeaderDAOTest.defaultFile().lastmodified());
    }

    @Test
    public void testInitRequestNoProxyPolicy() throws Exception {
        Assert.assertNull((Object)dao.init(null));
    }

    @Test
    public void testInitRequestProxyPropertySet() throws Exception {
        System.setProperty("PROXY_BASE_URL", "http://foo");
        CSPHeaderDAO.setProxyPolicy((String)"default-src: ${proxy.base.url}");
        Assert.assertNull((Object)dao.init(null));
    }

    @Test
    public void testInitRequestNoLocalSettings() throws Exception {
        CSPHeaderDAO.setProxyPolicy((String)"default-src: ${proxy.base.url}");
        Assert.assertNull((Object)dao.init(null));
    }

    @Test
    public void testInitRequestNoLocalProxyBaseUrl() throws Exception {
        CSPHeaderDAO.setProxyPolicy((String)"default-src: ${proxy.base.url}");
        try {
            settings.setWorkspace((WorkspaceInfo)new WorkspaceInfoImpl());
            Assert.assertNull((Object)dao.init(null));
        }
        finally {
            settings.setWorkspace(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitRequestConfigException() throws Exception {
        CSPHeaderDAO.setProxyPolicy((String)"default-src: ${proxy.base.url}");
        Request request = new Request();
        Path file1 = dd.getSecurity(new String[]{"csp.xml"}).file().toPath();
        try {
            Files.write(file1, new byte[0], new OpenOption[0]);
            settings.setWorkspace((WorkspaceInfo)new WorkspaceInfoImpl());
            settings.setProxyBaseUrl("http://foo");
            Assert.assertSame((Object)request, (Object)dao.init(request));
        }
        catch (Throwable throwable) {
            settings.setWorkspace(null);
            settings.setProxyBaseUrl(null);
            Path file2 = dd.getSecurity(new String[]{"csp_default.xml"}).file().toPath();
            Files.copy(file2, file1, StandardCopyOption.REPLACE_EXISTING);
            throw throwable;
        }
        settings.setWorkspace(null);
        settings.setProxyBaseUrl(null);
        Path file2 = dd.getSecurity(new String[]{"csp_default.xml"}).file().toPath();
        Files.copy(file2, file1, StandardCopyOption.REPLACE_EXISTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitRequestWithSameLocalProxyBaseUrl() throws Exception {
        String expected = "default-src: http://foo;";
        CSPHeaderDAO.setProxyPolicy((String)"default-src: ${proxy.base.url}");
        MockHttpServletRequest httpRequest = new MockHttpServletRequest();
        httpRequest.addHeader("Host", (Object)"localhost");
        HttpServletResponse httpResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)httpResponse.getHeader("Content-Security-Policy")).thenReturn((Object)expected);
        Request request = new Request();
        request.setHttpRequest((HttpServletRequest)httpRequest);
        request.setHttpResponse(httpResponse);
        try {
            settings.setWorkspace((WorkspaceInfo)new WorkspaceInfoImpl());
            settings.setProxyBaseUrl("http://foo");
            Assert.assertSame((Object)request, (Object)dao.init(request));
            ((HttpServletResponse)Mockito.verify((Object)httpResponse, (VerificationMode)Mockito.never())).setHeader((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        }
        finally {
            settings.setWorkspace(null);
            settings.setProxyBaseUrl(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitRequestWithDifferentLocalProxyBaseUrl() throws Exception {
        CSPHeaderDAO.setProxyPolicy((String)"default-src: ${proxy.base.url}");
        MockHttpServletRequest httpRequest = new MockHttpServletRequest();
        httpRequest.addHeader("Host", (Object)"localhost");
        MockHttpServletResponse httpResponse = new MockHttpServletResponse();
        httpResponse.setHeader("Content-Security-Policy", "default-src: http://bar;");
        Request request = new Request();
        request.setHttpRequest((HttpServletRequest)httpRequest);
        request.setHttpResponse((HttpServletResponse)httpResponse);
        try {
            settings.setWorkspace((WorkspaceInfo)new WorkspaceInfoImpl());
            settings.setProxyBaseUrl("http://foo");
            Assert.assertSame((Object)request, (Object)dao.init(request));
            Assert.assertEquals((Object)"default-src: http://foo;", (Object)httpResponse.getHeader("Content-Security-Policy"));
        }
        finally {
            settings.setWorkspace(null);
            settings.setProxyBaseUrl(null);
        }
    }

    @Test
    public void testGetPropertyValueInvalidKey() throws Exception {
        Assert.assertEquals((Object)"", (Object)CSPHeaderDAO.getPropertyValue(null, null, (String)"java.version"));
    }

    @Test
    public void testGetPropertyValueInvalidPropertyValue() throws Exception {
        CSPConfiguration config = new CSPConfiguration();
        System.setProperty("geoserver.csp.remoteResources", "~!@#$");
        Assert.assertEquals((Object)"", (Object)CSPHeaderDAO.getPropertyValue(null, (CSPConfiguration)config, (String)"geoserver.csp.remoteResources"));
    }

    @Test
    public void testGetPropertyValueInvalidFieldValue() throws Exception {
        CSPConfiguration config = new CSPConfiguration();
        config.setRemoteResources("~!@#$");
        Assert.assertEquals((Object)"", (Object)CSPHeaderDAO.getPropertyValue(null, (CSPConfiguration)config, (String)"geoserver.csp.remoteResources"));
    }

    @Test
    public void testGetPropertyValueMissingValue() throws Exception {
        CSPConfiguration config = new CSPConfiguration();
        Assert.assertEquals((Object)"", (Object)CSPHeaderDAO.getPropertyValue(null, (CSPConfiguration)config, (String)"geoserver.csp.remoteResources"));
    }

    @Test
    public void testGetPropertyValueValidPropertyValue() throws Exception {
        String expected = "http://geoserver.org";
        CSPConfiguration config = new CSPConfiguration();
        System.setProperty("geoserver.csp.remoteResources", expected);
        Assert.assertEquals((Object)expected, (Object)CSPHeaderDAO.getPropertyValue(null, (CSPConfiguration)config, (String)"geoserver.csp.remoteResources"));
    }

    @Test
    public void testGetPropertyValueValidFieldValue() throws Exception {
        String expected = "http://geoserver.org";
        CSPConfiguration config = new CSPConfiguration();
        config.setRemoteResources(expected);
        Assert.assertEquals((Object)expected, (Object)CSPHeaderDAO.getPropertyValue(null, (CSPConfiguration)config, (String)"geoserver.csp.remoteResources"));
    }

    @Test
    public void testMatchesProxyBaseWrongProtocol() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("http");
        Assert.assertFalse((boolean)CSPHeaderDAO.matchesProxyBase((HttpServletRequest)request, (URL)new URL("https://foo")));
    }

    @Test
    public void testMatchesProxyBaseWrongHost() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("https");
        request.addHeader("Host", (Object)"bar");
        Assert.assertFalse((boolean)CSPHeaderDAO.matchesProxyBase((HttpServletRequest)request, (URL)new URL("https://foo")));
    }

    @Test
    public void testMatchesProxyBaseWrongPort() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("https");
        request.addHeader("Host", (Object)"foo:8080");
        Assert.assertFalse((boolean)CSPHeaderDAO.matchesProxyBase((HttpServletRequest)request, (URL)new URL("https://foo")));
    }

    @Test
    public void testMatchesProxyBaseNoForwardedHeaderDefaultPort() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("https");
        request.addHeader("Host", (Object)"foo");
        Assert.assertTrue((boolean)CSPHeaderDAO.matchesProxyBase((HttpServletRequest)request, (URL)new URL("https://foo")));
    }

    @Test
    public void testMatchesProxyBaseWithXForwardedHeaders() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("X-Forwarded-Proto", (Object)"https");
        request.addHeader("X-Forwarded-Host", (Object)"foo");
        request.addHeader("X-Forwarded-Port", (Object)"443");
        Assert.assertTrue((boolean)CSPHeaderDAO.matchesProxyBase((HttpServletRequest)request, (URL)new URL("https://foo")));
    }

    @Test
    public void testMatchesProxyBaseWithXForwardedPort() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("X-Forwarded-Proto", (Object)"https");
        request.addHeader("X-Forwarded-Host", (Object)"foo:8443");
        request.addHeader("X-Forwarded-Port", (Object)"443");
        Assert.assertTrue((boolean)CSPHeaderDAO.matchesProxyBase((HttpServletRequest)request, (URL)new URL("https://foo")));
    }

    @Test
    public void testMatchesProxyBaseWithForwardedHeaderDefaultPort() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Forwarded", (Object)"for=127.0.0.1;proto=https;host=foo");
        Assert.assertTrue((boolean)CSPHeaderDAO.matchesProxyBase((HttpServletRequest)request, (URL)new URL("https://foo")));
    }

    @Test
    public void testMatchesProxyBaseWithForwardedHeaderWithPort() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Forwarded", (Object)"for=127.0.0.1;proto=https;host=foo:8443");
        Assert.assertTrue((boolean)CSPHeaderDAO.matchesProxyBase((HttpServletRequest)request, (URL)new URL("https://foo:8443")));
    }

    @Test
    public void testMatchesProxyBaseWithMissingForwardedHeaderParts() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Forwarded", (Object)"for=127.0.0.1");
        Assert.assertFalse((boolean)CSPHeaderDAO.matchesProxyBase((HttpServletRequest)request, (URL)new URL("https://foo")));
    }

    private static Resource configFile() {
        return dd.getSecurity(new String[]{"csp.xml"});
    }

    private static Resource defaultFile() {
        return dd.getSecurity(new String[]{"csp_default.xml"});
    }
}

