/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.csp.predicate;

import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.csp.CSPHttpRequestWrapper;
import org.geoserver.security.csp.predicate.CSPPredicatePath;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class CSPPredicatePathTest {
    private MockHttpServletRequest request = null;
    private CSPHttpRequestWrapper wrapper = null;

    @Before
    public void setUp() {
        this.request = new MockHttpServletRequest();
        this.wrapper = new CSPHttpRequestWrapper((HttpServletRequest)this.request, null);
    }

    @Test
    public void testConstructorInvalidRegex() {
        Assert.assertThrows(PatternSyntaxException.class, () -> new CSPPredicatePath("["));
    }

    @Test
    public void testPredicateMatches() {
        CSPPredicatePath predicate = new CSPPredicatePath("^/([^/]+/){0,2}wms/?$");
        this.request.setPathInfo("/wms");
        Assert.assertTrue((boolean)predicate.test(this.wrapper));
        this.request.setPathInfo("/wms/");
        Assert.assertTrue((boolean)predicate.test(this.wrapper));
        this.request.setPathInfo("/foo/wms");
        Assert.assertTrue((boolean)predicate.test(this.wrapper));
        this.request.setPathInfo("/foo/wms/");
        Assert.assertTrue((boolean)predicate.test(this.wrapper));
        this.request.setPathInfo("/foo/bar/wms");
        Assert.assertTrue((boolean)predicate.test(this.wrapper));
        this.request.setPathInfo("/foo/bar/wms/");
        Assert.assertTrue((boolean)predicate.test(this.wrapper));
    }

    @Test
    public void testPredicateNotMatches() {
        CSPPredicatePath predicate = new CSPPredicatePath("^/([^/]+/){0,2}wms/?$");
        this.request.setPathInfo("");
        Assert.assertFalse((boolean)predicate.test(this.wrapper));
        this.request.setPathInfo("/");
        Assert.assertFalse((boolean)predicate.test(this.wrapper));
        this.request.setPathInfo("/wfs");
        Assert.assertFalse((boolean)predicate.test(this.wrapper));
        this.request.setPathInfo("/foo/wfs/");
        Assert.assertFalse((boolean)predicate.test(this.wrapper));
        this.request.setPathInfo("/foo/bar/wfs");
        Assert.assertFalse((boolean)predicate.test(this.wrapper));
    }
}

