/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.easymock.EasyMock;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DefaultSecureCatalogFactory;
import org.geoserver.security.decorators.SecuredWMSStoreInfo;
import org.geoserver.security.decorators.SecuredWMTSStoreInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultSecureCatalogFactoryTest {
    DefaultSecureCatalogFactory defaultSecureCatalogFactory = new DefaultSecureCatalogFactory();
    WrapperPolicy wrapperPolicy = (WrapperPolicy)EasyMock.createMock(WrapperPolicy.class);

    @Before
    public void setup() {
        this.defaultSecureCatalogFactory = new DefaultSecureCatalogFactory();
        this.wrapperPolicy = (WrapperPolicy)EasyMock.createMock(WrapperPolicy.class);
    }

    @Test
    public void secureWMSStoreInfo() {
        SecuredWMSStoreInfo securedWMSStoreInfo = (SecuredWMSStoreInfo)EasyMock.createMock(SecuredWMSStoreInfo.class);
        Object object = this.defaultSecureCatalogFactory.secure((Object)securedWMSStoreInfo, this.wrapperPolicy);
        Assert.assertTrue((boolean)(object instanceof SecuredWMSStoreInfo));
    }

    @Test
    public void canSecureWMSStoreInfo() {
        Class<WMSStoreInfo> clazz = WMSStoreInfo.class;
        boolean bool = this.defaultSecureCatalogFactory.canSecure(clazz);
        Assert.assertTrue((boolean)bool);
    }

    @Test
    public void secureWMTSStoreInfo() {
        DefaultSecureCatalogFactory defaultSecureCatalogFactory = new DefaultSecureCatalogFactory();
        WrapperPolicy wrapperPolicy = (WrapperPolicy)EasyMock.createMock(WrapperPolicy.class);
        SecuredWMTSStoreInfo securedWMTSStoreInfo = (SecuredWMTSStoreInfo)EasyMock.createMock(SecuredWMTSStoreInfo.class);
        Object object = defaultSecureCatalogFactory.secure((Object)securedWMTSStoreInfo, wrapperPolicy);
        Assert.assertTrue((boolean)(object instanceof SecuredWMTSStoreInfo));
    }

    @Test
    public void canSecureWMTSStoreInfo() {
        Class<WMTSStoreInfo> clazz = WMTSStoreInfo.class;
        boolean bool = this.defaultSecureCatalogFactory.canSecure(clazz);
        Assert.assertTrue((boolean)bool);
    }
}

