/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredObjects;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;

public abstract class SecuredResourceInfoTest<D extends ResourceInfo, S extends ResourceInfo>
extends GeoServerSystemTestSupport {
    protected final WrapperPolicy policy = WrapperPolicy.readOnlyHide((AccessLimits)new AccessLimits(CatalogMode.HIDE));

    abstract D createDelegate();

    abstract Class<?> getDelegateClass();

    abstract S createSecuredDecorator(D var1);

    abstract Class<?> getSecuredDecoratorClass();

    abstract Class<?> getSecuredStoreInfoClass();

    abstract int getStackOverflowCount();

    private Thread getRoundTripThread(S source, S target) {
        Runnable runnable = () -> {
            for (int i = 0; i < this.getStackOverflowCount(); ++i) {
                target.setStore(source.getStore());
            }
        };
        return new Thread(Thread.currentThread().getThreadGroup(), runnable, "RoundTripThread", 5L);
    }

    @Test
    public void testCanSecure() throws Exception {
        D delegate = this.createDelegate();
        Object secure = SecuredObjects.secure(delegate, (WrapperPolicy)this.policy);
        Assert.assertTrue((String)"Unable to secure ResourceInfo", (boolean)this.getSecuredDecoratorClass().isAssignableFrom(secure.getClass()));
    }

    @Test
    public void testCanSecureProxied() throws Exception {
        D delegate = this.createDelegate();
        ResourceInfo proxy = (ResourceInfo)ModificationProxy.create(delegate, this.getDelegateClass());
        Object secure = SecuredObjects.secure((Object)proxy, (WrapperPolicy)this.policy);
        Assert.assertTrue((String)"Unable to secure proxied Resourceinfo", (boolean)this.getSecuredDecoratorClass().isAssignableFrom(secure.getClass()));
    }

    @Test
    public void testSecureWrapping() throws Exception {
        D delegate = this.createDelegate();
        Assert.assertFalse((String)"ResourceInfo delegate should not be Secured", (boolean)this.getSecuredDecoratorClass().isAssignableFrom(delegate.getClass()));
        S secured = this.createSecuredDecorator(delegate);
        Assert.assertTrue((String)"ResourceInfo delegate should be Secured", (boolean)this.getSecuredDecoratorClass().isAssignableFrom(secured.getClass()));
        StoreInfo securedStore = secured.getStore();
        Assert.assertTrue((String)"Secured ResourceInfo should return a Secured StoreInfo", (boolean)this.getSecuredStoreInfoClass().isAssignableFrom(securedStore.getClass()));
        Thread roundTripThread = this.getRoundTripThread(secured, secured);
        StringWriter sw = new StringWriter();
        roundTripThread.setUncaughtExceptionHandler((t, e) -> e.printStackTrace(new PrintWriter((Writer)sw, true)));
        roundTripThread.start();
        roundTripThread.join();
        StringBuffer buffer = sw.getBuffer();
        if (buffer.length() > 0) {
            Assert.fail((String)buffer.toString());
        }
        try {
            SecureCatalogImpl.unwrap((Object)secured.getStore());
        }
        catch (Throwable t2) {
            t2.printStackTrace(new PrintWriter((Writer)sw, true));
        }
        buffer = sw.getBuffer();
        if (buffer.length() > 0) {
            Assert.fail((String)buffer.toString());
        }
    }
}

