/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.util.List;
import org.geoserver.security.impl.AbstractFileAccessTest;
import org.geoserver.security.impl.DefaultFileAccessManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultFileAccessManagerTest
extends AbstractFileAccessTest {
    @Test
    public void testNoRestrictions() throws Exception {
        File testDirectory = new File("./target/test").getCanonicalFile();
        this.loginAdmin();
        Assert.assertNull((Object)this.fileAccessManager.getAvailableRoots());
        Assert.assertTrue((boolean)this.fileAccessManager.checkAccess(testDirectory));
        this.login("cite", "pwd", ROLE_CITE);
        Assert.assertNull((Object)this.fileAccessManager.getAvailableRoots());
        Assert.assertTrue((boolean)this.fileAccessManager.checkAccess(testDirectory));
    }

    @Test
    public void testSystemSandbox() throws Exception {
        File systemSandbox = new File("./target/systemSandbox").getCanonicalFile();
        System.setProperty(DefaultFileAccessManager.GEOSERVER_DATA_SANDBOX, systemSandbox.getAbsolutePath());
        this.fileAccessManager.reload();
        File testDirectory = new File("./target/test").getCanonicalFile();
        this.loginAdmin();
        Assert.assertEquals((Object)this.fileAccessManager.getAvailableRoots(), List.of(systemSandbox));
        Assert.assertFalse((boolean)this.fileAccessManager.checkAccess(testDirectory));
        Assert.assertTrue((boolean)this.fileAccessManager.checkAccess(new File("./target/systemSandbox/test/a/b/c").getCanonicalFile()));
        Assert.assertFalse((boolean)this.fileAccessManager.checkAccess(new File("./target/systemSandbox/../a/b/c").getCanonicalFile()));
    }

    @Test
    public void testWorkspaceAdminSandbox() throws Exception {
        this.configureCiteAccess();
        this.login("cite", "pwd", ROLE_CITE);
        Assert.assertEquals(List.of(this.citeFolder), (Object)this.fileAccessManager.getAvailableRoots());
        Assert.assertTrue((boolean)this.fileAccessManager.checkAccess(this.citeFolder));
        Assert.assertFalse((boolean)this.fileAccessManager.checkAccess(this.cgfFolder));
        Assert.assertFalse((boolean)this.fileAccessManager.checkAccess(this.cdfFolder));
    }

    @Test
    public void testMultipleWorkspaceAdminSandbox() throws Exception {
        this.configureCiteCgfMissingAccess();
        this.loginCiteCgfMissing();
        MatcherAssert.assertThat((Object)this.fileAccessManager.getAvailableRoots(), (Matcher)Matchers.hasItems((Object[])new File[]{this.citeFolder, this.cgfFolder}));
        Assert.assertTrue((boolean)this.fileAccessManager.checkAccess(this.citeFolder));
        Assert.assertTrue((boolean)this.fileAccessManager.checkAccess(this.cgfFolder));
        Assert.assertTrue((boolean)this.fileAccessManager.checkAccess(this.missingFolder));
        Assert.assertFalse((boolean)this.fileAccessManager.checkAccess(this.cdfFolder));
    }
}

