/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.AccessMode;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.DefaultResourceAccessManager;
import org.geoserver.security.impl.GeoServerRole;
import org.geotools.api.filter.Filter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.security.core.Authentication;

public class DefaultResourceAccessManagerTest {
    @Test
    public void getAccessLimits() {
        DataAccessRuleDAO dataAccessRuleDAO = (DataAccessRuleDAO)Mockito.mock(DataAccessRuleDAO.class);
        Catalog catalog = (Catalog)Mockito.mock(Catalog.class);
        DefaultResourceAccessManager defaultResourceAccessManager = new DefaultResourceAccessManager(dataAccessRuleDAO, catalog);
        Authentication authentication = (Authentication)Mockito.mock(Authentication.class);
        WorkspaceInfo workspaceInfo = (WorkspaceInfo)Mockito.mock(WorkspaceInfo.class);
        List<GeoServerRole> grantedAuthorities = Collections.singletonList(new GeoServerRole("ROLE_ADMINISTRATOR"));
        Mockito.when((Object)authentication.getAuthorities()).thenReturn(grantedAuthorities);
        WorkspaceAccessLimits workspaceAccessLimits = defaultResourceAccessManager.getAccessLimits(authentication, workspaceInfo);
        Assert.assertNotNull((Object)workspaceAccessLimits);
    }

    @Test
    public void testSecurityFilterCache() {
        Catalog catalog = (Catalog)Mockito.mock(Catalog.class);
        Mockito.when((Object)catalog.getWorkspaceByName("ws")).thenReturn((Object)((WorkspaceInfo)Mockito.mock(WorkspaceInfo.class)));
        LayerInfo layer1 = (LayerInfo)Mockito.mock(LayerInfo.class);
        LayerInfo layer2 = (LayerInfo)Mockito.mock(LayerInfo.class);
        ResourceInfo res1 = (ResourceInfo)Mockito.mock(ResourceInfo.class);
        ResourceInfo res2 = (ResourceInfo)Mockito.mock(ResourceInfo.class);
        Mockito.when((Object)layer1.getResource()).thenReturn((Object)res1);
        Mockito.when((Object)layer2.getResource()).thenReturn((Object)res2);
        Mockito.when((Object)res1.getId()).thenReturn((Object)"resource1");
        Mockito.when((Object)res2.getId()).thenReturn((Object)"resource2");
        Mockito.when((Object)catalog.getLayerByName("ws:layer1")).thenReturn((Object)layer1);
        Mockito.when((Object)catalog.getLayerByName("ws:layer2")).thenReturn((Object)layer2);
        DataAccessRuleDAO dataAccessRuleDAO = (DataAccessRuleDAO)Mockito.mock(DataAccessRuleDAO.class);
        DataAccessRule rule1 = new DataAccessRule("ws", "layer1", AccessMode.READ, new String[]{"MY_ROLE"});
        DataAccessRule rule2 = new DataAccessRule("ws", "layer2", AccessMode.READ, new String[]{"OTHER_ROLE"});
        Mockito.when((Object)dataAccessRuleDAO.getRules()).thenReturn((Object)Lists.newArrayList((Object[])new DataAccessRule[]{rule1, rule2}));
        DefaultResourceAccessManager defaultResourceAccessManager = new DefaultResourceAccessManager(dataAccessRuleDAO, catalog);
        Authentication authentication = (Authentication)Mockito.mock(Authentication.class);
        List<GeoServerRole> grantedAuthorities = Collections.singletonList(new GeoServerRole("MY_ROLE"));
        Mockito.when((Object)authentication.getAuthorities()).thenReturn(grantedAuthorities);
        Filter fil = defaultResourceAccessManager.getSecurityFilter(authentication, ResourceInfo.class);
        Assert.assertEquals((Object)Predicates.not((Filter)Predicates.in((String)"id", Collections.singletonList("resource2"))), (Object)fil);
        Filter fil2 = defaultResourceAccessManager.getSecurityFilter(authentication, ResourceInfo.class);
        Assert.assertSame((Object)fil2, (Object)fil);
        rule2 = new DataAccessRule("ws", "layer2", AccessMode.READ, new String[]{"MY_ROLE"});
        Mockito.when((Object)dataAccessRuleDAO.getRules()).thenReturn((Object)Lists.newArrayList((Object[])new DataAccessRule[]{rule1, rule2}));
        Mockito.when((Object)dataAccessRuleDAO.getLastModified()).thenReturn((Object)System.currentTimeMillis());
        fil = defaultResourceAccessManager.getSecurityFilter(authentication, ResourceInfo.class);
        Assert.assertEquals((Object)Predicates.acceptAll(), (Object)fil);
    }
}

