/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.security.impl.LayerGroupContainmentCache;
import org.geotools.api.feature.type.Name;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.util.URLs;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.context.event.ContextRefreshedEvent;

public class LayerGroupContainmentCacheTest {
    private static final String WS = "ws";
    private static final String ANOTHER_WS = "anotherWs";
    private static final String NATURE_GROUP = "nature";
    private static final String CONTAINER_GROUP = "containerGroup";
    private LayerGroupContainmentCache cc;
    private LayerGroupInfo nature;
    private LayerGroupInfo container;
    private static Catalog catalog;

    @BeforeClass
    public static void setupBaseCatalog() throws Exception {
        GeoServerExtensionsHelper.setIsSpringContext(false);
        catalog = new CatalogImpl();
        catalog.setResourceLoader(new GeoServerResourceLoader());
        LayerGroupContainmentCacheTest.addWorkspaceNamespace(WS);
        LayerGroupContainmentCacheTest.addWorkspaceNamespace(ANOTHER_WS);
        CatalogBuilder cb = new CatalogBuilder(catalog);
        WorkspaceInfo defaultWorkspace = catalog.getDefaultWorkspace();
        cb.setWorkspace(defaultWorkspace);
        String nsURI = catalog.getDefaultNamespace().getURI();
        URL buildings = MockData.class.getResource("Buildings.properties");
        File testData = URLs.urlToFile((URL)buildings).getParentFile();
        DataStoreInfo storeInfo = cb.buildDataStore("store");
        storeInfo.getConnectionParameters().put("directory", testData);
        storeInfo.getConnectionParameters().put("namespace", nsURI);
        catalog.save((StoreInfo)storeInfo);
        PropertyDataStore store = new PropertyDataStore(testData);
        store.setNamespaceURI(nsURI);
        cb.setStore((StoreInfo)catalog.getDefaultDataStore(defaultWorkspace));
        for (Name name : store.getNames()) {
            FeatureTypeInfo ft = cb.buildFeatureType(name);
            cb.setupBounds((ResourceInfo)ft);
            catalog.add((ResourceInfo)ft);
            LayerInfo layer = cb.buildLayer(ft);
            catalog.add(layer);
        }
    }

    private static void addWorkspaceNamespace(String wsName) {
        WorkspaceInfoImpl ws = new WorkspaceInfoImpl();
        ws.setName(wsName);
        catalog.add((WorkspaceInfo)ws);
        NamespaceInfoImpl ns = new NamespaceInfoImpl();
        ns.setPrefix(wsName);
        ns.setURI("http://www.geoserver.org/" + wsName);
        catalog.add((NamespaceInfo)ns);
    }

    @Before
    public void setupLayerGrups() throws Exception {
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        LayerInfo forests = catalog.getLayerByName(this.getLayerId(MockData.FORESTS));
        LayerInfo roads = catalog.getLayerByName(this.getLayerId(MockData.ROAD_SEGMENTS));
        WorkspaceInfo ws = catalog.getDefaultWorkspace();
        this.nature = this.addLayerGroup(NATURE_GROUP, LayerGroupInfo.Mode.SINGLE, ws, new PublishedInfo[]{lakes, forests});
        this.container = this.addLayerGroup(CONTAINER_GROUP, LayerGroupInfo.Mode.CONTAINER, null, new PublishedInfo[]{this.nature, roads});
        this.cc = new LayerGroupContainmentCache(catalog);
    }

    @After
    public void clearLayerGroups() throws Exception {
        CascadeDeleteVisitor remover = new CascadeDeleteVisitor(catalog);
        for (LayerGroupInfo lg : catalog.getLayerGroups()) {
            if (catalog.getLayerGroup(lg.getId()) == null) continue;
            remover.visit(lg);
        }
    }

    private LayerGroupInfo addLayerGroup(String name, LayerGroupInfo.Mode mode, WorkspaceInfo ws, PublishedInfo ... layers) throws Exception {
        CatalogBuilder cb = new CatalogBuilder(catalog);
        LayerGroupInfo group = catalog.getFactory().createLayerGroup();
        group.setName(name);
        group.setMode(mode);
        if (ws != null) {
            group.setWorkspace(ws);
        }
        if (layers != null) {
            for (PublishedInfo layer : layers) {
                group.getLayers().add(layer);
                group.getStyles().add(null);
            }
        }
        cb.calculateLayerGroupBounds(group);
        catalog.add(group);
        if (ws != null) {
            return catalog.getLayerGroupByName(ws.getName(), name);
        }
        return catalog.getLayerGroupByName(name);
    }

    private Set<String> set(String ... names) {
        if (names == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(names));
    }

    private Set<String> containerNamesForGroup(LayerGroupInfo lg) {
        Collection summaries = this.cc.getContainerGroupsFor(lg);
        return summaries.stream().map(gs -> gs.prefixedName()).collect(Collectors.toSet());
    }

    private Set<String> containerNamesForResource(QName name) {
        Collection summaries = this.cc.getContainerGroupsFor((ResourceInfo)this.getResource(name));
        return summaries.stream().map(gs -> gs.prefixedName()).collect(Collectors.toSet());
    }

    private FeatureTypeInfo getResource(QName name) {
        return (FeatureTypeInfo)catalog.getResourceByName(this.getLayerId(name), FeatureTypeInfo.class);
    }

    private String getLayerId(QName name) {
        return "ws:" + name.getLocalPart();
    }

    @Test
    public void buildLayerGroupCaches() {
        LayerGroupContainmentCache layerGroupContainmentCache = new LayerGroupContainmentCache(catalog);
        ContextRefreshedEvent contextRefreshedEvent = (ContextRefreshedEvent)Mockito.mock(ContextRefreshedEvent.class);
        layerGroupContainmentCache.onApplicationEvent(contextRefreshedEvent);
        Assert.assertEquals((long)2L, (long)layerGroupContainmentCache.groupCache.size());
    }

    @Test
    public void testInitialSetup() throws Exception {
        Collection natureContainers = this.cc.getContainerGroupsFor(this.nature);
        Assert.assertEquals((long)1L, (long)natureContainers.size());
        MatcherAssert.assertThat((Object)natureContainers, (Matcher)Matchers.contains((Object[])new LayerGroupContainmentCache.LayerGroupSummary[]{new LayerGroupContainmentCache.LayerGroupSummary(this.container)}));
        LayerGroupContainmentCache.LayerGroupSummary summary = (LayerGroupContainmentCache.LayerGroupSummary)natureContainers.iterator().next();
        Assert.assertNull((Object)summary.getWorkspace());
        Assert.assertEquals((Object)CONTAINER_GROUP, (Object)summary.getName());
        MatcherAssert.assertThat((Object)summary.getContainerGroups(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.cc.getContainerGroupsFor(this.container), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.LAKES), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP)));
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.FORESTS), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP)));
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.ROAD_SEGMENTS), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP)));
    }

    @Test
    public void testAddLayerToNature() throws Exception {
        LayerInfo neatline = catalog.getLayerByName(this.getLayerId(MockData.MAP_NEATLINE));
        this.nature.getLayers().add(neatline);
        this.nature.getStyles().add(null);
        catalog.save(this.nature);
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.MAP_NEATLINE), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP)));
    }

    @Test
    public void testAddLayerToContainer() throws Exception {
        LayerInfo neatline = catalog.getLayerByName(this.getLayerId(MockData.MAP_NEATLINE));
        this.container.getLayers().add(neatline);
        this.container.getStyles().add(null);
        catalog.save(this.container);
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.MAP_NEATLINE), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP)));
    }

    @Test
    public void testRemoveLayerFromNature() throws Exception {
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        this.nature.getLayers().remove(lakes);
        this.nature.getStyles().remove(0);
        catalog.save(this.nature);
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.LAKES), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.FORESTS), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP)));
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.ROAD_SEGMENTS), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP)));
    }

    @Test
    public void testRemoveLayerFromContainer() throws Exception {
        LayerInfo roads = catalog.getLayerByName(this.getLayerId(MockData.ROAD_SEGMENTS));
        this.container.getLayers().remove(roads);
        this.container.getStyles().remove(0);
        catalog.save(this.container);
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.LAKES), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP)));
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.FORESTS), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP)));
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.ROAD_SEGMENTS), (Matcher)Matchers.empty());
    }

    @Test
    public void testRemoveNatureFromContainer() throws Exception {
        this.container.getLayers().remove(this.nature);
        this.container.getStyles().remove(0);
        catalog.save(this.container);
        MatcherAssert.assertThat(this.containerNamesForGroup(this.nature), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.LAKES), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.FORESTS), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.ROAD_SEGMENTS), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP)));
    }

    @Test
    public void testRemoveAllGrups() throws Exception {
        catalog.remove(this.container);
        catalog.remove(this.nature);
        MatcherAssert.assertThat(this.containerNamesForGroup(this.nature), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.LAKES), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.FORESTS), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.ROAD_SEGMENTS), (Matcher)Matchers.empty());
    }

    @Test
    public void testAddRemoveNamed() throws Exception {
        String NAMED_GROUP = "named";
        LayerInfo neatline = catalog.getLayerByName(this.getLayerId(MockData.MAP_NEATLINE));
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        LayerGroupInfo named = this.addLayerGroup("named", LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{lakes, neatline});
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.LAKES), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP, "named")));
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.MAP_NEATLINE), (Matcher)Matchers.equalTo(this.set("named")));
        MatcherAssert.assertThat(this.containerNamesForGroup(named), (Matcher)Matchers.empty());
        catalog.remove(named);
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.LAKES), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP)));
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.MAP_NEATLINE), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.containerNamesForGroup(named), (Matcher)Matchers.empty());
    }

    @Test
    public void testAddRemoveNestedNamed() throws Exception {
        String NESTED_NAMED = "nestedNamed";
        LayerInfo neatline = catalog.getLayerByName(this.getLayerId(MockData.MAP_NEATLINE));
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        LayerGroupInfo nestedNamed = this.addLayerGroup("nestedNamed", LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{lakes, neatline});
        this.container.getLayers().add(nestedNamed);
        this.container.getStyles().add(null);
        catalog.save(this.container);
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.LAKES), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP, "nestedNamed")));
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.MAP_NEATLINE), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP, "nestedNamed")));
        MatcherAssert.assertThat(this.containerNamesForGroup(nestedNamed), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP)));
        new CascadeDeleteVisitor(catalog).visit(nestedNamed);
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.LAKES), (Matcher)Matchers.equalTo(this.set(CONTAINER_GROUP)));
        MatcherAssert.assertThat(this.containerNamesForResource(MockData.MAP_NEATLINE), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.containerNamesForGroup(nestedNamed), (Matcher)Matchers.empty());
    }

    @Test
    public void testRenameGroup() throws Exception {
        this.nature.setName("renamed");
        catalog.save(this.nature);
        LayerGroupContainmentCache.LayerGroupSummary summary = (LayerGroupContainmentCache.LayerGroupSummary)this.cc.groupCache.get(this.nature.getId());
        Assert.assertEquals((Object)"renamed", (Object)summary.getName());
        Assert.assertEquals((Object)WS, (Object)summary.getWorkspace());
    }

    @Test
    public void testRenameWorkspace() throws Exception {
        WorkspaceInfo ws = catalog.getDefaultWorkspace();
        ws.setName("renamed");
        try {
            catalog.save(ws);
            LayerGroupContainmentCache.LayerGroupSummary summary = (LayerGroupContainmentCache.LayerGroupSummary)this.cc.groupCache.get(this.nature.getId());
            Assert.assertEquals((Object)NATURE_GROUP, (Object)summary.getName());
            Assert.assertEquals((Object)"renamed", (Object)summary.getWorkspace());
        }
        finally {
            ws.setName(WS);
            catalog.save(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeWorkspace() throws Exception {
        DataStoreInfo store = (DataStoreInfo)catalog.getDataStores().get(0);
        try {
            WorkspaceInfo aws = catalog.getWorkspaceByName(ANOTHER_WS);
            store.setWorkspace(aws);
            catalog.save((StoreInfo)store);
            this.nature.setWorkspace(aws);
            catalog.save(this.nature);
            LayerGroupContainmentCache.LayerGroupSummary summary = (LayerGroupContainmentCache.LayerGroupSummary)this.cc.groupCache.get(this.nature.getId());
            Assert.assertEquals((Object)NATURE_GROUP, (Object)summary.getName());
            Assert.assertEquals((Object)ANOTHER_WS, (Object)summary.getWorkspace());
        }
        finally {
            WorkspaceInfo ws = catalog.getWorkspaceByName(WS);
            store.setWorkspace(ws);
            catalog.save((StoreInfo)store);
        }
    }

    @Test
    public void testChangeGroupMode() throws Exception {
        LayerGroupContainmentCache.LayerGroupSummary summary = (LayerGroupContainmentCache.LayerGroupSummary)this.cc.groupCache.get(this.nature.getId());
        Assert.assertEquals((Object)LayerGroupInfo.Mode.SINGLE, (Object)summary.getMode());
        this.nature.setMode(LayerGroupInfo.Mode.OPAQUE_CONTAINER);
        catalog.save(this.nature);
        summary = (LayerGroupContainmentCache.LayerGroupSummary)this.cc.groupCache.get(this.nature.getId());
        Assert.assertEquals((Object)LayerGroupInfo.Mode.OPAQUE_CONTAINER, (Object)summary.getMode());
    }
}

