/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.password.ConfigurationPasswordEncryptionHelper;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConfigurationPasswordEncryptionHelperTest {
    private Catalog catalog;
    private GeoServerSecurityManager mockSecurityManager;
    private ConfigurationPasswordEncryptionHelper helper;

    @Before
    public void setUp() {
        this.catalog = new CatalogImpl();
        GeoServerExtensionsHelper.singleton("rawCatalog", this.catalog, Catalog.class);
        this.mockSecurityManager = (GeoServerSecurityManager)Mockito.mock(GeoServerSecurityManager.class);
        this.helper = new ConfigurationPasswordEncryptionHelper(this.mockSecurityManager);
        ConfigurationPasswordEncryptionHelper.CACHE.clear();
        ConfigurationPasswordEncryptionHelper.STORE_INFO_TYPE_CACHE.clear();
    }

    @Test
    public void getEncryptedFieldsNullFactory() throws IOException {
        DataStoreInfoImpl info = new DataStoreInfoImpl(this.catalog);
        Assert.assertNull((Object)this.helper.getCatalog().getResourcePool().getDataStoreFactory((DataStoreInfo)info));
        this.helper.getEncryptedFields((StoreInfo)info);
        Assert.assertTrue((boolean)ConfigurationPasswordEncryptionHelper.CACHE.isEmpty());
        Assert.assertTrue((boolean)ConfigurationPasswordEncryptionHelper.STORE_INFO_TYPE_CACHE.isEmpty());
    }

    @Test
    public void getEncryptedFieldsStoreInfoTypeCacheOnFactoryFound() throws IOException {
        DataStoreInfoImpl info = new DataStoreInfoImpl(this.catalog);
        Map params = info.getConnectionParameters();
        params.put(PostgisNGDataStoreFactory.DBTYPE.key, (String)PostgisNGDataStoreFactory.DBTYPE.getDefaultValue());
        info.setType(new PostgisNGDataStoreFactory().getDisplayName());
        MatcherAssert.assertThat((Object)this.helper.getCatalog().getResourcePool().getDataStoreFactory((DataStoreInfo)info), (Matcher)CoreMatchers.instanceOf(PostgisNGDataStoreFactory.class));
        this.helper.getEncryptedFields((StoreInfo)info);
        Set expected = (Set)ConfigurationPasswordEncryptionHelper.CACHE.get(PostgisNGDataStoreFactory.class);
        MatcherAssert.assertThat((Object)expected, (Matcher)CoreMatchers.equalTo(Set.of(JDBCDataStoreFactory.PASSWD.key)));
        Assert.assertEquals((Object)expected, ConfigurationPasswordEncryptionHelper.STORE_INFO_TYPE_CACHE.get(info.getType()));
    }

    @Test
    public void getEncryptedFieldsStoreInfoTypeCacheOnFactoryGet() throws IOException {
        DataStoreInfoImpl infoWithNoType = new DataStoreInfoImpl(this.catalog);
        Map params = infoWithNoType.getConnectionParameters();
        params.put(PostgisNGDataStoreFactory.DBTYPE.key, (String)PostgisNGDataStoreFactory.DBTYPE.getDefaultValue());
        params.put(JDBCDataStoreFactory.HOST.key, "localhost");
        params.put(JDBCDataStoreFactory.DATABASE.key, "test");
        params.put(PostgisNGDataStoreFactory.PORT.key, 54329);
        params.put(JDBCDataStoreFactory.USER.key, "geo");
        params.put(JDBCDataStoreFactory.PASSWD.key, "123");
        MatcherAssert.assertThat((Object)this.helper.getCatalog().getResourcePool().getDataStoreFactory((DataStoreInfo)infoWithNoType), (Matcher)CoreMatchers.instanceOf(PostgisNGDataStoreFactory.class));
        DataStoreInfoImpl infoWithType = new DataStoreInfoImpl(this.catalog);
        infoWithType.getConnectionParameters().putAll(infoWithNoType.getConnectionParameters());
        infoWithType.setType(new PostgisNGDataStoreFactory().getDisplayName());
        this.helper.getEncryptedFields((StoreInfo)infoWithNoType);
        Assert.assertNotNull(ConfigurationPasswordEncryptionHelper.CACHE.get(PostgisNGDataStoreFactory.class));
        Assert.assertTrue((String)"infoWithNoType can't get a hit on the info type cache", (boolean)ConfigurationPasswordEncryptionHelper.STORE_INFO_TYPE_CACHE.isEmpty());
        this.helper.getEncryptedFields((StoreInfo)infoWithType);
        Set<String> expected = Set.of(JDBCDataStoreFactory.PASSWD.key);
        Assert.assertEquals(expected, ConfigurationPasswordEncryptionHelper.STORE_INFO_TYPE_CACHE.get(infoWithType.getType()));
    }

    @Test
    public void testDecodeWontCallSecurityManagerLoadPasswordEncodersIfNotNeeded() {
        DataStoreInfoImpl info = new DataStoreInfoImpl(this.catalog);
        Map params = info.getConnectionParameters();
        params.put(ShapefileDataStoreFactory.FILE_TYPE.key, (String)ShapefileDataStoreFactory.FILE_TYPE.getDefaultValue());
        info.setType(new ShapefileDataStoreFactory().getDisplayName());
        Assert.assertTrue((boolean)this.helper.getEncryptedFields((StoreInfo)info).isEmpty());
        this.helper.decode((StoreInfo)info);
        ((GeoServerSecurityManager)Mockito.verify((Object)this.mockSecurityManager, (VerificationMode)Mockito.never())).loadPasswordEncoders((Class)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any());
        params.put(PostgisNGDataStoreFactory.DBTYPE.key, (String)PostgisNGDataStoreFactory.DBTYPE.getDefaultValue());
        params.put(JDBCDataStoreFactory.HOST.key, "localhost");
        params.put(JDBCDataStoreFactory.DATABASE.key, "test");
        params.put(PostgisNGDataStoreFactory.PORT.key, 54329);
        params.put(JDBCDataStoreFactory.USER.key, "geo");
        params.put(JDBCDataStoreFactory.PASSWD.key, "123");
        info.setType(new PostgisNGDataStoreFactory().getDisplayName());
        Mockito.when((Object)this.mockSecurityManager.loadPasswordEncoders((Class)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any())).thenReturn(List.of());
        this.helper.decode((StoreInfo)info);
        ((GeoServerSecurityManager)Mockito.verify((Object)this.mockSecurityManager, (VerificationMode)Mockito.times((int)1))).loadPasswordEncoders((Class)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any());
    }
}

