/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.urlchecks;

import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.urlchecks.AbstractURLCheck;
import org.geoserver.security.urlchecks.GeoServerURLChecker;
import org.geoserver.security.urlchecks.RegexURLCheck;
import org.geoserver.security.urlchecks.URLCheckDAO;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.data.ows.URLCheckerException;
import org.geotools.data.ows.URLCheckers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class URLChecksIntegrationTest
extends GeoServerSystemTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Before
    public void cleanup() throws Exception {
        Resource config = this.getConfigurationFile();
        config.delete();
        URLChecksIntegrationTest.getDao().reset();
    }

    private Resource getConfigurationFile() {
        return this.getDataDirectory().getSecurity(new String[]{"urlchecks.xml"});
    }

    @Test
    public void testOnEmpty() throws Exception {
        URLCheckDAO dao = URLChecksIntegrationTest.getDao();
        Assert.assertNotNull((Object)dao.getChecks());
        MatcherAssert.assertThat((Object)dao.getChecks(), (Matcher)Matchers.empty());
    }

    private static URLCheckDAO getDao() {
        return (URLCheckDAO)applicationContext.getBean(URLCheckDAO.class);
    }

    @Test
    public void testDaoSaveRules() throws Exception {
        Document dom;
        List<AbstractURLCheck> checks = URLChecksIntegrationTest.getSampleChecks(false);
        URLCheckDAO dao = URLChecksIntegrationTest.getDao();
        dao.saveChecks(checks);
        try (InputStream is = this.getConfigurationFile().in();){
            dom = this.dom(is, true);
        }
        for (int i = 0; i < 3; ++i) {
            String path = "/checks/regex[" + (i + 1) + "]/";
            RegexURLCheck check = (RegexURLCheck)checks.get(i);
            MatcherAssert.assertThat((Object)dom, (Matcher)Matchers.hasXPath((String)(path + "name"), (Matcher)Matchers.equalTo((Object)check.getName())));
            if (check.getDescription() != null) {
                MatcherAssert.assertThat((Object)dom, (Matcher)Matchers.hasXPath((String)(path + "description"), (Matcher)Matchers.equalTo((Object)check.getDescription())));
            } else {
                MatcherAssert.assertThat((Object)dom, (Matcher)Matchers.not((Matcher)Matchers.hasXPath((String)(path + "description"))));
            }
            MatcherAssert.assertThat((Object)dom, (Matcher)Matchers.hasXPath((String)(path + "regex"), (Matcher)Matchers.equalTo((Object)check.getRegex())));
            MatcherAssert.assertThat((Object)dom, (Matcher)Matchers.hasXPath((String)(path + "enabled"), (Matcher)Matchers.equalTo((Object)String.valueOf(check.isEnabled()))));
        }
    }

    @Test
    public void testDaoReadRules() throws Exception {
        this.writeSampleRulesXML(false);
        URLCheckDAO dao = URLChecksIntegrationTest.getDao();
        List checks = dao.getChecks();
        Assert.assertEquals(URLChecksIntegrationTest.getSampleChecks(false), (Object)checks);
    }

    @Test
    public void testCheckers() throws Exception {
        this.writeSampleRulesXML(false);
        Assert.assertNotNull((Object)applicationContext.getBean(GeoServerURLChecker.class));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"http://google.com"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"http://nyt.com"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"file:///tmp"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"file:///data/test.tif"));
        URLCheckers.confirm((String)"https://www.geoserver.org/logo.png");
        URLCheckers.confirm((String)"http://www.geotools.org/sld.xsd");
        this.writeSampleRulesXML(true);
        URLChecksIntegrationTest.getDao().reset();
        URLCheckers.confirm((String)"file:///data/test.tif");
    }

    private void writeSampleRulesXML(boolean dataEnabled) {
        Resource config = this.getConfigurationFile();
        try (PrintStream os = new PrintStream(config.out(), true, StandardCharsets.UTF_8);){
            os.println("<checks><regex><name>geoserver</name><description>Allows access to geoserver.org</description><regex>https?://.*geoserver.org/.*</regex><enabled>true</enabled></regex><regex><name>geotools</name><regex>https?://.*geotools.org/.*</regex><enabled>true</enabled></regex><regex><name>data</name><description>Allows access to the data folder</description><regex>file:///data/.*\\.tif</regex><enabled>" + dataEnabled + "</enabled></regex></checks>");
        }
    }

    private static List<AbstractURLCheck> getSampleChecks(boolean dataEnabled) {
        ArrayList<AbstractURLCheck> checks = new ArrayList<AbstractURLCheck>();
        RegexURLCheck gsCheck = new RegexURLCheck("geoserver", "Allows access to geoserver.org", "https?://.*geoserver.org/.*");
        checks.add((AbstractURLCheck)gsCheck);
        RegexURLCheck gtCheck = new RegexURLCheck("geotools", null, "https?://.*geotools.org/.*");
        checks.add((AbstractURLCheck)gtCheck);
        RegexURLCheck fileCheck = new RegexURLCheck("data", "Allows access to the data folder", "file:///data/.*\\.tif");
        fileCheck.setEnabled(dataEnabled);
        checks.add((AbstractURLCheck)fileCheck);
        return checks;
    }
}

