/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.File;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DirectoryResourceLoader
extends DefaultResourceLoader {
    File root;

    public DirectoryResourceLoader(File root) {
        this.root = root;
    }

    protected Resource getResourceByPath(String path) {
        return new FileSystemContextResource(this.root, path);
    }

    private class FileSystemContextResource
    extends FileSystemResource
    implements ContextResource {
        public FileSystemContextResource(File root, String path) {
            super(new File(root, path).getAbsolutePath());
        }

        public String getPathWithinContext() {
            return this.getPath();
        }
    }
}

