/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.servlet.Filter;
import javax.servlet.ReadListener;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONSerializer;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.GeoserverInitStartupListener;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.TestHttpClientProvider;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerLoaderProxy;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.logging.LoggingUtils;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ContextLoadedEvent;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.ModuleStatus;
import org.geoserver.platform.ServiceException;
import org.geoserver.security.AccessMode;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.auth.AuthenticationCache;
import org.geoserver.security.auth.TestingAuthenticationCache;
import org.geoserver.security.impl.AbstractGeoServerSecurityService;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.password.GeoServerDigestPasswordEncoder;
import org.geoserver.security.password.GeoServerPBEPasswordEncoder;
import org.geoserver.security.password.GeoServerPlainTextPasswordEncoder;
import org.geoserver.test.CodeExpectingHttpServletResponse;
import org.geoserver.test.DirectoryResourceLoader;
import org.geoserver.test.GeoServerAbstractTestSupport;
import org.geoserver.test.GeoServerBaseTestSupport;
import org.geoserver.test.GeoServerTestApplicationContext;
import org.geoserver.test.TestSetup;
import org.geoserver.test.TestSetupFrequency;
import org.geoserver.util.EntityResolverProvider;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.type.Name;
import org.geotools.data.DataUtilities;
import org.geotools.feature.NameImpl;
import org.geotools.util.PreventLocalEntityResolver;
import org.geotools.util.logging.Log4J2LoggerFactory;
import org.geotools.util.logging.LoggerFactory;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.XSD;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.locationtech.jts.geom.Coordinate;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.mock.web.MockServletContext;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerInterceptor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@TestSetup(run=TestSetupFrequency.ONCE)
public class GeoServerSystemTestSupport
extends GeoServerBaseTestSupport<SystemTestData> {
    private MockHttpServletResponse lastResponse;
    protected static GeoServerTestApplicationContext applicationContext;
    protected String username;
    protected String password;
    protected static DispatcherServlet dispatcher;
    public static final EntityResolver RESOLVE_DISABLED_PROVIDER_DEVMODE;

    @Before
    public void clearLastResponse() {
        this.lastResponse = null;
    }

    @Override
    protected SystemTestData createTestData() throws Exception {
        return new SystemTestData();
    }

    @Override
    protected final void setUp(SystemTestData testData) throws Exception {
        try {
            Class.forName("com.sun.org.apache.xml.internal.dtm.ref.DTMManagerDefault");
            System.setProperty("com.sun.org.apache.xml.internal.dtm.DTMManager", "com.sun.org.apache.xml.internal.dtm.ref.DTMManagerDefault");
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setSecurityManager(null);
        try {
            Logging.ALL.setLoggerFactory((LoggerFactory)Log4J2LoggerFactory.getInstance());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not configure log4j2 logging redirection", e);
        }
        System.setProperty("RELINQUISH_LOG4J_CONTROL", "true");
        Logging.ALL.setLoggerFactory("org.geotools.util.logging.Log4J2LoggerFactory");
        GeoServerResourceLoader loader = new GeoServerResourceLoader(testData.getDataDirectoryRoot());
        LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)this.getLogConfiguration(), (boolean)false, (boolean)true, null);
        this.setUpTestData(testData);
        TestHttpClientProvider.startTest();
        if (testData.isTestDataAvailable()) {
            DefaultResourceLoader rl;
            if (testData.getDataDirectoryRoot().canWrite()) {
                File webinf = new File(testData.getDataDirectoryRoot(), "WEB-INF");
                webinf.mkdir();
                rl = new DirectoryResourceLoader(testData.getDataDirectoryRoot());
            } else {
                rl = new DefaultResourceLoader();
            }
            MockServletContext servletContext = new MockServletContext((ResourceLoader)rl);
            servletContext.setMinorVersion(4);
            servletContext.setInitParameter("GEOSERVER_DATA_DIR", testData.getDataDirectoryRoot().getPath());
            servletContext.setInitParameter("serviceStrategy", "PARTIAL-BUFFER2");
            ArrayList<String> contexts = new ArrayList<String>();
            this.setUpSpring(contexts);
            applicationContext = new GeoServerTestApplicationContext(contexts.toArray(new String[contexts.size()]), (ServletContext)servletContext);
            applicationContext.setUseLegacyGeoServerLoader(false);
            applicationContext.refresh();
            applicationContext.publishEvent((ApplicationEvent)new ContextLoadedEvent((ApplicationContext)applicationContext));
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)applicationContext);
            dispatcher = this.buildDispatcher();
            EntityResolverProvider.setEntityResolver((EntityResolver)RESOLVE_DISABLED_PROVIDER_DEVMODE);
            GeoserverInitStartupListener.initJAIDefaultInstance();
            this.getSecurityManager().setAuthenticationCache((AuthenticationCache)new TestingAuthenticationCache());
            this.onSetUp(testData);
        }
    }

    @Override
    protected final void tearDown(SystemTestData testData) throws Exception {
        if (testData.isTestDataAvailable()) {
            this.onTearDown(testData);
            this.destroyGeoServer();
            TestHttpClientProvider.endTest();
            if (this.isMemoryCleanRequired()) {
                System.gc();
                System.runFinalization();
            }
        }
    }

    protected void destroyGeoServer() {
        if (applicationContext == null) {
            return;
        }
        try {
            GeoServerSystemTestSupport.disposeIfExists(this.getXSD11());
            GeoServerSystemTestSupport.disposeIfExists(this.getXSD10());
            applicationContext.close();
            GeoServerExtensionsHelper.init(null);
        }
        finally {
            applicationContext = null;
        }
    }

    @After
    public void doLogout() {
        this.logout();
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpDefault();
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
    }

    protected void onTearDown(SystemTestData testData) throws Exception {
    }

    protected void setUpSpring(List<String> springContextLocations) {
        springContextLocations.add("classpath*:/applicationContext.xml");
        springContextLocations.add("classpath*:/applicationSecurityContext.xml");
    }

    protected String getLogConfiguration() {
        if (GeoServerSystemTestSupport.isQuietTests()) {
            return "QUIET_LOGGING";
        }
        return "TEST_LOGGING";
    }

    protected boolean isMemoryCleanRequired() {
        return false;
    }

    protected Catalog getCatalog() {
        return (Catalog)applicationContext.getBean("catalog");
    }

    protected GeoServer getGeoServer() {
        return (GeoServer)applicationContext.getBean("geoServer");
    }

    protected GeoServerSecurityManager getSecurityManager() {
        return (GeoServerSecurityManager)applicationContext.getBean("geoServerSecurityManager");
    }

    protected GeoServerPlainTextPasswordEncoder getPlainTextPasswordEncoder() {
        return (GeoServerPlainTextPasswordEncoder)this.getSecurityManager().loadPasswordEncoder(GeoServerPlainTextPasswordEncoder.class);
    }

    protected GeoServerDigestPasswordEncoder getDigestPasswordEncoder() {
        return (GeoServerDigestPasswordEncoder)this.getSecurityManager().loadPasswordEncoder(GeoServerDigestPasswordEncoder.class);
    }

    protected GeoServerPBEPasswordEncoder getPBEPasswordEncoder() {
        return (GeoServerPBEPasswordEncoder)this.getSecurityManager().loadPasswordEncoder(GeoServerPBEPasswordEncoder.class, null, Boolean.valueOf(false));
    }

    protected GeoServerPBEPasswordEncoder getStrongPBEPasswordEncoder() {
        return (GeoServerPBEPasswordEncoder)this.getSecurityManager().loadPasswordEncoder(GeoServerPBEPasswordEncoder.class, null, Boolean.valueOf(true));
    }

    protected GeoServerResourceLoader getResourceLoader() {
        return (GeoServerResourceLoader)applicationContext.getBean("resourceLoader");
    }

    protected XSD getXSD11() {
        if (applicationContext.containsBean("wfsXsd-1.1")) {
            return (XSD)applicationContext.getBean("wfsXsd-1.1");
        }
        return null;
    }

    protected XSD getXSD10() {
        if (applicationContext.containsBean("wfsXsd-1.0")) {
            return (XSD)applicationContext.getBean("wfsXsd-1.0");
        }
        return null;
    }

    protected static void disposeIfExists(XSD xsd) {
        if (xsd != null) {
            xsd.dispose();
        }
    }

    protected static void assertContentType(String contentType, MockHttpServletResponse response) {
        String actual = response.getHeader("Content-Type");
        Assert.assertNotNull((Object)actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.startsWith((String)contentType));
    }

    protected GeoServerDataDirectory getDataDirectory() {
        return new GeoServerDataDirectory(this.getResourceLoader());
    }

    protected SimpleFeatureSource getFeatureSource(QName typeName) throws IOException {
        FeatureTypeInfo ft = this.getFeatureTypeInfo(typeName);
        return DataUtilities.simple((FeatureSource)ft.getFeatureSource(null, null));
    }

    protected FeatureTypeInfo getFeatureTypeInfo(QName typename) {
        return this.getCatalog().getFeatureTypeByName(typename.getNamespaceURI(), typename.getLocalPart());
    }

    protected FeatureTypeInfo getFeatureTypeInfo(String typename) {
        return this.getFeatureTypeInfo(this.resolveLayerName(typename));
    }

    public String getLayerId(QName layerName) {
        return this.toString(layerName);
    }

    protected void removeWorkspace(String name) {
        Catalog cat = this.getCatalog();
        WorkspaceInfo ws = cat.getWorkspaceByName(name);
        if (ws != null) {
            new CascadeDeleteVisitor(cat).visit(ws);
        }
    }

    protected void removeNamespace(String prefix) {
        Catalog cat = this.getCatalog();
        NamespaceInfo ns = cat.getNamespaceByPrefix(prefix);
        if (ns != null) {
            cat.remove(ns);
        }
    }

    protected void removeStore(String workspaceName, String name) {
        Catalog cat = this.getCatalog();
        StoreInfo store = cat.getStoreByName(workspaceName, name, StoreInfo.class);
        if (store == null) {
            return;
        }
        CascadeDeleteVisitor v = new CascadeDeleteVisitor(this.getCatalog());
        store.accept((CatalogVisitor)v);
    }

    protected void removeLayer(String workspaceName, String name) {
        Catalog cat = this.getCatalog();
        ResourceInfo resource = cat.getResourceByName(workspaceName, name, ResourceInfo.class);
        if (resource == null) {
            return;
        }
        CascadeDeleteVisitor v = new CascadeDeleteVisitor(this.getCatalog());
        for (LayerInfo layer : cat.getLayers()) {
            if (!resource.equals(layer.getResource())) continue;
            layer.accept((CatalogVisitor)v);
        }
    }

    protected void removeStyle(String workspaceName, String name) throws IOException {
        StyleInfo s;
        Catalog cat = this.getCatalog();
        StyleInfo styleInfo = s = workspaceName != null ? cat.getStyleByName(workspaceName, name) : cat.getStyleByName(name);
        if (s != null) {
            cat.remove(s);
            cat.getResourcePool().deleteStyle(s, true);
        } else {
            File sld;
            File file = sld = workspaceName != null ? cat.getResourceLoader().find(new String[]{"workspaces", workspaceName, "styles", name + ".sld"}) : cat.getResourceLoader().find(new String[]{"styles", name + ".sld"});
            if (sld != null) {
                sld.delete();
            }
        }
    }

    protected void removeLayerGroup(String workspaceName, String name) {
        LayerGroupInfo lg;
        Catalog cat = this.getCatalog();
        LayerGroupInfo layerGroupInfo = lg = workspaceName != null ? cat.getLayerGroupByName(workspaceName, name) : cat.getLayerGroupByName(name);
        if (lg != null) {
            cat.remove(lg);
        }
    }

    protected void revertLayer(String workspace, String name) throws IOException {
        this.revertLayer(new QName(workspace, name));
    }

    protected void revertLayer(QName qName) throws IOException {
        ((SystemTestData)this.getTestData()).addVectorLayer(qName, this.getCatalog());
    }

    protected void revertService(Class<? extends ServiceInfo> serviceClass, String workspace) {
        ((SystemTestData)this.getTestData()).addService(serviceClass, workspace, this.getGeoServer());
    }

    protected void revertSettings(String workspace) {
        ((SystemTestData)this.getTestData()).addSettings(workspace, this.getGeoServer());
    }

    protected void setRequestAuth(String username, String password) {
        this.username = username;
        this.password = password;
    }

    protected Authentication loginAsAdmin() {
        return this.login("admin", "geoserver", AbstractGeoServerSecurityService.DEFAULT_LOCAL_ADMIN_ROLE, GeoServerRole.ADMIN_ROLE.getAuthority());
    }

    protected Authentication login(String username, String password, String ... roles) {
        SecurityContextHolder.setContext((SecurityContext)new SecurityContextImpl());
        ArrayList<SimpleGrantedAuthority> l = new ArrayList<SimpleGrantedAuthority>();
        for (String role : roles) {
            l.add(new SimpleGrantedAuthority(role));
        }
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)username, (Object)password, l);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        return authentication;
    }

    protected void addUser(String username, String password, List<String> groups, List<String> roles) throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        GeoServerUserGroupService ugService = secMgr.loadUserGroupService("default");
        GeoServerUserGroupStore ugStore = ugService.createStore();
        GeoServerUser user = ugStore.createUserObject(username, password, true);
        ugStore.addUser(user);
        if (groups != null && !groups.isEmpty()) {
            for (String groupName : groups) {
                GeoServerUserGroup group = ugStore.getGroupByGroupname(groupName);
                if (group == null) {
                    group = ugStore.createGroupObject(groupName, true);
                    ugStore.addGroup(group);
                }
                ugStore.associateUserToGroup(user, group);
            }
        }
        ugStore.store();
        if (roles != null && !roles.isEmpty()) {
            GeoServerRoleService roleService = secMgr.getActiveRoleService();
            GeoServerRoleStore roleStore = roleService.createStore();
            for (String roleName : roles) {
                GeoServerRole role = roleStore.getRoleByName(roleName);
                if (role == null) {
                    role = roleStore.createRoleObject(roleName);
                    roleStore.addRole(role);
                }
                roleStore.associateRoleToUser(role, username);
            }
            roleStore.store();
        }
    }

    protected void addLayerAccessRule(String workspace, String layer, AccessMode mode, String ... roles) throws IOException {
        DataAccessRuleDAO dao = DataAccessRuleDAO.get();
        DataAccessRule rule = new DataAccessRule();
        rule.setRoot(workspace);
        rule.setLayer(layer);
        rule.setGlobalGroupRule(layer == null);
        rule.setAccessMode(mode);
        rule.getRoles().addAll(Arrays.asList(roles));
        dao.addRule((Comparable)rule);
        dao.storeRules();
    }

    protected void logout() {
        SecurityContextHolder.clearContext();
    }

    protected MockHttpServletRequest createRequest(String path) {
        return this.createRequest(path, false);
    }

    protected MockHttpServletRequest createRequest(String path, boolean createSession) {
        GeoServerMockHttpServletRequest request = new GeoServerMockHttpServletRequest();
        request.setMethod("GET");
        request.setScheme("http");
        request.setServerName("localhost");
        request.setServerPort(8080);
        request.setContextPath("/geoserver");
        request.setRequestURI(ResponseUtils.stripQueryString((String)ResponseUtils.appendPath((String[])new String[]{"/geoserver/", path})));
        request.setQueryString(ResponseUtils.getQueryString((String)path));
        request.setRemoteAddr("127.0.0.1");
        request.setServletPath(ResponseUtils.makePathAbsolute((String)ResponseUtils.stripRemainingPath((String)path)));
        request.setPathInfo(ResponseUtils.makePathAbsolute((String)ResponseUtils.stripBeginningPath((String)ResponseUtils.stripQueryString((String)path))));
        if (request.getPathInfo().equals("/")) {
            request.setPathInfo(request.getServletPath());
            request.setServletPath("");
        }
        request.addHeader("Host", "localhost:8080");
        if (this.username != null) {
            String token = this.username + ":";
            if (this.password != null) {
                token = token + this.password;
            }
            request.addHeader("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])token.getBytes())));
        }
        this.kvp(request, path);
        if (createSession) {
            MockHttpSession session = new MockHttpSession((ServletContext)new MockServletContext());
            request.setSession((HttpSession)session);
        }
        request.setUserPrincipal(null);
        return request;
    }

    protected MockHttpServletRequest createRequest(String path, Map kvp) {
        StringBuffer q = new StringBuffer();
        Iterator iterator = kvp.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            q.append(entry.getKey()).append("=").append(entry.getValue());
            q.append("&");
        }
        q.setLength(q.length() - 1);
        return this.createRequest(ResponseUtils.appendQueryString((String)path, (String)q.toString()));
    }

    protected InputStream get(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        return new ByteArrayInputStream(response.getContentAsString().getBytes());
    }

    protected InputStream get(String path, String charset) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path, charset);
        return new ByteArrayInputStream(response.getContentAsString().getBytes());
    }

    protected InputStream get(String path, int responseCode) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        int status = response.getStatus();
        if (responseCode != status) {
            String content = response.getContentAsString();
            if (content == null || content.isEmpty()) {
                throw new ServiceException("expected status <" + responseCode + "> but was <" + status + ">");
            }
            throw new ServiceException("expected status <" + responseCode + "> but was <" + status + ">:" + content);
        }
        return new ByteArrayInputStream(response.getContentAsString().getBytes());
    }

    protected MockHttpServletResponse getAsServletResponse(String path) throws Exception {
        return this.getAsServletResponse(path, null);
    }

    protected MockHttpServletResponse getAsServletResponse(String path, String charset) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("GET");
        request.setContent(new byte[0]);
        return this.dispatch((HttpServletRequest)request, charset);
    }

    protected InputStream post(String path) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("POST");
        request.setContentType("application/x-www-form-urlencoded");
        request.setContent(new byte[0]);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        return new ByteArrayInputStream(response.getContentAsString().getBytes());
    }

    protected InputStream put(String path) throws Exception {
        return this.put(path, "");
    }

    protected InputStream put(String path, String body) throws Exception {
        return this.put(path, body, "text/plain");
    }

    protected InputStream put(String path, String body, String contentType) throws Exception {
        return this.put(path, body.getBytes(), contentType);
    }

    protected InputStream put(String path, byte[] body, String contentType) throws Exception {
        MockHttpServletResponse response = this.putAsServletResponse(path, body, contentType);
        return new ByteArrayInputStream(response.getContentAsString().getBytes());
    }

    protected MockHttpServletResponse putAsServletResponse(String path) throws Exception {
        return this.putAsServletResponse(path, new byte[0], "text/plain");
    }

    protected MockHttpServletResponse putAsServletResponse(String path, String body, String contentType) throws Exception {
        return this.putAsServletResponse(path, body != null ? body.getBytes() : null, contentType);
    }

    protected MockHttpServletResponse putAsServletResponse(String path, byte[] body, String contentType) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("PUT");
        request.setContentType(contentType);
        request.setContent(body);
        return this.dispatch((HttpServletRequest)request);
    }

    protected MockHttpServletResponse patchAsServletResponse(String path, String body, String contentType) throws Exception {
        return this.patchAsServletResponse(path, body != null ? body.getBytes() : null, contentType);
    }

    protected MockHttpServletResponse patchAsServletResponse(String path, byte[] body, String contentType) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("PATCH");
        request.setContentType(contentType);
        request.setContent(body);
        return this.dispatch((HttpServletRequest)request);
    }

    protected InputStream post(String path, String xml) throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse(path, xml);
        return new ByteArrayInputStream(response.getContentAsString().getBytes());
    }

    protected MockHttpServletResponse postAsServletResponse(String path, String xml) throws Exception {
        return this.postAsServletResponse(path, xml, "application/xml");
    }

    protected ByteArrayInputStream getBinaryInputStream(MockHttpServletResponse response) {
        return new ByteArrayInputStream(this.getBinary(response));
    }

    protected byte[] getBinary(MockHttpServletResponse response) {
        return response.getContentAsByteArray();
    }

    protected InputStream post(String path, String body, String contentType) throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse(path, body, contentType);
        return new ByteArrayInputStream(response.getContentAsString().getBytes());
    }

    protected MockHttpServletResponse postAsServletResponse(String path, String body, String contentType) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("POST");
        request.setContentType(contentType);
        request.setContent(body.getBytes(StandardCharsets.UTF_8));
        return this.dispatch((HttpServletRequest)request);
    }

    protected MockHttpServletResponse postAsServletResponse(String path, String body, String contentType, String charset) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("POST");
        request.setContentType(contentType);
        request.setContent(body.getBytes(StandardCharsets.UTF_8));
        return this.dispatch((HttpServletRequest)request, charset);
    }

    protected MockHttpServletResponse postAsServletResponse(String path, byte[] body, String contentType) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("POST");
        request.setContentType(contentType);
        request.setContent(body);
        return this.dispatch((HttpServletRequest)request);
    }

    protected MockHttpServletResponse deleteAsServletResponse(String path) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("DELETE");
        return this.dispatch((HttpServletRequest)request);
    }

    protected org.w3c.dom.Document getAsDOM(String path) throws Exception {
        return this.getAsDOM(path, true);
    }

    protected org.w3c.dom.Document getAsDOM(String path, int statusCode) throws Exception {
        try (InputStream responseContent = this.get(path, statusCode);){
            org.w3c.dom.Document document = this.dom(responseContent, true);
            return document;
        }
    }

    protected org.w3c.dom.Document getAsDOM(String path, String encoding) throws Exception {
        return this.getAsDOM(path, true, encoding);
    }

    protected JSON getAsJSON(String path, int statusCode) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path, statusCode);
        int status = response.getStatus();
        if (statusCode != status) {
            String content = response.getContentAsString();
            if (content == null || content.isEmpty()) {
                throw new ServiceException("expected status <" + statusCode + "> but was <" + status + ">");
            }
            throw new ServiceException("expected status <" + statusCode + "> but was <" + status + ">:" + content);
        }
        return this.json(response);
    }

    private MockHttpServletResponse getAsServletResponse(String path, int statusCode) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        int status = response.getStatus();
        if (statusCode != status) {
            String content = response.getContentAsString();
            if (content == null || content.isEmpty()) {
                throw new ServiceException("expected status <" + statusCode + "> but was <" + status + ">");
            }
            throw new ServiceException("expected status <" + statusCode + "> but was <" + status + ">:" + content);
        }
        return response;
    }

    protected JSON getAsJSON(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        return this.json(response);
    }

    protected JSON postAsJSON(String path, String body, String contentType) throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse(path, body, contentType);
        return this.json(response);
    }

    protected JSON putAsJSON(String path, String body, String contentType) throws Exception {
        MockHttpServletResponse response = this.putAsServletResponse(path, body, contentType);
        return this.json(response);
    }

    protected JSON json(MockHttpServletResponse response) throws UnsupportedEncodingException {
        String content = response.getContentAsString();
        try {
            return JSONSerializer.toJSON((Object)content);
        }
        catch (JSONException e) {
            LOGGER.log(Level.SEVERE, "Error parsing JSON response: " + content, e);
            throw e;
        }
    }

    protected BufferedImage getAsImage(String path, String mime) throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse(path);
        Assert.assertEquals((Object)mime, (Object)resp.getContentType());
        try (ByteArrayInputStream is = this.getBinaryInputStream(resp);){
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
    }

    protected List<BufferedImage> getAsAnimation(String path, String mime) throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse(path);
        Assert.assertEquals((Object)mime, (Object)resp.getContentType());
        try (ImageInputStream is = ImageIO.createImageInputStream(this.getBinaryInputStream(resp));){
            ImageReader reader = ImageIO.getImageReaders(is).next();
            reader.setInput(is);
            int numImages = reader.getNumImages(true);
            ArrayList<BufferedImage> result = new ArrayList<BufferedImage>(numImages);
            for (int i = 0; i < numImages; ++i) {
                result.add(reader.read(i));
            }
            ArrayList<BufferedImage> arrayList = result;
            return arrayList;
        }
    }

    protected org.w3c.dom.Document getAsDOM(String path, boolean skipDTD) throws Exception {
        try (InputStream responseContent = this.get(path);){
            org.w3c.dom.Document document = this.dom(responseContent, skipDTD);
            return document;
        }
    }

    protected org.w3c.dom.Document getAsDOM(String path, boolean skipDTD, String encoding) throws Exception {
        return this.dom(this.get(path, encoding), skipDTD, encoding);
    }

    protected org.w3c.dom.Document postAsDOM(String path) throws Exception {
        return this.postAsDOM(path, (List<Exception>)null);
    }

    protected org.w3c.dom.Document postAsDOM(String path, List<Exception> validationErrors) throws Exception {
        return this.dom(this.post(path));
    }

    protected org.w3c.dom.Document postAsDOM(String path, String xml) throws Exception {
        return this.postAsDOM(path, xml, null);
    }

    protected org.w3c.dom.Document postAsDOM(String path, String xml, int expectedStatusCode) throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse(path, xml);
        Assert.assertEquals((long)expectedStatusCode, (long)response.getStatus());
        return this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
    }

    protected org.w3c.dom.Document postAsDOM(String path, String xml, List<Exception> validationErrors) throws Exception {
        return this.dom(this.post(path, xml));
    }

    protected String getAsString(String path) throws Exception {
        return this.string(this.get(path));
    }

    protected String getAsString(String path, String encoding) throws Exception {
        return this.string(this.get(path, encoding));
    }

    protected org.w3c.dom.Document dom(MockHttpServletResponse response, boolean skipSchemaValidation) {
        org.w3c.dom.Document document;
        ByteArrayInputStream input = new ByteArrayInputStream(response.getContentAsString().getBytes());
        try {
            document = this.dom(input, skipSchemaValidation);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new RuntimeException("Something bad happen when parsing response XML content.", exception);
            }
        }
        ((InputStream)input).close();
        return document;
    }

    protected org.w3c.dom.Document dom(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        return this.dom(is, true);
    }

    protected org.w3c.dom.Document dom(InputStream input, boolean skipDTD) throws ParserConfigurationException, SAXException, IOException {
        return this.dom(input, skipDTD, null);
    }

    protected org.w3c.dom.Document dom(InputStream stream, boolean skipDTD, String encoding) throws ParserConfigurationException, SAXException, IOException {
        InputSource input = new InputSource(stream);
        if (encoding != null) {
            input.setEncoding(encoding);
        } else {
            input.setEncoding(Charset.defaultCharset().name());
        }
        if (skipDTD) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EmptyResolver());
            org.w3c.dom.Document dom = builder.parse(input);
            return dom;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(input);
    }

    protected MockHttpServletResponse dispatch(HttpServletRequest request) throws Exception {
        return this.dispatch(request, (String)null);
    }

    protected MockHttpServletResponse dispatch(HttpServletRequest request, String charset) throws Exception {
        MockHttpServletResponse response = new MockHttpServletResponse();
        if (charset != null) {
            response.setCharacterEncoding(charset);
        }
        this.dispatch(request, (HttpServletResponse)response);
        this.lastResponse = response;
        return response;
    }

    protected String getBaseMimeType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        HeaderElement headerElement = BasicHeaderValueParser.parseHeaderElement((String)mimeType, null);
        return headerElement.getName();
    }

    protected MockHttpServletResponse getLastResponse() {
        return this.lastResponse;
    }

    protected DispatcherServlet getDispatcher() throws Exception {
        return dispatcher;
    }

    protected DispatcherServlet buildDispatcher() throws ServletException {
        ServletContext context = applicationContext.getServletContext();
        MockServletConfig config = new MockServletConfig(context, "dispatcher");
        DispatcherServlet dispatcher = new DispatcherServlet((WebApplicationContext)applicationContext);
        dispatcher.setContextConfigLocation(GeoServerAbstractTestSupport.class.getResource("dispatcher-servlet.xml").toString());
        dispatcher.init((ServletConfig)config);
        return dispatcher;
    }

    private void dispatch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        final DispatcherServlet dispatcher = this.getDispatcher();
        HttpServlet servlet = new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                try {
                    HandlerInterceptor interceptor;
                    List interceptors = GeoServerExtensions.extensions(HandlerInterceptor.class, (ApplicationContext)applicationContext);
                    for (Object value : interceptors) {
                        interceptor = (HandlerInterceptor)value;
                        interceptor.preHandle(request, response, (Object)dispatcher);
                    }
                    dispatcher.service((ServletRequest)request, (ServletResponse)response);
                    for (Object o : interceptors) {
                        interceptor = (HandlerInterceptor)o;
                        interceptor.postHandle(request, response, (Object)dispatcher, null);
                    }
                }
                catch (IOException | RuntimeException | ServletException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw (IOException)new IOException("Failed to handle the request").initCause(e);
                }
            }
        };
        List<Filter> filterList = this.getFilters();
        MockFilterChain chain = filterList != null ? new MockFilterChain((Servlet)servlet, filterList.toArray(new Filter[filterList.size()])) : new MockFilterChain((Servlet)servlet);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void kvp(MockHttpServletRequest request, String path) {
        Map params = KvpUtils.parseQueryString((String)path);
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof String) {
                request.addParameter(key, (String)value);
                continue;
            }
            String[] values = (String[])value;
            request.addParameter(key, values);
        }
    }

    protected void assertStatusCodeForGet(int code, String path) throws Exception {
        this.assertStatusCodeForRequest(code, "GET", path, "", "");
    }

    protected void assertStatusCodeForPost(int code, String path, String body, String type) throws Exception {
        this.assertStatusCodeForRequest(code, "POST", path, body, type);
    }

    protected void assertStatusCodeForPut(int code, String path, String body, String type) throws Exception {
        this.assertStatusCodeForRequest(code, "PUT", path, body, type);
    }

    protected void assertStatusCodeForRequest(int code, String method, String path, String body, String type) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod(method);
        request.setContent(body.getBytes(StandardCharsets.UTF_8));
        request.setContentType(type);
        CodeExpectingHttpServletResponse response = new CodeExpectingHttpServletResponse((HttpServletResponse)new MockHttpServletResponse());
        this.dispatch((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)code, (long)response.getErrorCode());
    }

    protected Color getPixelColor(BufferedImage image, int i, int j) {
        ColorModel cm = image.getColorModel();
        WritableRaster raster = image.getRaster();
        Object pixel = raster.getDataElements(i, j, null);
        Color actual = cm.hasAlpha() ? new Color(cm.getRed(pixel), cm.getGreen(pixel), cm.getBlue(pixel), cm.getAlpha(pixel)) : new Color(cm.getRed(pixel), cm.getGreen(pixel), cm.getBlue(pixel), 255);
        return actual;
    }

    protected void assertPixel(BufferedImage image, int i, int j, Color color) {
        Color actual = this.getPixelColor(image, i, j);
        Assert.assertEquals((Object)color, (Object)actual);
    }

    protected void assertPixelIsTransparent(BufferedImage image, int i, int j) {
        int pixel = image.getRGB(i, j);
        Assert.assertEquals((long)0L, (long)(pixel >> 24));
    }

    protected void setupVectorDimension(String featureTypeName, String dimensionName, String attribute, DimensionPresentation presentation, Double resolution, String units, String unitSymbol) {
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(featureTypeName);
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setAttribute(attribute);
        di.setPresentation(presentation);
        if (resolution != null) {
            di.setResolution(BigDecimal.valueOf(resolution));
        }
        di.setUnits(units);
        di.setUnitSymbol(unitSymbol);
        info.getMetadata().put(dimensionName, (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    protected void setupRasterDimension(QName layer, String dimensionName, DimensionPresentation presentation, Double resolution, String units, String unitSymbol) {
        this.setupRasterDimension(layer, dimensionName, presentation, resolution, units, unitSymbol, false, null);
    }

    protected void setupRasterDimension(QName layer, String dimensionName, DimensionPresentation presentation, Double resolution, String units, String unitSymbol, boolean nearestMatch, String acceptableInterval) {
        CoverageInfo info = this.getCatalog().getCoverageByName(layer.getLocalPart());
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setPresentation(presentation);
        if (resolution != null) {
            di.setResolution(BigDecimal.valueOf(resolution));
        }
        di.setUnits(units);
        di.setUnitSymbol(unitSymbol);
        di.setNearestMatchEnabled(nearestMatch);
        if (acceptableInterval != null) {
            di.setAcceptableInterval(acceptableInterval);
        }
        info.getMetadata().put(dimensionName, (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    protected void setupNearestMatch(QName layer, String dimensionName, boolean nearestMatch) {
        this.setupNearestMatch(layer, dimensionName, nearestMatch, null);
    }

    protected void setupNearestMatch(QName layer, String dimensionName, boolean nearestMatch, String acceptableInterval) {
        this.setupNearestMatch(layer, dimensionName, nearestMatch, acceptableInterval, false);
    }

    protected void setupNearestMatch(QName layer, String dimensionName, boolean nearestMatch, String acceptableInterval, boolean rawNearestMatch) {
        this.setupNearestMatch(layer, dimensionName, nearestMatch, acceptableInterval, DimensionInfo.NearestFailBehavior.IGNORE, rawNearestMatch);
    }

    protected void setupNearestMatch(QName layer, String dimensionName, boolean nearestMatch, String acceptableInterval, DimensionInfo.NearestFailBehavior nearestFailBehavior, boolean rawNearestMatch) {
        ResourceInfo info = this.getCatalog().getResourceByName(this.getLayerId(layer), ResourceInfo.class);
        DimensionInfo di = (DimensionInfo)info.getMetadata().get(dimensionName, DimensionInfo.class);
        di.setNearestMatchEnabled(nearestMatch);
        di.setAcceptableInterval(acceptableInterval);
        di.setRawNearestMatchEnabled(rawNearestMatch);
        di.setNearestFailBehavior(nearestFailBehavior);
        this.getCatalog().save(info);
    }

    protected void setupVectorStartAndEndValues(QName layer, String dimensionName, String startValue, String endValue) {
        ResourceInfo info = this.getCatalog().getResourceByName(this.getLayerId(layer), ResourceInfo.class);
        DimensionInfo di = (DimensionInfo)info.getMetadata().get(dimensionName, DimensionInfo.class);
        di.setStartValue(startValue);
        di.setEndValue(endValue);
        this.getCatalog().save(info);
    }

    protected void setupRasterStartAndEndValues(QName layer, String dimensionName, String startValue, String endValue) {
        CoverageInfo info = this.getCatalog().getCoverageByName(layer.getLocalPart());
        DimensionInfo di = (DimensionInfo)info.getMetadata().get(dimensionName, DimensionInfo.class);
        di.setStartValue(startValue);
        di.setEndValue(endValue);
        this.getCatalog().save((ResourceInfo)info);
    }

    protected void assertNotBlank(String testName, BufferedImage image, Color bgColor) {
        int pixelsDiffer = this.countNonBlankPixels(testName, image, bgColor);
        Assert.assertTrue((String)(testName + " image is comlpetely blank"), (0 < pixelsDiffer ? 1 : 0) != 0);
    }

    protected void assertBlank(String testName, BufferedImage image, Color bgColor) {
        int pixelsDiffer = this.countNonBlankPixels(testName, image, bgColor);
        Assert.assertEquals((String)(testName + " image is completely blank"), (long)0L, (long)pixelsDiffer);
    }

    protected int countNonBlankPixels(String testName, BufferedImage image, Color bgColor) {
        int pixelsDiffer = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                if (bgColor == null || bgColor.getAlpha() == 0) {
                    if ((rgb >> 24 & 0xFF) == 0) continue;
                    ++pixelsDiffer;
                    continue;
                }
                if (rgb == bgColor.getRGB()) continue;
                ++pixelsDiffer;
            }
        }
        LOGGER.fine(testName + ": pixel count=" + image.getWidth() * image.getHeight() + " non bg pixels: " + pixelsDiffer);
        return pixelsDiffer;
    }

    protected Document getAsJSoup(String url) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(url);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        GeoServerSystemTestSupport.assertContentType("text/html", response);
        LOGGER.log(Level.INFO, "Last request returned\n:" + response.getContentAsString());
        Document document = Jsoup.parse((String)response.getContentAsString());
        return document;
    }

    protected void checkValidationErorrs(org.w3c.dom.Document dom, String schemaLocation) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new File(schemaLocation));
        this.checkValidationErrors(dom, schema);
    }

    protected void checkValidationErrors(org.w3c.dom.Document dom, Schema schema) throws SAXException, IOException {
        Validator validator = schema.newValidator();
        final ArrayList validationErrors = new ArrayList();
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                GeoServerBaseTestSupport.LOGGER.warning(exception.getMessage());
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                validationErrors.add(exception);
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                validationErrors.add(exception);
            }
        });
        validator.validate(new DOMSource(dom));
        if (validationErrors != null && !validationErrors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Exception ve : validationErrors) {
                sb.append(ve.getMessage()).append("\n");
            }
            Assert.fail((String)sb.toString());
        }
    }

    protected void checkOws10Exception(org.w3c.dom.Document dom) throws Exception {
        this.checkOws10Exception(dom, null, null);
    }

    protected void checkOws10Exception(org.w3c.dom.Document dom, String exceptionCode) throws Exception {
        this.checkOws10Exception(dom, exceptionCode, null);
    }

    protected String checkLegacyException(org.w3c.dom.Document dom, String exceptionCode, String locator) throws Exception {
        Element root = dom.getDocumentElement();
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)root.getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("ServiceException").getLength());
        Element ex = (Element)dom.getElementsByTagName("ServiceException").item(0);
        if (exceptionCode != null) {
            Assert.assertEquals((Object)exceptionCode, (Object)ex.getAttribute("code"));
        }
        if (locator != null) {
            Assert.assertEquals((Object)locator, (Object)ex.getAttribute("locator"));
        }
        return ex.getTextContent();
    }

    protected void checkOws10Exception(org.w3c.dom.Document dom, String exceptionCode, String locator) throws Exception {
        Element root = dom.getDocumentElement();
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)root.getNodeName());
        Assert.assertEquals((Object)"1.0.0", (Object)root.getAttribute("version"));
        Assert.assertEquals((Object)"http://www.opengis.net/ows", (Object)root.getAttribute("xmlns:ows"));
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("ows:Exception").getLength());
        Element ex = (Element)dom.getElementsByTagName("ows:Exception").item(0);
        if (exceptionCode != null) {
            Assert.assertEquals((Object)exceptionCode, (Object)ex.getAttribute("exceptionCode"));
        }
        if (locator != null) {
            Assert.assertEquals((Object)locator, (Object)ex.getAttribute("locator"));
        }
    }

    protected String checkOws11Exception(org.w3c.dom.Document dom) throws Exception {
        return this.checkOws11Exception(dom, null);
    }

    protected String checkOws11Exception(org.w3c.dom.Document dom, String exceptionCode) throws Exception {
        return this.checkOws11Exception(dom, exceptionCode, null);
    }

    protected String checkOws11Exception(org.w3c.dom.Document dom, String exceptionCode, String locator) throws Exception {
        return this.checkOws11Exception(dom, "1.1.0", exceptionCode, locator);
    }

    protected String checkOws11Exception(org.w3c.dom.Document dom, String version, String exceptionCode, String locator) throws Exception {
        NodeList nodes;
        Element ex;
        Element root = dom.getDocumentElement();
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)root.getNodeName());
        Assert.assertEquals((Object)version, (Object)root.getAttribute("version"));
        Assert.assertEquals((Object)"http://www.opengis.net/ows/1.1", (Object)root.getAttribute("xmlns:ows"));
        if (exceptionCode != null) {
            Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("ows:Exception").getLength());
            ex = (Element)dom.getElementsByTagName("ows:Exception").item(0);
            Assert.assertEquals((Object)exceptionCode, (Object)ex.getAttribute("exceptionCode"));
        }
        if (locator != null) {
            Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("ows:Exception").getLength());
            ex = (Element)dom.getElementsByTagName("ows:Exception").item(0);
            Assert.assertEquals((Object)locator, (Object)ex.getAttribute("locator"));
        }
        if ((nodes = dom.getElementsByTagName("ows:ExceptionText")).getLength() > 0) {
            return nodes.item(0).getTextContent();
        }
        return null;
    }

    protected String checkOws20Exception(MockHttpServletResponse response, Integer status, String exceptionCode, String locator) throws Exception {
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        if (status != null) {
            Assert.assertEquals((long)status.intValue(), (long)response.getStatus());
        }
        org.w3c.dom.Document dom = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        Element root = dom.getDocumentElement();
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)root.getNodeName());
        Assert.assertEquals((Object)"2.0.0", (Object)root.getAttribute("version"));
        Assert.assertEquals((Object)"http://www.opengis.net/ows/2.0", (Object)root.getAttribute("xmlns:ows"));
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("ows:Exception").getLength());
        Element ex = (Element)dom.getElementsByTagName("ows:Exception").item(0);
        if (exceptionCode != null) {
            Assert.assertEquals((Object)exceptionCode, (Object)ex.getAttribute("exceptionCode"));
        }
        if (locator != null) {
            Assert.assertEquals((Object)locator, (Object)ex.getAttribute("locator"));
        }
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("ows:ExceptionText").getLength());
        return dom.getElementsByTagName("ows:ExceptionText").item(0).getTextContent();
    }

    protected void reloadCatalogAndConfiguration() throws Exception {
        GeoServerLoaderProxy loader = (GeoServerLoaderProxy)GeoServerExtensions.bean(GeoServerLoaderProxy.class, (ApplicationContext)applicationContext);
        loader.reload();
    }

    protected QName resolveLayerName(String typename) {
        int i = typename.indexOf(":");
        String prefix = typename.substring(0, i);
        String name = typename.substring(i + 1);
        NamespaceInfo ns = this.getCatalog().getNamespaceByPrefix(prefix);
        QName qname = new QName(ns.getURI(), name, ns.getPrefix());
        return qname;
    }

    protected String string(InputStream input) throws Exception {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    protected void print(org.w3c.dom.Document dom) throws Exception {
        if (GeoServerSystemTestSupport.isQuietTests()) {
            return;
        }
        this.print(dom, System.out);
    }

    protected void print(org.w3c.dom.Document document, OutputStream output) {
        try {
            Transformer tx = TransformerFactory.newInstance().newTransformer();
            tx.setOutputProperty("indent", "yes");
            tx.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            tx.transform(new DOMSource(document), new StreamResult(output));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void print(InputStream in) throws Exception {
        if (GeoServerSystemTestSupport.isQuietTests()) {
            return;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = r.readLine()) != null) {
            System.out.println(line);
        }
    }

    protected void print(JSON json) {
        if (GeoServerSystemTestSupport.isQuietTests()) {
            return;
        }
        System.out.println(json.toString(2));
    }

    protected Element getFirstElementByTagName(Element element, String name) {
        NodeList elements = element.getElementsByTagName(name);
        if (elements.getLength() > 0) {
            return (Element)elements.item(0);
        }
        return null;
    }

    protected Element getFirstElementByTagName(org.w3c.dom.Document dom, String name) {
        return this.getFirstElementByTagName(dom.getDocumentElement(), name);
    }

    public static void assertXpathCoordinate(Coordinate expected, String xpathExpression, org.w3c.dom.Document document) throws XpathException {
        XpathEngine simpleXpathEngine = XMLUnit.newXpathEngine();
        String value = simpleXpathEngine.evaluate(xpathExpression, document);
        Assert.assertEquals((String)(xpathExpression + " x"), (double)expected.x, (double)Double.valueOf(value.split(" ")[0]), (double)1.0E-9);
        Assert.assertEquals((String)(xpathExpression + " y"), (double)expected.y, (double)Double.valueOf(value.split(" ")[1]), (double)1.0E-9);
    }

    protected List<Filter> getFilters() {
        return null;
    }

    protected Map<String, Object> parseKvp(Map<String, Object> raw) throws Exception {
        HashMap<String, Object> input = new HashMap<String, Object>(raw);
        List errors = KvpUtils.parse(input);
        if (errors != null && !errors.isEmpty()) {
            throw (Exception)errors.get(0);
        }
        return this.caseInsensitiveKvp(input);
    }

    protected <V> Map<String, V> caseInsensitiveKvp(Map<String, V> input) {
        HashMap<String, V> result = new HashMap<String, V>();
        for (String key : input.keySet()) {
            result.put(key.toUpperCase(), input.get(key));
        }
        return new CaseInsensitiveMap(result);
    }

    protected void assertDeferredLoading(RenderedImage image) {
        if (image instanceof BufferedImage) {
            Assert.fail((String)"Found a buffered image in the chain, the original image is not fully deferred loaded");
        } else {
            for (RenderedImage ri : image.getSources()) {
                this.assertDeferredLoading(ri);
            }
        }
    }

    protected void addKeywordsToLayerGroup(String layerGroupName) {
        ArrayList<Keyword> keywords = new ArrayList<Keyword>();
        Keyword keyword1 = new Keyword("keyword1");
        keyword1.setLanguage("en");
        keyword1.setVocabulary("vocabulary1");
        keywords.add(keyword1);
        Keyword keyword2 = new Keyword("keyword2");
        keyword2.setLanguage("pt");
        keyword2.setVocabulary("vocabulary2");
        keywords.add(keyword2);
        LayerGroupInfo layerGroup = this.getCatalog().getLayerGroupByName(layerGroupName);
        if (layerGroup == null) {
            throw new RuntimeException(String.format("Layer group '%s' doesn't exists.", layerGroupName));
        }
        layerGroup.getKeywords().addAll(keywords);
        this.getCatalog().save(layerGroup);
    }

    protected LayerInfo cloneVectorLayerIntoWorkspace(WorkspaceInfo targetWorkspace, NamespaceInfo targetNameSpace, String layerName) {
        return this.cloneVectorLayerIntoWorkspace(targetWorkspace, targetNameSpace, layerName, layerName);
    }

    protected LayerInfo cloneVectorLayerIntoWorkspace(WorkspaceInfo targetWorkspace, NamespaceInfo targetNameSpace, String layerName, String targetLayerName) {
        Catalog catalog = this.getCatalog();
        LayerInfo originalLayerInfo = catalog.getLayerByName(layerName);
        if (originalLayerInfo == null) {
            throw new RuntimeException(String.format("Could not retrieve a layer for name '%s'.", layerName));
        }
        FeatureTypeInfo originalFeatureTypeInfo = (FeatureTypeInfo)originalLayerInfo.getResource();
        DataStoreInfo originalStoreInfo = originalFeatureTypeInfo.getStore();
        DataStoreInfoImpl copyDataStoreInfo = new DataStoreInfoImpl(catalog);
        OwsUtils.copy((Object)originalStoreInfo, (Object)copyDataStoreInfo, DataStoreInfo.class);
        copyDataStoreInfo.setId(UUID.randomUUID().toString());
        copyDataStoreInfo.setName(UUID.randomUUID().toString());
        copyDataStoreInfo.setWorkspace(targetWorkspace);
        FeatureTypeInfoImpl copyFeatureTypeInfo = new FeatureTypeInfoImpl(catalog);
        OwsUtils.copy((Object)originalFeatureTypeInfo, (Object)copyFeatureTypeInfo, FeatureTypeInfo.class);
        copyFeatureTypeInfo.setNamespace(targetNameSpace);
        copyFeatureTypeInfo.setStore((StoreInfo)copyDataStoreInfo);
        copyFeatureTypeInfo.setName(targetLayerName);
        LayerInfoImpl copyLayerInfo = new LayerInfoImpl();
        OwsUtils.copy((Object)originalLayerInfo, (Object)copyLayerInfo, LayerInfo.class);
        copyLayerInfo.setId(layerName);
        copyLayerInfo.setName(targetLayerName);
        copyLayerInfo.setResource((ResourceInfo)copyFeatureTypeInfo);
        catalog.add((StoreInfo)copyDataStoreInfo);
        catalog.add((ResourceInfo)copyFeatureTypeInfo);
        catalog.add((LayerInfo)copyLayerInfo);
        return catalog.getLayerByName((Name)new NameImpl(targetNameSpace.getPrefix(), targetLayerName));
    }

    protected void assertModuleStatus(String moduleId, String moduleName) {
        boolean requiredModuleWasFound = false;
        for (ModuleStatus statusBean : GeoServerExtensions.extensions(ModuleStatus.class)) {
            if (!statusBean.getModule().equals(moduleId)) continue;
            requiredModuleWasFound = true;
            Assert.assertEquals((String)"Incorrect module name found", (Object)moduleName, (Object)statusBean.getName());
        }
        Assert.assertTrue((String)("Module " + moduleId + " not found"), (boolean)requiredModuleWasFound);
    }

    public static final boolean isGitHubAction() {
        return Boolean.getBoolean("GITHUB_ACTIONS");
    }

    static {
        RESOLVE_DISABLED_PROVIDER_DEVMODE = new PreventLocalEntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (this.isLocalGeoToolsSchema(null, systemId) || this.isDataDirectory(systemId)) {
                    return null;
                }
                return super.resolveEntity(publicId, systemId);
            }

            public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
                if (this.isLocalGeoToolsSchema(baseURI, systemId) || this.isDataDirectory(systemId)) {
                    return null;
                }
                return super.resolveEntity(name, publicId, baseURI, systemId);
            }

            private boolean isLocalGeoToolsSchema(String baseURI, String systemId) {
                if (systemId.startsWith("file:/")) {
                    return this.isLocalGeotoolsSchema(systemId);
                }
                if (!systemId.contains("://") && baseURI != null) {
                    return this.isLocalGeotoolsSchema(baseURI);
                }
                return false;
            }

            private boolean isLocalGeotoolsSchema(String path) {
                return (path = path.toLowerCase()).matches(".*modules[\\\\/]extension[\\\\/]xsd[\\\\/].*\\.xsd") || path.matches(".*modules[\\\\/]ogc[\\\\/].*\\.xsd");
            }

            private boolean isDataDirectory(String systemId) {
                if (applicationContext != null) {
                    GeoServerDataDirectory dd = (GeoServerDataDirectory)applicationContext.getBean(GeoServerDataDirectory.class);
                    try {
                        String path = dd.getRoot(new String[]{"workspaces"}).dir().getCanonicalPath();
                        if (systemId.startsWith("file:")) {
                            systemId = systemId.substring(5);
                        }
                        String canonicalSystemId = new File(systemId).getCanonicalPath();
                        return canonicalSystemId.startsWith(path);
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                return false;
            }

            public String toString() {
                return "PreventLocalEntityResolver";
            }
        };
    }

    private static class GeoServerDelegatingServletInputStream
    extends ServletInputStream {
        private byte[] myBody;
        private int myOffset = 0;
        private int myMark = -1;

        public GeoServerDelegatingServletInputStream(byte[] body) {
            this.myBody = body;
        }

        public int available() {
            return this.myBody.length - this.myOffset;
        }

        public void close() {
        }

        public void mark(int readLimit) {
            this.myMark = this.myOffset;
        }

        public void reset() {
            if (this.myBody == null || this.myMark < 0 || this.myMark >= this.myBody.length) {
                if (this.myBody == null || this.myBody.length == 0) {
                    return;
                }
                throw new IllegalStateException("Can't reset when no mark was set.");
            }
            this.myOffset = this.myMark;
        }

        public boolean markSupported() {
            return true;
        }

        public int read() {
            byte[] b = new byte[1];
            return this.read(b, 0, 1) == -1 ? -1 : b[0];
        }

        public int read(byte[] b) {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int offset, int length) {
            int i;
            int realOffset = offset + this.myOffset;
            if (this.myBody == null || realOffset >= this.myBody.length) {
                return -1;
            }
            for (i = 0; i < length && i + this.myOffset < this.myBody.length; ++i) {
                b[offset + i] = this.myBody[this.myOffset + i];
            }
            this.myOffset += i;
            return i;
        }

        public int readLine(byte[] b, int offset, int length) {
            int i = 0;
            for (i = 0; i < length && i + this.myOffset < this.myBody.length; ++i) {
                b[offset + i] = this.myBody[this.myOffset + i];
                if (this.myBody[this.myOffset + i] == 10) break;
            }
            this.myOffset += i;
            return i;
        }

        public boolean isFinished() {
            return this.available() < 1;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class GeoServerMockHttpServletRequest
    extends MockHttpServletRequest {
        private byte[] myBody;

        public void setContent(byte[] body) {
            this.myBody = body;
        }

        public BufferedReader getReader() {
            if (null == this.myBody) {
                return null;
            }
            return new BufferedReader(new StringReader(new String(this.myBody)));
        }

        public ServletInputStream getInputStream() {
            return new GeoServerDelegatingServletInputStream(this.myBody);
        }

        public String toString() {
            return "GeoServerMockHttpServletRequest " + this.getMethod() + " " + this.getRequestURI();
        }
    }

    static class EmptyResolver
    implements EntityResolver {
        EmptyResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            StringReader reader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            InputSource source = new InputSource(reader);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
    }
}

