/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.geoserver.util.IOUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.ui.context.Theme;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.ServletContextAwareProcessor;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Element;

public class GeoServerTestApplicationContext
extends ClassPathXmlApplicationContext
implements WebApplicationContext {
    ServletContext servletContext;
    boolean useLegacyGeoServerLoader = true;
    final File contextTmp;

    public GeoServerTestApplicationContext(String[] configLocation, ServletContext servletContext) throws BeansException {
        super(configLocation, false);
        try {
            this.contextTmp = IOUtils.createRandomDirectory((String)"./target", (String)"mock", (String)"tmp");
            servletContext.setAttribute("javax.servlet.context.tempdir", (Object)this.contextTmp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Theme getTheme(String themeName) {
        return null;
    }

    public void setUseLegacyGeoServerLoader(boolean useLegacyGeoServerLoader) {
        this.useLegacyGeoServerLoader = useLegacyGeoServerLoader;
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        super.loadBeanDefinitions(reader);
        if (this.useLegacyGeoServerLoader) {
            BeanDefinition def = reader.getRegistry().getBeanDefinition("geoServerLoader");
            def.setBeanClassName("org.geoserver.test.TestGeoServerLoaderProxy");
        }
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ServletContextAwareProcessor(this.servletContext));
        beanFactory.ignoreDependencyInterface(ServletContextAware.class);
        beanFactory.ignoreDependencyInterface(ServletConfigAware.class);
        WebApplicationContextUtils.registerWebApplicationScopes((ConfigurableListableBeanFactory)beanFactory, (ServletContext)this.servletContext);
        WebApplicationContextUtils.registerEnvironmentBeans((ConfigurableListableBeanFactory)beanFactory, (ServletContext)this.servletContext);
    }

    protected void initPropertySources() {
        super.initPropertySources();
        WebApplicationContextUtils.initServletPropertySources((MutablePropertySources)this.getEnvironment().getPropertySources(), (ServletContext)this.servletContext);
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader reader) {
        super.initBeanDefinitionReader(reader);
        reader.setDocumentReaderClass(LazyBeanDefinitionDocumentReader.class);
    }

    protected void onClose() {
        super.onClose();
        FileUtils.deleteQuietly((File)this.contextTmp);
    }

    static class LazyBeanDefinitionDocumentReader
    extends DefaultBeanDefinitionDocumentReader {
        LazyBeanDefinitionDocumentReader() {
        }

        protected BeanDefinitionParserDelegate createDelegate(XmlReaderContext readerContext, Element root, BeanDefinitionParserDelegate parentDelegate) {
            root.setAttribute("default-lazy-init", "true");
            BeanDefinitionParserDelegate delegate = super.createDelegate(readerContext, root, parentDelegate);
            return delegate;
        }
    }
}

