/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.threadlocals;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.LocalPublished;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.Request;
import org.geoserver.security.AdminRequest;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.threadlocals.ThreadLocalTransfer;
import org.geoserver.threadlocals.ThreadLocalsTransfer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class ThreadLocalsTransferTest
extends GeoServerSystemTestSupport {
    protected ExecutorService executor;

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    @Before
    public void setupExecutor() {
        this.executor = Executors.newCachedThreadPool();
    }

    @After
    public void stopExecutor() {
        this.executor.shutdown();
    }

    @After
    public void cleanupThreadLocals() {
        Dispatcher.REQUEST.remove();
        AdminRequest.finish();
        LocalPublished.remove();
        LocalWorkspace.remove();
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    @Test
    public void testThreadLocalTransfer() throws InterruptedException, ExecutionException {
        final Request request = new Request();
        Dispatcher.REQUEST.set(request);
        LayerInfoImpl layer = new LayerInfoImpl();
        LocalPublished.set((PublishedInfo)layer);
        WorkspaceInfoImpl ws = new WorkspaceInfoImpl();
        LocalWorkspace.set((WorkspaceInfo)ws);
        final Object myState = new Object();
        AdminRequest.start((Object)myState);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        final ThreadLocalsTransfer transfer = new ThreadLocalsTransfer();
        Future<Void> future = this.executor.submit(new Callable<Void>((LayerInfo)layer, (WorkspaceInfo)ws, (Authentication)auth){
            final /* synthetic */ LayerInfo val$layer;
            final /* synthetic */ WorkspaceInfo val$ws;
            final /* synthetic */ Authentication val$auth;
            {
                this.val$layer = layerInfo;
                this.val$ws = workspaceInfo;
                this.val$auth = authentication;
            }

            @Override
            public Void call() throws Exception {
                this.testApply();
                this.testCleanup();
                return null;
            }

            private void testApply() {
                transfer.apply();
                Assert.assertSame((Object)request, Dispatcher.REQUEST.get());
                Assert.assertSame((Object)myState, (Object)AdminRequest.get());
                Assert.assertSame((Object)this.val$layer, (Object)LocalPublished.get());
                Assert.assertSame((Object)this.val$ws, (Object)LocalWorkspace.get());
                Assert.assertSame((Object)this.val$auth, (Object)SecurityContextHolder.getContext().getAuthentication());
            }

            private void testCleanup() {
                transfer.cleanup();
                Assert.assertNull(Dispatcher.REQUEST.get());
                Assert.assertNull((Object)AdminRequest.get());
                Assert.assertNull((Object)LocalPublished.get());
                Assert.assertNull((Object)LocalWorkspace.get());
                Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
            }
        });
        future.get();
    }

    protected static abstract class ThreadLocalTransferCallable
    implements Callable<Void> {
        Thread originalThread;
        ThreadLocalTransfer transfer;
        Map<String, Object> storage = new HashMap<String, Object>();

        public ThreadLocalTransferCallable(ThreadLocalTransfer transfer) {
            this.originalThread = Thread.currentThread();
            this.transfer = transfer;
            this.transfer.collect(this.storage);
        }

        @Override
        public Void call() throws Exception {
            Assert.assertNotEquals((Object)this.originalThread, (Object)Thread.currentThread());
            this.transfer.apply(this.storage);
            this.assertThreadLocalApplied();
            this.transfer.cleanup();
            this.assertThreadLocalCleaned();
            return null;
        }

        abstract void assertThreadLocalCleaned();

        abstract void assertThreadLocalApplied();
    }
}

