/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.crs;

import java.io.File;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.SystemTest;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class OverrideCRSTest
extends GeoServerSystemTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        new File(testData.getDataDirectoryRoot(), "user_projections").mkdir();
        testData.copyTo(OverrideCRSTest.class.getResourceAsStream("test_override_epsg.properties"), "user_projections/epsg_overrides.properties");
        CRS.reset((String)"all");
        testData.setUpSecurity();
    }

    @Test
    public void testOverride() throws Exception {
        CoordinateReferenceSystem epsg3003 = CRS.decode((String)"EPSG:3003");
        DefaultGeodeticDatum datum3003 = (DefaultGeodeticDatum)((ProjectedCRS)epsg3003).getDatum();
        BursaWolfParameters[] bwParamArray3003 = datum3003.getBursaWolfParameters();
        Assert.assertEquals((long)1L, (long)bwParamArray3003.length);
        BursaWolfParameters bw3003 = bwParamArray3003[0];
        double tol = 1.0E-7;
        Assert.assertEquals((double)-104.1, (double)bw3003.dx, (double)tol);
        Assert.assertEquals((double)-49.1, (double)bw3003.dy, (double)tol);
        Assert.assertEquals((double)-9.9, (double)bw3003.dz, (double)tol);
        Assert.assertEquals((double)0.971, (double)bw3003.ex, (double)tol);
        Assert.assertEquals((double)-2.917, (double)bw3003.ey, (double)tol);
        Assert.assertEquals((double)0.714, (double)bw3003.ez, (double)tol);
        Assert.assertEquals((double)-11.68, (double)bw3003.ppm, (double)tol);
        CoordinateReferenceSystem epsg3002 = CRS.decode((String)"EPSG:3002");
        DefaultGeodeticDatum datum3002 = (DefaultGeodeticDatum)((ProjectedCRS)epsg3002).getDatum();
        BursaWolfParameters[] bwParamArray3002 = datum3002.getBursaWolfParameters();
        Assert.assertEquals((long)1L, (long)bwParamArray3002.length);
        BursaWolfParameters bw3002 = bwParamArray3002[0];
        Assert.assertNotEquals((Object)bw3002, (Object)bw3003);
    }
}

