/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.crs;

import java.io.File;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.ConcatenatedOperation;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.referencing.CRS;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class OvverideTransformationsTest
extends GeoServerSystemTestSupport {
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String SOURCE_CRS = "EPSG:TEST1";
    private static final String TARGET_CRS = "EPSG:TEST2";
    private static final double[] SRC_TEST_POINT = new double[]{39.592654167, 3.084896111};
    private static final double[] DST_TEST_POINT = new double[]{39.594235744481225, 3.0844689951999427};
    private static String OLD_TMP_VALUE;

    @AfterClass
    public static void clearTemp() {
        if (OLD_TMP_VALUE == null) {
            System.clearProperty(JAVA_IO_TMPDIR);
        } else {
            System.setProperty(JAVA_IO_TMPDIR, OLD_TMP_VALUE);
        }
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        OLD_TMP_VALUE = System.getProperty(JAVA_IO_TMPDIR);
        System.setProperty(JAVA_IO_TMPDIR, new File("./target").getCanonicalPath());
        super.onSetUp(testData);
        new File(testData.getDataDirectoryRoot(), "user_projections").mkdir();
        testData.copyTo(OvverideTransformationsTest.class.getResourceAsStream("test_epsg.properties"), "user_projections/epsg.properties");
        testData.copyTo(OvverideTransformationsTest.class.getResourceAsStream("test_epsg_operations.properties"), "user_projections/epsg_operations.properties");
        testData.copyTo(OvverideTransformationsTest.class.getResourceAsStream("stgeorge.las"), "user_projections/stgeorge.las");
        testData.copyTo(OvverideTransformationsTest.class.getResourceAsStream("stgeorge.los"), "user_projections/stgeorge.los");
        CRS.reset((String)"all");
    }

    @Test
    public void testCreateOperationFromCustomCodes() throws Exception {
        CoordinateReferenceSystem source = CRS.decode((String)SOURCE_CRS);
        CoordinateReferenceSystem target = CRS.decode((String)TARGET_CRS);
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target, (boolean)true);
        double[] p = new double[2];
        mt.transform(SRC_TEST_POINT, 0, p, 0, 1);
        Assert.assertEquals((double)p[0], (double)DST_TEST_POINT[0], (double)1.0E-8);
        Assert.assertEquals((double)p[1], (double)DST_TEST_POINT[1], (double)1.0E-8);
    }

    @Test
    public void testOverrideEPSGOperation() throws Exception {
        CoordinateReferenceSystem source = CRS.decode((String)"EPSG:4269");
        CoordinateReferenceSystem target = CRS.decode((String)"EPSG:4326");
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target, (boolean)true);
        double[] p = new double[2];
        mt.transform(SRC_TEST_POINT, 0, p, 0, 1);
        Assert.assertEquals((double)p[0], (double)DST_TEST_POINT[0], (double)1.0E-8);
        Assert.assertEquals((double)p[1], (double)DST_TEST_POINT[1], (double)1.0E-8);
    }

    @Test
    public void testFallbackOnEPSGDatabaseStd() throws Exception {
        CoordinateReferenceSystem source = CRS.decode((String)"EPSG:3002");
        CoordinateReferenceSystem target = CRS.decode((String)"EPSG:4326");
        CoordinateOperation co = CRS.getCoordinateOperationFactory((boolean)true).createOperation(source, target);
        ConcatenatedOperation cco = (ConcatenatedOperation)co;
        Assert.assertEquals((long)2L, (long)cco.getOperations().size());
    }

    @Test
    public void testNadCon() throws Exception {
        CoordinateReferenceSystem crs4138 = CRS.decode((String)"EPSG:4138");
        CoordinateReferenceSystem crs4326 = CRS.decode((String)"EPSG:4326");
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)crs4138, (CoordinateReferenceSystem)crs4326);
        Assert.assertTrue((boolean)mt.toWKT().contains("NADCON"));
        double[] src = new double[]{-169.625, 56.575};
        double[] expected = new double[]{-169.62744, 56.576034};
        double[] p = new double[2];
        mt.transform(src, 0, p, 0, 1);
        Assert.assertEquals((double)expected[0], (double)p[0], (double)1.0E-6);
        Assert.assertEquals((double)expected[1], (double)p[1], (double)1.0E-6);
    }
}

