/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import it.geosolutions.imageio.pam.PAMDataset;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.CoverageViewReader;
import org.geotools.api.data.ResourceInfo;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.PAMResourceInfo;
import org.geotools.data.DefaultResourceInfo;

public class CoverageViewPamResourceInfo
extends DefaultResourceInfo
implements PAMResourceInfo {
    private final PAMDataset viewPam = new PAMDataset();

    public CoverageViewPamResourceInfo(CoverageViewReader.ViewInputs viewInputs) {
        this.populatePAMFromViewBands(viewInputs, this.viewPam);
    }

    public PAMDataset getPAMDataset() {
        return this.viewPam;
    }

    public boolean reloadPAMDataset() throws IOException {
        return super.reloadPAMDataset();
    }

    private void populatePAMFromViewBands(CoverageViewReader.ViewInputs info, PAMDataset viewPam) {
        HashMap<String, GridCoverage2DReader> readers = info.getInputReaders();
        for (CoverageView.CoverageBand band : info.getBands()) {
            for (CoverageView.InputCoverageBand inputCoverageBand : band.getInputCoverageBands()) {
                PAMDataset bandPam;
                GridCoverage2DReader bandReader = (GridCoverage2DReader)readers.get(inputCoverageBand.getCoverageName());
                ResourceInfo resourceInfoBand = bandReader.getInfo(inputCoverageBand.getCoverageName());
                if (!(resourceInfoBand instanceof PAMResourceInfo) || (bandPam = ((PAMResourceInfo)resourceInfoBand).getPAMDataset()) == null) continue;
                List pamRasterBands = bandPam.getPAMRasterBand();
                Optional<PAMDataset.PAMRasterBand> pamRasterBandOptional = this.getPAMRasterBandByBandIndex(pamRasterBands, inputCoverageBand.getBand());
                pamRasterBandOptional.ifPresent(pamRasterBand -> viewPam.getPAMRasterBand().add(pamRasterBand));
            }
        }
    }

    private Optional<PAMDataset.PAMRasterBand> getPAMRasterBandByBandIndex(List<PAMDataset.PAMRasterBand> pamRasterBands, String band) {
        for (PAMDataset.PAMRasterBand pamRasterBand : pamRasterBands) {
            Integer adjustedBand = pamRasterBand.getBand() - 1;
            if (!adjustedBand.toString().equals(band)) continue;
            return Optional.of(pamRasterBand);
        }
        return Optional.empty();
    }
}

