/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import it.geosolutions.jaiext.jiffle.Jiffle;
import it.geosolutions.jaiext.jiffle.JiffleException;
import it.geosolutions.jaiext.jiffle.parser.JiffleParserException;
import it.geosolutions.jaiext.jiffle.parser.node.GetSourceValue;
import it.geosolutions.jaiext.jiffle.runtime.JiffleIndirectRuntime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geoserver.catalog.CoverageView;

public class JiffleParser {
    public static JiffleParsingResult parse(String outputVariable, String script, List<String> coverageNames) throws IllegalArgumentException {
        JiffleParsingResult result = new JiffleParsingResult();
        try {
            Set readPositions = Jiffle.getReadPositions((String)script, coverageNames);
            HashSet<CoverageView.InputCoverageBand> inputVariables = new HashSet<CoverageView.InputCoverageBand>();
            for (GetSourceValue sourceValue : readPositions) {
                inputVariables.add(new CoverageView.InputCoverageBand(sourceValue.getVarName(), sourceValue.getPos().getBand().toString()));
            }
            Jiffle jiffle = new Jiffle();
            jiffle.setScript(script);
            HashMap<String, Jiffle.ImageRole> imageParams = new HashMap<String, Jiffle.ImageRole>();
            for (CoverageView.InputCoverageBand inputBand : inputVariables) {
                imageParams.put(inputBand.getCoverageName(), Jiffle.ImageRole.SOURCE);
            }
            imageParams.put(outputVariable, Jiffle.ImageRole.DEST);
            jiffle.setImageParams(imageParams);
            jiffle.compile();
            JiffleIndirectRuntime runtime = (JiffleIndirectRuntime)jiffle.getRuntimeInstance(Jiffle.RuntimeModel.INDIRECT);
            result.inputBands = inputVariables;
            result.outputVar = outputVariable;
            result.numBands = runtime.getOutputBands();
        }
        catch (JiffleException | JiffleParserException je) {
            result.error = "Exception occurred while parsing the jiffle script: " + je.getLocalizedMessage();
        }
        return result;
    }

    public static class JiffleParsingResult {
        public String outputVar;
        public int numBands;
        public Set<CoverageView.InputCoverageBand> inputBands;
        public String error;
    }
}

