/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.CoverageViewReader;
import org.geoserver.feature.CompositeFeatureCollection;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GranuleStore;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.HarvestedSource;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class StructuredCoverageViewReader
extends CoverageViewReader
implements StructuredGridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger(StructuredCoverageViewReader.class);
    public static Hints.Key QUERY_FIRST_BAND = new Hints.Key(Boolean.class);
    private StructuredGridCoverage2DReader structuredDelegate;

    public StructuredCoverageViewReader(StructuredGridCoverage2DReader delegate, CoverageView coverageView, CoverageInfo coverageInfo, Hints hints) {
        super((GridCoverage2DReader)delegate, coverageView, coverageInfo, hints);
        this.structuredDelegate = delegate;
    }

    public GranuleSource getGranules(String coverageName, boolean readOnly) throws IOException, UnsupportedOperationException {
        return new GranuleStoreView(this.structuredDelegate, this.referenceName, this.coverageView, readOnly);
    }

    public boolean isReadOnly() {
        return this.structuredDelegate.isReadOnly();
    }

    public void createCoverage(String coverageName, SimpleFeatureType schema) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation unavailable for Coverage Views");
    }

    public boolean removeCoverage(String coverageName, boolean delete) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation unavailable for Coverage Views");
    }

    public void delete(boolean deleteData) throws IOException {
        this.structuredDelegate.delete(deleteData);
    }

    public List<HarvestedSource> harvest(String defaultTargetCoverage, Object source, Hints hints) throws IOException, UnsupportedOperationException {
        return this.structuredDelegate.harvest(defaultTargetCoverage, source, hints);
    }

    public List<DimensionDescriptor> getDimensionDescriptors(String coverageName) throws IOException {
        return this.structuredDelegate.getDimensionDescriptors(this.referenceName);
    }

    static class GranuleStoreView
    implements GranuleStore {
        private StructuredGridCoverage2DReader reader;
        private CoverageView coverageView;
        private String name;
        private boolean readOnly;

        public GranuleStoreView(StructuredGridCoverage2DReader structuredDelegate, String referenceName, CoverageView coverageView, boolean readOnly) throws UnsupportedOperationException, IOException {
            this.reader = structuredDelegate;
            this.coverageView = coverageView;
            this.name = referenceName;
            this.readOnly = readOnly;
        }

        public SimpleFeatureCollection getGranules(Query q) throws IOException {
            Query renamedQuery;
            List<CoverageView.CoverageBand> bands = this.coverageView.getCoverageBands();
            Query query = renamedQuery = q != null ? new Query(q) : new Query();
            if (q != null && q.getFilter() != null) {
                Filter unmapped = GranuleStoreViewFilterVisitor.unmapIdentifiers(q.getFilter(), this.coverageView.getName());
                renamedQuery.setFilter(unmapped);
            }
            ArrayList<SimpleFeatureCollection> collections = new ArrayList<SimpleFeatureCollection>();
            boolean returnOnlyFirst = Boolean.TRUE.equals(renamedQuery.getHints().getOrDefault((Object)QUERY_FIRST_BAND, (Object)false));
            HashSet<String> queriesCoverages = new HashSet<String>();
            for (CoverageView.CoverageBand band : bands) {
                String coverageName = band.getInputCoverageBands().get(0).getCoverageName();
                if (queriesCoverages.add(coverageName)) {
                    renamedQuery.setTypeName(coverageName);
                    SimpleFeatureCollection collection = this.reader.getGranules(coverageName, this.readOnly).getGranules(renamedQuery);
                    collections.add(collection);
                }
                if (!returnOnlyFirst) continue;
                break;
            }
            if (collections.isEmpty()) {
                throw new IllegalStateException("Unexpected, there is not a single band in the definition?");
            }
            SimpleFeatureType schema = (SimpleFeatureType)((SimpleFeatureCollection)collections.get(0)).getSchema();
            SimpleFeatureCollection result = DataUtilities.simple(new CompositeFeatureCollection(collections, schema));
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.init(schema);
            tb.setName(this.coverageView.getName());
            return new RetypingFeatureCollection(result, tb.buildFeatureType()){

                @Override
                public SimpleFeatureIterator features() {
                    return new RetypingFeatureCollection.RetypingIterator(this.delegate.features(), this.target){

                        @Override
                        public SimpleFeature next() {
                            SimpleFeature next = (SimpleFeature)this.delegate.next();
                            this.builder.init(next);
                            String newId = coverageView.getName() + "." + next.getID();
                            return this.builder.buildFeature(newId);
                        }
                    };
                }
            };
        }

        public int getCount(Query q) throws IOException {
            return this.getGranules(q).size();
        }

        public ReferencedEnvelope getBounds(Query q) throws IOException {
            return this.getGranules(q).getBounds();
        }

        public SimpleFeatureType getSchema() throws IOException {
            List<CoverageView.CoverageBand> bands = this.coverageView.getCoverageBands();
            String coverageName = bands.get(0).getInputCoverageBands().get(0).getCoverageName();
            return this.reader.getGranules(coverageName, true).getSchema();
        }

        public void dispose() throws IOException {
        }

        public void addGranules(SimpleFeatureCollection granules) {
            throw new UnsupportedOperationException();
        }

        public int removeGranules(Filter filter) {
            return this.removeGranules(filter, new Hints());
        }

        public int removeGranules(Filter filter, Hints hints) {
            Filter unmapped = GranuleStoreViewFilterVisitor.unmapIdentifiers(filter, this.coverageView.getName());
            List<CoverageView.CoverageBand> bands = this.coverageView.getCoverageBands();
            int removed = 0;
            for (CoverageView.CoverageBand band : bands) {
                String coverageName = band.getInputCoverageBands().get(0).getCoverageName();
                try {
                    GranuleStore granuleStore = (GranuleStore)this.reader.getGranules(coverageName, false);
                    removed = granuleStore.removeGranules(unmapped, hints);
                }
                catch (IOException | UnsupportedOperationException e) {
                    LOGGER.log(Level.FINER, e.getMessage(), e);
                }
            }
            return removed;
        }

        public void updateGranules(String[] attributeNames, Object[] attributeValues, Filter filter) {
            throw new UnsupportedOperationException();
        }

        public Transaction getTransaction() {
            return null;
        }

        public void setTransaction(Transaction transaction) {
        }
    }

    static class GranuleStoreViewFilterVisitor
    extends DuplicatingFilterVisitor {
        String prefix;

        static Filter unmapIdentifiers(Filter filter, String viewName) {
            GranuleStoreViewFilterVisitor visitor = new GranuleStoreViewFilterVisitor(viewName);
            return (Filter)filter.accept((FilterVisitor)visitor, null);
        }

        public GranuleStoreViewFilterVisitor(String viewName) {
            this.prefix = viewName + ".";
        }

        public Object visit(Id filter, Object extraData) {
            Set identifiers = filter.getIdentifiers();
            Set renamedIdentifiers = identifiers.stream().map(id -> {
                String name = id.getID().toString();
                if (name.startsWith(this.prefix)) {
                    name = name.substring(this.prefix.length());
                }
                return this.getFactory(extraData).featureId(name);
            }).collect(Collectors.toSet());
            return this.getFactory(extraData).id(renamedIdentifiers);
        }
    }
}

