/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ValidationException;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.filter.visitor.ExpressionTypeVisitor;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.VirtualTable;
import org.geotools.util.Converters;

class FeatureTypeValidator {
    FeatureTypeValidator() {
    }

    public void validate(FeatureTypeInfo fti) {
        List<AttributeTypeInfo> attributes = fti.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        Optional<MetadataMap> metadata = Optional.ofNullable(fti.getMetadata());
        VirtualTable vt = metadata.map(m -> m.get("JDBC_VIRTUAL_TABLE", VirtualTable.class)).orElse(null);
        String typeName = fti.getNativeName();
        boolean temporaryVirtualTable = false;
        JDBCDataStore jds = null;
        try {
            DataAccess<? extends FeatureType, ? extends Feature> access = fti.getStore().getDataStore(null);
            if (!(access instanceof DataStore)) {
                return;
            }
            DataStore ds = (DataStore)access;
            if (vt != null && ds instanceof JDBCDataStore) {
                jds = (JDBCDataStore)ds;
                typeName = this.setupTempVirtualTable(vt, jds);
                temporaryVirtualTable = true;
            }
            SimpleFeatureType ft = ds.getSchema(typeName);
            Map<String, AttributeDescriptor> nativeAttributes = ft.getAttributeDescriptors().stream().collect(Collectors.toMap(ad -> ad.getLocalName(), ad -> ad));
            HashSet<String> names = new HashSet<String>();
            for (AttributeTypeInfo attribute : attributes) {
                this.validate(attribute, ft, nativeAttributes);
                String name = attribute.getName();
                if (names.contains(name)) {
                    throw new ValidationException("multiAttributeSameName", "Found multiple definitions for output attribute {0}", name);
                }
                names.add(name);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to access data source to check attribute customization", e);
        }
        finally {
            if (temporaryVirtualTable && jds != null) {
                jds.dropVirtualTable(typeName);
            }
        }
    }

    private String setupTempVirtualTable(VirtualTable vt, JDBCDataStore ds) throws IOException {
        String temporaryName = null;
        do {
            temporaryName = UUID.randomUUID().toString();
        } while (Arrays.asList(ds.getTypeNames()).contains(temporaryName));
        VirtualTable temporary = new VirtualTable(temporaryName, vt);
        ds.createVirtualTable(temporary);
        return temporaryName;
    }

    private void validate(AttributeTypeInfo attribute, SimpleFeatureType schema, Map<String, AttributeDescriptor> nativeAttributes) {
        try {
            ExpressionTypeVisitor typeVisitor;
            Class expressionType;
            if (attribute.getName() == null || attribute.getName().isEmpty()) {
                throw new ValidationException("attributeNullName", "Attribute name must not be null or empty", new Object[0]);
            }
            if (attribute.getSource() == null || attribute.getSource().isEmpty()) {
                throw new ValidationException("attributeNullSource", "Attribute source must not be null or empty", new Object[0]);
            }
            Expression expression = ECQL.toExpression((String)attribute.getSource());
            FilterAttributeExtractor extractor = new FilterAttributeExtractor(schema);
            expression.accept((ExpressionVisitor)extractor, null);
            HashSet usedSourceAttributes = new HashSet(extractor.getAttributeNameSet());
            usedSourceAttributes.removeAll(nativeAttributes.keySet());
            if (!usedSourceAttributes.isEmpty()) {
                throw new ValidationException("cqlUsesInvalidAttribute", "The CQL source expression for attribute {0} refers to attributes unavailable in the data source: {1}", attribute.getName(), usedSourceAttributes);
            }
            Class<?> binding = attribute.getBinding();
            if (binding != null && !Object.class.equals((Object)(expressionType = (Class)expression.accept((ExpressionVisitor)(typeVisitor = new ExpressionTypeVisitor((FeatureType)schema)), null))) && !expressionType.equals(binding) && !binding.equals(String.class) && Converters.getConverterFactories((Class)expressionType, binding).isEmpty()) {
                throw new ValidationException("attributeInvalidConversion", "Issue found in attribute {0}, unable to convert from native type, {1}, to target type, {2}", attribute.getName(), expressionType.getName(), binding.getName());
            }
        }
        catch (CQLException e) {
            throw new ValidationException("attributeInvalidCQL", "Invalid CQL for {0} source. {1}", attribute.getName(), e.getMessage());
        }
    }
}

