/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.IOException;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerConfigPersister;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.GeoServerLoaderListener;
import org.geoserver.config.GeoServerResourcePersister;
import org.geoserver.config.ServicePersister;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;

public class DefaultGeoServerLoader
extends GeoServerLoader {
    ConfigurationListener listener;
    GeoServerConfigPersister configPersister;
    private GeoServerLoaderListener loaderListener = null;

    public DefaultGeoServerLoader(GeoServerResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    @Override
    protected void loadCatalog(Catalog catalog, XStreamPersister xp) throws Exception {
        catalog.setResourceLoader(this.resourceLoader);
        this.readCatalog(catalog, xp);
        if (!legacy) {
            catalog.addListener(new GeoServerConfigPersister(this.resourceLoader, xp));
            catalog.addListener(new GeoServerResourcePersister(catalog));
        }
        this.executeListener(catalog, xp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadGeoServer(GeoServer geoServer, XStreamPersister xp) throws Exception {
        if (this.listener == null) {
            List loaders = GeoServerExtensions.extensions(XStreamServiceLoader.class);
            this.listener = new ServicePersister(loaders, geoServer);
        } else {
            this.geoserver.removeListener(this.listener);
        }
        try {
            if (this.configPersister != null) {
                this.geoserver.removeListener(this.configPersister);
            } else {
                this.configPersister = new GeoServerConfigPersister(this.resourceLoader, xp);
            }
            this.readConfiguration(geoServer, xp);
        }
        finally {
            this.geoserver.addListener(this.configPersister);
            this.geoserver.addListener(this.listener);
            this.executeListener(geoServer, xp);
        }
    }

    @Override
    protected void initializeStyles(Catalog catalog, XStreamPersister xp) throws IOException {
        GeoServerConfigPersister cp = new GeoServerConfigPersister(this.resourceLoader, xp);
        GeoServerResourcePersister rp = new GeoServerResourcePersister(catalog);
        catalog.addListener(cp);
        catalog.addListener(rp);
        super.initializeStyles(catalog, xp);
        catalog.removeListener(cp);
        catalog.removeListener(rp);
    }

    protected void executeListener(Catalog catalog, XStreamPersister xp) {
        this.getLoaderListener().loadCatalog(catalog, xp);
    }

    protected void executeListener(GeoServer geoServer, XStreamPersister xp) {
        this.getLoaderListener().loadGeoServer(geoServer, xp);
    }

    private GeoServerLoaderListener getLoaderListener() {
        if (this.loaderListener == null) {
            this.loadLoaderListener();
        }
        return this.loaderListener;
    }

    private synchronized void loadLoaderListener() {
        if (this.loaderListener != null) {
            return;
        }
        GeoServerLoaderListener bean = (GeoServerLoaderListener)GeoServerExtensions.bean(GeoServerLoaderListener.class);
        this.loaderListener = bean != null ? bean : GeoServerLoaderListener.EMPTY_LISTENER;
    }
}

