/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.opengis.ows20.AcceptLanguagesType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.util.GeoServerDefaultLocale;
import org.geotools.api.style.Description;
import org.geotools.api.style.Style;
import org.geotools.api.util.InternationalString;
import org.geotools.util.GrowableInternationalString;

public class InternationalContentHelper {
    private Set<Locale> requestedLocales = new LinkedHashSet<Locale>();
    protected boolean anyMatch = false;
    private Set<Locale> supportedLocales;
    public static final String ERROR_MESSAGE = "DID NOT FIND i18n CONTENT FOR THIS ELEMENT";
    public static final String ACCEPTLANGUAGES_PARAM = "ACCEPTLANGUAGES";

    public InternationalContentHelper(String[] acceptLanguages, ServiceInfo serviceInfo, List<LayerInfo> layers, List<LayerGroupInfo> groups) {
        this.setSupportedLocales(serviceInfo, layers, groups);
        this.setRequestedLocales(acceptLanguages);
        this.verify();
    }

    public InternationalContentHelper(String[] acceptLanguages, ServiceInfo serviceInfo, List<ResourceInfo> resources) {
        this.setSupportedLocales(serviceInfo, resources);
        this.setRequestedLocales(acceptLanguages);
        this.verify();
    }

    public InternationalContentHelper(Locale locale) {
        if (locale != null) {
            this.requestedLocales.add(locale);
        }
    }

    public InternationalContentHelper(AcceptLanguagesType acceptLanguagesType, ServiceInfo serviceInfo, List<ResourceInfo> resources) {
        this.setSupportedLocales(serviceInfo, resources);
        this.setRequestedLocales(acceptLanguagesType);
        this.verify();
    }

    private void setRequestedLocales(AcceptLanguagesType acceptLanguagesType) {
        if (acceptLanguagesType != null) {
            EList acceptLanguages = acceptLanguagesType.getLanguage();
            Object[] languagesAr = new String[acceptLanguages.size()];
            acceptLanguages.toArray(languagesAr);
            this.setRequestedLocales((String[])languagesAr);
        }
    }

    private void setRequestedLocales(String[] preferredLanguages) {
        ArrayList<String> withoutVariant = new ArrayList<String>();
        if (preferredLanguages != null && preferredLanguages.length > 0) {
            for (String language : preferredLanguages) {
                Locale locale = null;
                if (language.equals("*") || language.isEmpty()) {
                    this.anyMatch = true;
                    locale = Locale.getDefault();
                } else if (language.contains("-")) {
                    locale = Locale.forLanguageTag(language);
                } else {
                    withoutVariant.add(language);
                }
                if (locale == null) continue;
                this.requestedLocales.add(locale);
            }
        }
        for (String language : withoutVariant) {
            this.requestedLocales.addAll(this.supportedLocales.stream().filter(l -> l != null && l.getLanguage().equals(language)).collect(Collectors.toSet()));
            this.requestedLocales.add(Locale.forLanguageTag(language));
        }
    }

    public String getTitle(ResourceInfo info) {
        InternationalString internationalString = info.getInternationalTitle();
        return this.getString(internationalString, false);
    }

    public String getAbstract(ResourceInfo info) {
        InternationalString internationalString = info.getInternationalAbstract();
        return this.getString(internationalString, true);
    }

    public String getTitle(PublishedInfo info) {
        InternationalString internationalString = info.getInternationalTitle();
        return this.getString(internationalString, false);
    }

    public String getAbstract(PublishedInfo info) {
        InternationalString internationalString = info.getInternationalAbstract();
        return this.getString(internationalString, true);
    }

    public String getTitle(ServiceInfo serviceInfo) {
        InternationalString internationalString = serviceInfo.getInternationalTitle();
        return this.getString(internationalString, false);
    }

    public String getAbstract(ServiceInfo serviceInfo) {
        InternationalString internationalString = serviceInfo.getInternationalAbstract();
        return this.getString(internationalString, true);
    }

    public String getTitle(Style style) {
        Description description = style.getDescription();
        if (description != null) {
            InternationalString internationalString = description.getTitle();
            return this.getString(internationalString, true);
        }
        return null;
    }

    public String getAbstract(Style style) {
        Description description = style.getDescription();
        if (description != null) {
            InternationalString internationalString = description.getAbstract();
            return this.getString(internationalString, true);
        }
        return null;
    }

    public List<KeywordInfo> filterKeywords(List<KeywordInfo> original) {
        List<KeywordInfo> filtered = Collections.emptyList();
        Iterator<Locale> iterator = this.requestedLocales.iterator();
        while (filtered.isEmpty() && iterator.hasNext()) {
            filtered = original.stream().filter(new KeywordMatch(iterator.next())).collect(Collectors.toList());
        }
        if (filtered.isEmpty() && this.anyMatch) {
            return original;
        }
        return filtered;
    }

    public String getString(InternationalString internationalString, boolean nullable) {
        String result = null;
        if (internationalString instanceof GrowableInternationalString) {
            GrowableInternationalString growable = (GrowableInternationalString)internationalString;
            result = this.getFirstMatchingInternationalValue(growable, this.requestedLocales);
            if (result == null && this.anyMatch) {
                result = growable.toString(GeoServerDefaultLocale.get());
            }
            if (result == null && growable.getLocales().contains(null)) {
                result = growable.toString(null);
            }
        }
        if (result == null && !nullable) {
            result = ERROR_MESSAGE;
        }
        return result;
    }

    public String getNullableString(InternationalString internationalString) {
        return this.getString(internationalString, true);
    }

    private String getFirstMatchingInternationalValue(GrowableInternationalString growable, Set<Locale> locales) {
        String result;
        block1: {
            result = null;
            if (locales == null || locales.isEmpty()) break block1;
            Set growableLocales = growable.getLocales();
            for (Locale l : locales) {
                if (growableLocales.contains(l) && (result = growable.toString(l)) != null) break;
            }
        }
        return result;
    }

    private void setSupportedLocales(ServiceInfo info, List<ResourceInfo> resourceInfos) {
        HashSet<Locale> candidates = new HashSet<Locale>();
        candidates.addAll(this.getLocales(info.getInternationalTitle()));
        candidates.addAll(this.getLocales(info.getInternationalAbstract()));
        for (ResourceInfo resourceInfo : resourceInfos) {
            candidates.addAll(this.getLocales(resourceInfo.getInternationalTitle()));
            candidates.addAll(this.getLocales(resourceInfo.getInternationalAbstract()));
        }
        this.setSupportedLocalesFromContactInfo(candidates);
        this.supportedLocales = candidates;
    }

    private void setSupportedLocales(ServiceInfo info, List<LayerInfo> layerInfos, List<LayerGroupInfo> groups) {
        HashSet<Locale> candidates = new HashSet<Locale>();
        candidates.addAll(this.getLocales(info.getInternationalTitle()));
        candidates.addAll(this.getLocales(info.getInternationalAbstract()));
        this.setSupportedLocalesFromGroups(candidates, groups);
        this.setSupportedLocalesFromLayers(candidates, layerInfos);
        this.setSupportedLocalesFromContactInfo(candidates);
        this.supportedLocales = candidates;
    }

    private void setSupportedLocalesFromContactInfo(Set<Locale> candidates) {
        GeoServer gs = (GeoServer)GeoServerExtensions.bean(GeoServer.class);
        ContactInfo contact = gs.getGlobal().getSettings().getContact();
        candidates.addAll(this.getLocales(contact.getInternationalContactEmail()));
        candidates.addAll(this.getLocales(contact.getInternationalAddressCountry()));
        candidates.addAll(this.getLocales(contact.getInternationalAddress()));
        candidates.addAll(this.getLocales(contact.getInternationalAddressState()));
        candidates.addAll(this.getLocales(contact.getInternationalAddressCity()));
        candidates.addAll(this.getLocales(contact.getInternationalAddressDeliveryPoint()));
        candidates.addAll(this.getLocales(contact.getInternationalContactFacsimile()));
        candidates.addAll(this.getLocales(contact.getInternationalContactVoice()));
        candidates.addAll(this.getLocales(contact.getInternationalContactPosition()));
        candidates.addAll(this.getLocales(contact.getInternationalContactPerson()));
        candidates.addAll(this.getLocales(contact.getInternationalContactOrganization()));
        candidates.addAll(this.getLocales(contact.getInternationalAddressPostalCode()));
        candidates.addAll(this.getLocales(contact.getInternationalAddressType()));
        candidates.addAll(this.getLocales(contact.getInternationalOnlineResource()));
    }

    private void setSupportedLocalesFromGroups(Set<Locale> candidates, List<LayerGroupInfo> groups) {
        for (LayerGroupInfo groupInfo : groups) {
            candidates.addAll(this.getLocales(groupInfo.getInternationalTitle()));
            candidates.addAll(this.getLocales(groupInfo.getInternationalAbstract()));
            ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>(groupInfo.getStyles());
            this.setSupportedLocalesFromStyles(candidates, styles);
        }
    }

    private void setSupportedLocalesFromLayers(Set<Locale> candidates, List<LayerInfo> layers) {
        for (LayerInfo layerInfo : layers) {
            candidates.addAll(this.getLocales(layerInfo.getInternationalTitle()));
            candidates.addAll(this.getLocales(layerInfo.getInternationalAbstract()));
            ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>(layerInfo.getStyles());
            styles.add(layerInfo.getDefaultStyle());
            this.setSupportedLocalesFromStyles(candidates, styles);
        }
    }

    private void setSupportedLocalesFromStyles(Set<Locale> candidates, List<StyleInfo> styles) {
        for (StyleInfo styleInfo : styles) {
            if (styleInfo == null) continue;
            try {
                Description description = styleInfo.getStyle().getDescription();
                if (description == null) continue;
                candidates.addAll(this.getLocales(description.getTitle()));
                candidates.addAll(this.getLocales(description.getAbstract()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Set<Locale> getLocales(InternationalString internationalString) {
        Set<Locale> found;
        if (internationalString instanceof GrowableInternationalString) {
            GrowableInternationalString growable = (GrowableInternationalString)internationalString;
            found = growable.getLocales().stream().filter(l -> l != null).collect(Collectors.toSet());
        } else {
            found = Collections.emptySet();
        }
        return found;
    }

    public void verify() {
        if (this.requestedLocales != null && !this.requestedLocales.isEmpty()) {
            String requested = this.requestedLocales.stream().map(l -> l.toLanguageTag()).collect(Collectors.joining(","));
            if (this.supportedLocales == null || this.supportedLocales.isEmpty()) {
                throw new UnsupportedOperationException("Content has been requested in one of the following languages: " + requested + ". But there is no international content defined");
            }
            if (this.anyMatch) {
                return;
            }
            String supported = this.supportedLocales.stream().filter(l -> l != null).map(l -> l.toLanguageTag()).collect(Collectors.joining(","));
            for (Locale locale : this.requestedLocales) {
                if (!locale.toString().isEmpty() && !this.supportedLocales.contains(locale)) continue;
                return;
            }
            throw new UnsupportedOperationException("Content has been requested in one of the following languages: " + requested + ". But supported languages are: " + supported);
        }
    }

    public Set<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    private class KeywordMatch
    implements Predicate<KeywordInfo> {
        private Locale locale;

        public KeywordMatch(Locale locale) {
            this.locale = locale;
        }

        @Override
        public boolean test(KeywordInfo keywordInfo) {
            String language = keywordInfo.getLanguage();
            return this.locale != null && this.locale.getLanguage().equals(language);
        }
    }
}

