/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.geoserver.logging.GeoServerXMLConfiguration;
import org.geoserver.logging.LoggingStartupContextListener;
import org.geoserver.logging.LoggingUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.vfny.geoserver.global.ConfigurationException;

class LoggingUtilsDelegate {
    LoggingUtilsDelegate() {
    }

    static void configureGeoServerLogging(GeoServerResourceLoader loader, Resource configResource, boolean suppressStdOutLogging, boolean suppressFileLogging, String logFileName) throws FileNotFoundException, IOException, ConfigurationException {
        ArrayList<Appender> savedAppenders = new ArrayList<Appender>();
        LoggerContext loggerContext = (LoggerContext)org.apache.logging.log4j.LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        for (Appender check : configuration.getAppenders().values()) {
            if (check instanceof RollingFileAppender || check instanceof FileAppender || check instanceof ConsoleAppender) continue;
            savedAppenders.add(check);
        }
        if (logFileName == null) {
            logFileName = loader.get("logs").get("geoserver.log").file().getAbsolutePath();
        } else if (!new File(logFileName).isAbsolute()) {
            logFileName = new File(loader.getBaseDirectory(), logFileName).getAbsolutePath();
        }
        boolean successfulConfiguration = false;
        successfulConfiguration = LoggingUtilsDelegate.configureFromLog4j2(configResource, suppressFileLogging, suppressStdOutLogging, logFileName);
        if (!successfulConfiguration && "properties".equals(Paths.extension((String)configResource.path()))) {
            successfulConfiguration = LoggingUtilsDelegate.configureFromLog4jProperties(configResource, suppressFileLogging, suppressStdOutLogging, logFileName);
        }
        if (!successfulConfiguration) {
            LoggingUtilsDelegate.configureDefault(Level.INFO);
            LoggingStartupContextListener.getLogger().log(Level.WARNING, "Could setup Log4J using configuration file '" + configResource.name() + "'.Both Log4J 2 and Log4j 1.2 configuration formats were attempted. To troubleshoot configuration setup use ");
            return;
        }
        boolean reloadRequired = LoggingUtilsDelegate.checkConfiguration(suppressStdOutLogging, suppressFileLogging, logFileName);
        LoggerContext loggerContext2 = (LoggerContext)org.apache.logging.log4j.LogManager.getContext((boolean)false);
        Configuration configuration2 = loggerContext2.getConfiguration();
        for (Appender appender : savedAppenders) {
            configuration2.addAppender(appender);
            reloadRequired = true;
        }
        if (reloadRequired) {
            loggerContext2.reconfigure(configuration2);
        }
        LoggingStartupContextListener.getLogger().fine("FINISHED CONFIGURING GEOSERVER LOGGING -------------------------");
    }

    private static boolean checkConfiguration(boolean suppressStdOutLogging, boolean suppressFileLogging, String logFileName) {
        boolean reloadRequired;
        Configuration configuration;
        block10: {
            block8: {
                Appender gslf;
                block11: {
                    RollingFileAppender fileAppender;
                    block9: {
                        LoggerContext loggerContext = (LoggerContext)org.apache.logging.log4j.LogManager.getContext((boolean)false);
                        configuration = loggerContext.getConfiguration();
                        reloadRequired = false;
                        if (suppressFileLogging) break block8;
                        if (configuration.getProperties().containsKey("GEOSERVER_LOG_LOCATION")) {
                            LoggingStartupContextListener.getLogger().fine("Logging property GEOSERVER_LOG_LOCATION set to file '" + logFileName + "' for use by appenders.");
                        }
                        if (!((gslf = configuration.getAppender("geoserverlogfile")) instanceof RollingFileAppender)) break block9;
                        fileAppender = (RollingFileAppender)gslf;
                        if (logFileName.equals(fileAppender.getFileName())) {
                            LoggingStartupContextListener.getLogger().fine("Logging output set to file '" + logFileName + "'");
                        } else {
                            LoggingStartupContextListener.getLogger().fine("Logging output to file '" + fileAppender.getFileName() + "', ignored '" + logFileName + "'");
                        }
                        break block10;
                    }
                    if (!(gslf instanceof FileAppender)) break block11;
                    fileAppender = (FileAppender)gslf;
                    if (logFileName.equals(fileAppender.getFileName())) {
                        LoggingStartupContextListener.getLogger().fine("Logging output set to file '" + logFileName + "'");
                    } else {
                        LoggingStartupContextListener.getLogger().fine("Logging output to file '" + fileAppender.getFileName() + "', ignored '" + logFileName + "'");
                    }
                    break block10;
                }
                if (gslf == null) break block10;
                LoggingStartupContextListener.getLogger().warning("'log4j.appender.geoserverlogfile' appender is defined, but isn't a FileAppender.  GeoServer won't control the file-based logging.");
                break block10;
            }
            LoggingStartupContextListener.getLogger().info("Suppressing file logging, if you want to see GeoServer logs, be sure to look in stdOut");
            for (Appender check : configuration.getAppenders().values()) {
                if (!(check instanceof FileAppender) && !(check instanceof RollingFileAppender)) continue;
                LoggingStartupContextListener.getLogger().warning("'" + check.getName() + "' appender is defined, but GeoServer asked that file logging be supressed.");
            }
        }
        if (suppressStdOutLogging) {
            LoggingStartupContextListener.getLogger().info("Suppressing StdOut logging.  If you want to see GeoServer logs, be sure to look in '" + logFileName + "'");
            for (Appender check : configuration.getAppenders().values()) {
                if (!(check instanceof ConsoleAppender)) continue;
                configuration.getAppenders().values().remove(check);
                reloadRequired = true;
            }
        }
        return reloadRequired;
    }

    private static boolean configureFromLog4j2(Resource configResource, final boolean noFileLogging, final boolean noConsoleLogging, final String logFileName) {
        String extension = Paths.extension((String)configResource.path());
        LoggerContext loggerContext = (LoggerContext)org.apache.logging.log4j.LogManager.getContext((boolean)false);
        try {
            URI configLocation = Resources.file((Resource)configResource).toURI();
            loggerContext.setName(configResource.name());
            if (extension.equalsIgnoreCase("xml")) {
                ConfigurationSource source = ConfigurationSource.fromUri((URI)configLocation);
                GeoServerXMLConfiguration configuration = new GeoServerXMLConfiguration(loggerContext, source){

                    public void setup() {
                        this.loggingLocation = logFileName;
                        this.suppressFileLogging = noFileLogging;
                        this.suppressStdOutLogging = noConsoleLogging;
                        super.setup();
                    }
                };
                loggerContext.reconfigure((Configuration)configuration);
                Logger LOGGER = LoggingStartupContextListener.getLogger();
                LOGGER.config("Log4j 2 configuration set to " + configResource.name());
                return true;
            }
            loggerContext.setConfigLocation(configLocation);
            LoggingStartupContextListener.LOGGER.config("Log4j 2 configuration set to " + configResource.name());
            return !extension.equalsIgnoreCase("properties") || loggerContext.getConfiguration().getAppenders().size() != 1 || !loggerContext.getConfiguration().getLoggers().isEmpty();
        }
        catch (Throwable unsuccessful) {
            LoggingStartupContextListener.getLogger().log(Level.WARNING, "Could not access Log4J 2 configuration uri '" + configResource.name() + "'", unsuccessful);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean configureFromLog4jProperties(Resource configResource, boolean suppressFileLogging, boolean suppressStdOutLogging, String logFileName) {
        String appenderClass;
        List removeAppender;
        Properties lprops = new Properties();
        try (InputStream loggingConfigStream = configResource.in();){
            if (loggingConfigStream == null) {
                LoggingStartupContextListener.getLogger().log(Level.WARNING, "Could not access Log4J 1.2 configuration file '" + configResource.name() + "'");
                boolean bl = false;
                return bl;
            }
            LoggingStartupContextListener.getLogger().fine("GeoServer logging profile '" + configResource.name() + "' enabled.");
            lprops.load(loggingConfigStream);
        }
        catch (IOException couldNotRead) {
            LoggingStartupContextListener.getLogger().log(Level.WARNING, "Could not access Log4J 1.2 configuration file '" + configResource.name() + "'");
            return false;
        }
        if (lprops.containsKey("rootLogger")) {
            LoggingStartupContextListener.getLogger().fine("Confident this is a log4j 2 properties configuration");
            return false;
        }
        if (lprops.containsKey("log4j.rootLogger")) {
            LoggingStartupContextListener.getLogger().fine("Confident this is a log4j 1.2 properties configuration");
        }
        if (suppressStdOutLogging) {
            removeAppender = lprops.keySet().stream().map(k -> (String)k).filter(k -> k.startsWith("log4j.appender.stdout")).collect(Collectors.toList());
            lprops.keySet().removeAll(removeAppender);
        }
        if (suppressFileLogging) {
            removeAppender = lprops.keySet().stream().map(k -> (String)k).filter(k -> k.startsWith("log4j.appender.geoserverlogfile")).collect(Collectors.toList());
            lprops.keySet().removeAll(removeAppender);
        } else if (lprops.containsKey("log4j.appender.geoserverlogfile") && (appenderClass = (String)lprops.get("log4j.appender.geoserverlogfile")).endsWith("FileAppender")) {
            lprops.setProperty("log4j.appender.geoserverlogfile.File", logFileName);
        }
        try {
            LogManager.resetConfiguration();
            PropertyConfigurator.configure((Properties)lprops);
            return true;
        }
        catch (Throwable unsuccessful) {
            LoggingStartupContextListener.getLogger().log(Level.WARNING, "Could not access Log4J 1.2 configuration file '" + configResource.name() + "'", unsuccessful);
            return false;
        }
    }

    private static boolean configureDefault(Level level) {
        int value = level.intValue();
        String defaultLevel = value > Level.SEVERE.intValue() ? "OFF" : (value > Level.WARNING.intValue() ? "ERROR" : (value > Level.INFO.intValue() ? "WARN" : (value > Level.FINE.intValue() ? "INFO" : (value > Level.FINER.intValue() ? "DEBUG" : (value > Level.FINEST.intValue() ? "TRACE" : "ALL")))));
        System.setProperty("org.apache.logging.log4j.level", defaultLevel);
        LoggerContext loggerContext = (LoggerContext)org.apache.logging.log4j.LogManager.getContext((boolean)false);
        loggerContext.reconfigure((Configuration)new DefaultConfiguration());
        return true;
    }

    static void initLogging(GeoServerResourceLoader resourceLoader, String configFileName, boolean suppressStdOutLogging, boolean suppressFileLogging, String logFileName) throws Exception {
        Resource configResource;
        LoggingStartupContextListener.getLogger().fine("CONFIGURING GEOSERVER LOGGING -------------------------");
        LoggingUtilsDelegate.checkStandardLoggingConfiguration(resourceLoader);
        if (configFileName == null) {
            configFileName = "DEFAULT_LOGGING";
            LoggingStartupContextListener.getLogger().config("No logging configuration (the logging.xml level) defined:  using 'DEFAULT_LOGGING'");
        }
        if ((configResource = LoggingUtilsDelegate.determineLoggingProfile(resourceLoader, configFileName)).getType() != Resource.Type.RESOURCE) {
            LoggingUtilsDelegate.configureDefault(Level.INFO);
            LoggingStartupContextListener.getLogger().warning("Unable to load logging configuration '" + configFileName + "'.  In addition, an attempt was made to create the 'logs' directory in your data dir, and to use the DEFAULT_LOGGING configuration, but this failed as well. Is your data dir writeable?");
            return;
        }
        LoggingUtilsDelegate.configureGeoServerLogging(resourceLoader, configResource, suppressStdOutLogging, suppressFileLogging, logFileName);
    }

    private static Resource determineLoggingProfile(GeoServerResourceLoader resourceLoader, String configFileName) {
        Resource logs = resourceLoader.get("logs");
        Resource configResource = logs.get(configFileName);
        if (configResource.getType() != Resource.Type.RESOURCE) {
            String[] EXTENSIONS = new String[]{"xml", "yml", "yaml", "json", "jsn", "properties"};
            Map<String, Resource> availableLoggingConfigurations = logs.list().stream().filter(r -> r.getType() == Resource.Type.RESOURCE && r.name().contains("_LOGGING")).collect(Collectors.toMap(r -> r.name(), r -> r));
            String baseFileName = configFileName.lastIndexOf(46) == -1 ? configFileName : configFileName.substring(0, configFileName.lastIndexOf(46));
            for (String extension : EXTENSIONS) {
                if (!availableLoggingConfigurations.containsKey(baseFileName + "." + extension)) continue;
                configResource = availableLoggingConfigurations.get(baseFileName + "." + extension);
                break;
            }
        }
        return configResource;
    }

    static void checkBuiltInLoggingConfiguration(GeoServerResourceLoader resourceLoader, String logConfigFile) {
        Resource logs = resourceLoader.get("logs");
        File logsDirectory = logs.dir();
        String logConfigXml = logConfigFile + ".xml";
        File target = new File(logsDirectory.getAbsolutePath(), logConfigXml);
        if (target.exists()) {
            if (LoggingUtils.updateBuiltInLoggingProfiles) {
                try (FileInputStream targetContents = new FileInputStream(target);
                     InputStream template = LoggingUtilsDelegate.getStreamFromResource(logConfigXml);){
                    if (!IOUtils.contentEquals((InputStream)targetContents, (InputStream)template)) {
                        String logConfigBackup = logConfigFile + ".xml.bak";
                        File backup = new File(logsDirectory.getAbsolutePath(), logConfigBackup);
                        boolean renamed = target.renameTo(backup);
                        if (renamed) {
                            LoggingStartupContextListener.getLogger().finer("Check '" + logConfigXml + "' logging configuration - outdated and renamed to '" + logConfigBackup + "'");
                        }
                        LoggingStartupContextListener.getLogger().finer("Check '" + logConfigXml + "' logging configuration, outdated");
                        resourceLoader.copyFromClassPath(logConfigXml, target);
                    }
                }
                catch (IOException e) {
                    LoggingStartupContextListener.getLogger().log(Level.WARNING, "Check '" + logConfigXml + "' logging configuration - unable to check against template", e);
                }
            }
        } else {
            try {
                resourceLoader.copyFromClassPath(logConfigXml, target);
            }
            catch (IOException e) {
                LoggingStartupContextListener.getLogger().config("Check '" + logConfigXml + "' logging configuration - unable to create. Is your data dir writeable?");
            }
        }
    }

    private static void checkStandardLoggingConfiguration(GeoServerResourceLoader resourceLoader) {
        Resource logs = resourceLoader.get("logs");
        File logsDirectory = logs.dir();
        for (String logConfigFile : LoggingUtils.STANDARD_LOGGING_CONFIGURATIONS) {
            String logConfigProperties = logConfigFile + ".properties";
            File properties = new File(logsDirectory.getAbsolutePath(), logConfigProperties);
            if (properties.exists()) {
                String logConfigBackup = logConfigFile + ".properties.bak";
                File backup = new File(logsDirectory.getAbsolutePath(), logConfigBackup);
                boolean renamed = properties.renameTo(backup);
                if (renamed) {
                    LoggingStartupContextListener.getLogger().finer("Check '" + logConfigProperties + "' logging configuration - outdated and renamed to '" + logConfigBackup + "'");
                } else {
                    LoggingStartupContextListener.getLogger().config("Check '" + logConfigProperties + "' logging configuration - outdated and unable to rename. Is your data dir writeable?");
                }
            }
            LoggingUtilsDelegate.checkBuiltInLoggingConfiguration(resourceLoader, logConfigFile);
        }
    }

    private static InputStream getStreamFromResource(String classpathResource) throws IOException {
        InputStream is = null;
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IOException("Could not obtain " + classpathResource + " from scope " + Thread.currentThread().getContextClassLoader().toString() + ".");
        }
        return is;
    }
}

