/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.Service;
import org.geotools.util.logging.Logging;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.UriComponentsBuilder;

public class CiteComplianceHack
implements HandlerInterceptor {
    private static final Logger LOGGER = Logging.getLogger(CiteComplianceHack.class);
    GeoServer gs;
    Class<? extends ServiceInfo> serviceClass;

    public CiteComplianceHack(GeoServer gs, Class<? extends ServiceInfo> serviceClass) {
        this.gs = gs;
        this.serviceClass = serviceClass;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Dispatcher dispatcher;
        String service;
        if (handler instanceof Dispatcher && (service = this.findService(dispatcher = (Dispatcher)handler, request, response)) != null && (service.equalsIgnoreCase(this.getInfo().getId()) || service.equalsIgnoreCase(this.getInfo().getName()))) {
            dispatcher.setCiteCompliant(this.getInfo().isCiteCompliant());
        }
        return true;
    }

    private String findService(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) {
        Request req = new Request();
        req.setHttpRequest(request);
        req.setHttpResponse(response);
        Dispatcher.initRequestContext((Request)req);
        try {
            return dispatcher.getServiceFromRequest(req);
        }
        catch (Exception ex1) {
            LOGGER.log(Level.FINE, "Exception while looking for the 'Service' from the request", ex1);
            try {
                Service serviceDescriptor;
                UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)req.path);
                if (builder != null && builder.build() != null && builder.build().getPath() != null && (serviceDescriptor = dispatcher.findService(Objects.requireNonNull(builder.build().getPath()), req.getVersion(), req.getNamespace())) != null) {
                    return serviceDescriptor.getId();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINE, "Exception while decoding OWS URL " + request.getServletPath(), ex2);
            }
            return null;
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    ServiceInfo getInfo() {
        return this.gs.getService(this.serviceClass);
    }
}

