/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.HTTPMethod;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class GeoServerRequestMatcher
implements RequestMatcher {
    private Set<HTTPMethod> methods;
    private RequestMatcher[] matchers;

    public GeoServerRequestMatcher(Set<HTTPMethod> methods, RequestMatcher ... matchers) {
        this.methods = methods;
        this.matchers = matchers;
    }

    public boolean matches(HttpServletRequest request) {
        if (!this.matchesHTTPMethod(request)) {
            return false;
        }
        if (this.matchers == null) {
            return false;
        }
        for (RequestMatcher matcher : this.matchers) {
            if (!matcher.matches(request)) continue;
            return true;
        }
        return false;
    }

    protected boolean matchesHTTPMethod(HttpServletRequest request) {
        if (this.methods == null) {
            return true;
        }
        HTTPMethod method = HTTPMethod.fromString(request.getMethod());
        return this.methods.contains((Object)method);
    }
}

