/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.geotools.util.logging.Logging;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class IncludeQueryStringAntPathRequestMatcher
implements RequestMatcher {
    private static final Logger logger = Logging.getLogger(IncludeQueryStringAntPathRequestMatcher.class);
    private static final String MATCH_ALL = "/**";
    private static final String QUERYSTRING_SEPARATOR = "|";
    private final Matcher matcher;
    private final Matcher queryStringMatcher;
    private final String pattern;
    private final HttpMethod httpMethod;

    public IncludeQueryStringAntPathRequestMatcher(String pattern) {
        this(pattern, null);
    }

    public IncludeQueryStringAntPathRequestMatcher(String pattern, String httpMethod) {
        Assert.hasText((String)pattern, (String)"Pattern cannot be null or empty");
        String queryStringPattern = "";
        String originalPattern = pattern;
        if (pattern.contains(QUERYSTRING_SEPARATOR)) {
            queryStringPattern = pattern.substring(pattern.indexOf(QUERYSTRING_SEPARATOR) + 1);
            pattern = pattern.substring(0, pattern.indexOf(QUERYSTRING_SEPARATOR));
        }
        if (pattern.equals(MATCH_ALL) || pattern.equals("**")) {
            pattern = MATCH_ALL;
            this.matcher = null;
        } else {
            this.matcher = (pattern = pattern.toLowerCase()).endsWith(MATCH_ALL) && pattern.indexOf(63) == -1 && pattern.indexOf("*") == pattern.length() - 2 ? new SubpathMatcher(pattern.substring(0, pattern.length() - 3)) : new SpringAntMatcher(pattern);
        }
        this.pattern = originalPattern;
        this.queryStringMatcher = StringUtils.hasLength((String)queryStringPattern) ? new QueryStringMatcher(queryStringPattern) : null;
        this.httpMethod = StringUtils.hasText((String)httpMethod) ? HttpMethod.valueOf((String)httpMethod) : null;
    }

    public boolean matches(HttpServletRequest request) {
        boolean matched;
        if (this.httpMethod != null && this.httpMethod != HttpMethod.valueOf((String)request.getMethod())) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Request '" + request.getMethod() + " " + this.getRequestPath(request) + "' doesn't match '" + this.httpMethod + " " + this.pattern);
            }
            return false;
        }
        RequestUrlParts url = this.getRequestPath(request);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Checking match of request : '" + url + "'; against '" + this.pattern + "'");
        }
        boolean bl = matched = this.matchesPath(url) && this.matchesQueryString(url);
        if (matched) {
            logger.fine("Matched " + url + " with " + this.pattern);
        }
        return matched;
    }

    private boolean matchesQueryString(RequestUrlParts url) {
        if (this.queryStringMatcher != null) {
            return this.queryStringMatcher.matches(url.getQueryString());
        }
        return true;
    }

    private boolean matchesPath(RequestUrlParts url) {
        if (this.pattern.equals(MATCH_ALL)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Request matched by universal pattern '/**'");
            }
            return true;
        }
        return this.matcher.matches(url.getPath());
    }

    private RequestUrlParts getRequestPath(HttpServletRequest request) {
        Object url = request.getServletPath();
        if (request.getPathInfo() != null) {
            url = (String)url + request.getPathInfo();
        }
        url = ((String)url).toLowerCase();
        String queryString = request.getQueryString();
        return new RequestUrlParts((String)url, queryString);
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IncludeQueryStringAntPathRequestMatcher)) {
            return false;
        }
        IncludeQueryStringAntPathRequestMatcher other = (IncludeQueryStringAntPathRequestMatcher)obj;
        return this.pattern.equals(other.pattern) && this.httpMethod == other.httpMethod;
    }

    public int hashCode() {
        int code = 0x1F ^ this.pattern.hashCode();
        if (this.httpMethod != null) {
            code ^= this.httpMethod.hashCode();
        }
        return code;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ant [pattern='").append(this.pattern).append("'");
        if (this.httpMethod != null) {
            sb.append(", ").append(this.httpMethod);
        }
        sb.append("]");
        return sb.toString();
    }

    private static class RequestUrlParts {
        private String path;
        private String queryString;

        public RequestUrlParts(String path, String queryString) {
            this.path = path;
            this.queryString = queryString;
        }

        public String getPath() {
            return this.path;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public String toString() {
            return "Path: " + this.path + ", QueryString: " + this.queryString;
        }
    }

    private static class SubpathMatcher
    implements Matcher {
        private final String subpath;
        private final int length;

        private SubpathMatcher(String subpath) {
            assert (!subpath.contains("*"));
            this.subpath = subpath;
            this.length = subpath.length();
        }

        @Override
        public boolean matches(String path) {
            return path.startsWith(this.subpath) && (path.length() == this.length || path.charAt(this.length) == '/');
        }
    }

    private static class QueryStringMatcher
    implements Matcher {
        private Pattern pattern = null;

        private QueryStringMatcher(String pattern) {
            try {
                this.pattern = Pattern.compile(this.parsePattern(pattern), 2);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in filter chain query string pattern", e);
            }
        }

        private String parsePattern(String unparsed) {
            if (!((String)unparsed).startsWith("^")) {
                unparsed = "^" + (String)unparsed;
            }
            if (!((String)unparsed).endsWith("$")) {
                unparsed = (String)unparsed + "$";
            }
            return unparsed;
        }

        @Override
        public boolean matches(String path) {
            if (this.pattern != null && path != null) {
                return this.pattern.matcher(path).matches();
            }
            return false;
        }
    }

    private static class SpringAntMatcher
    implements Matcher {
        private static final AntPathMatcher antMatcher = new AntPathMatcher();
        private final String pattern;

        private SpringAntMatcher(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String path) {
            return antMatcher.match(this.pattern, path);
        }
    }

    private static interface Matcher {
        public boolean matches(String var1);
    }
}

