/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.security.Response;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredWMSLayer;
import org.geotools.api.filter.Filter;
import org.geotools.api.geometry.Bounds;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.StyleImpl;
import org.geotools.ows.wms.request.GetMapRequest;
import org.geotools.util.logging.Logging;

public class SecuredGetMapRequest
implements GetMapRequest {
    static final Logger LOGGER = Logging.getLogger(SecuredGetMapRequest.class);
    GetMapRequest delegate;
    List<Layer> layers = new ArrayList<Layer>();
    List<String> styles = new ArrayList<String>();
    boolean layersAddedToDelegate = false;

    public SecuredGetMapRequest(GetMapRequest delegate) {
        this.delegate = delegate;
    }

    public void addLayer(Layer layer, String styleName) {
        this.layers.add(layer);
        if (styleName != null) {
            this.styles.add(styleName);
        } else {
            this.styles.add("");
        }
    }

    public void addLayer(Layer layer, StyleImpl style) {
        this.layers.add(layer);
        if (style != null && style.getName() != null) {
            this.styles.add(style.getName());
        } else {
            this.styles.add("");
        }
    }

    public void addLayer(Layer layer) {
        this.layers.add(layer);
        this.styles.add("");
    }

    public void addLayer(String layerName, String styleName) {
        throw new UnsupportedOperationException("The secured implementation only supports adding layers using Layer and StyleImpl objects");
    }

    public void addLayer(String layerName, StyleImpl style) {
        throw new UnsupportedOperationException("The secured implementation only supports adding layers using Layer and StyleImpl objects");
    }

    public URL getFinalURL() {
        String encodedFilter = this.buildCQLFilter();
        if (encodedFilter != null) {
            this.delegate.setProperty("CQL_FILTER", encodedFilter);
        }
        return this.delegate.getFinalURL();
    }

    public String buildCQLFilter() {
        ArrayList<Filter> layerFilters = new ArrayList<Filter>();
        boolean layerFiltersFound = false;
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = this.layers.get(i);
            if (!(layer instanceof SecuredWMSLayer)) continue;
            SecuredWMSLayer secured = (SecuredWMSLayer)layer;
            WrapperPolicy policy = secured.getPolicy();
            if (policy.getResponse() == Response.CHALLENGE) {
                SecureCatalogImpl.unauthorizedAccess(layer.getName());
            }
            if (policy.getLimits() instanceof WMSAccessLimits) {
                WMSAccessLimits limits = (WMSAccessLimits)policy.getLimits();
                layerFilters.add(limits.getReadFilter());
                layerFiltersFound |= limits.getReadFilter() != null;
                if (limits.getRasterFilter() != null) {
                    LOGGER.severe("Sorry, raster filters for cascaded wms layers have not been implemented yet");
                }
            }
            if (this.layersAddedToDelegate) continue;
            this.delegate.addLayer(layer, this.styles.get(i));
        }
        String encodedFilter = null;
        if (layerFiltersFound) {
            StringBuilder sb = new StringBuilder();
            for (Filter filter : layerFilters) {
                if (filter != null) {
                    sb.append(CQL.toCQL((Filter)filter));
                }
                sb.append(";");
            }
            sb.setLength(sb.length() - 1);
            encodedFilter = ResponseUtils.urlEncode((String)sb.toString(), (char[])new char[0]);
        }
        this.layersAddedToDelegate = true;
        return encodedFilter;
    }

    public String getPostContentType() {
        return this.delegate.getPostContentType();
    }

    public Properties getProperties() {
        return this.delegate.getProperties();
    }

    public void performPostOutput(OutputStream outputStream) throws IOException {
        this.delegate.performPostOutput(outputStream);
    }

    public boolean requiresPost() {
        return this.delegate.requiresPost();
    }

    public void setBBox(Bounds box) {
        this.delegate.setBBox(box);
    }

    public void setBBox(CRSEnvelope box) {
        this.delegate.setBBox((Bounds)box);
    }

    public void setBBox(String bbox) {
        this.delegate.setBBox(bbox);
    }

    public void setBGColour(String bgColour) {
        this.delegate.setBGColour(bgColour);
    }

    public void setDimensions(Dimension imageDimension) {
        this.delegate.setDimensions(imageDimension);
    }

    public void setDimensions(int width, int height) {
        this.delegate.setDimensions(width, height);
    }

    public void setDimensions(String width, String height) {
        this.delegate.setDimensions(width, height);
    }

    public void setElevation(String elevation) {
        this.delegate.setElevation(elevation);
    }

    public void setExceptions(String exceptions) {
        this.delegate.setExceptions(exceptions);
    }

    public void setFormat(String format) {
        this.delegate.setFormat(format);
    }

    public void setProperties(Properties p) {
        this.delegate.setProperties(p);
    }

    public void setProperty(String name, String value) {
        this.delegate.setProperty(name, value);
    }

    public void setSampleDimensionValue(String name, String value) {
        this.delegate.setSampleDimensionValue(name, value);
    }

    public void setSRS(String srs) {
        this.delegate.setSRS(srs);
    }

    public void setTime(String time) {
        this.delegate.setTime(time);
    }

    public void setTransparent(boolean transparent) {
        this.delegate.setTransparent(transparent);
    }

    public void setVendorSpecificParameter(String name, String value) {
        this.delegate.setVendorSpecificParameter(name, value);
    }

    public void setVersion(String version) {
        this.delegate.setVersion(version);
    }

    public org.geotools.data.ows.Response createResponse(HTTPResponse response) throws ServiceException, IOException {
        return this.delegate.createResponse(response);
    }
}

