/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerRoleConverter;
import org.geoserver.security.config.RoleFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class GeoServerRoleFilter
extends GeoServerSecurityFilter {
    protected GeoServerRoleConverter converter;
    protected String headerAttribute;
    public static String DEFAULT_ROLE_CONVERTER = "roleConverter";
    public static String DEFAULT_HEADER_ATTRIBUTE = "roles";

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        RoleFilterConfig roleConfig = (RoleFilterConfig)config;
        this.headerAttribute = roleConfig.getHttpResponseHeaderAttrForIncludedRoles();
        String converterName = roleConfig.getRoleConverterName();
        this.converter = converterName == null || converterName.isEmpty() ? (GeoServerRoleConverter)GeoServerExtensions.bean(GeoServerRoleConverter.class) : (GeoServerRoleConverter)GeoServerExtensions.bean((String)converterName);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Authentication auth;
        chain.doFilter(request, response);
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && (auth = context.getAuthentication()) != null) {
            String roleString = this.converter.convertRolesToString(auth.getAuthorities());
            ((HttpServletResponse)response).setHeader(this.headerAttribute, roleString);
        }
    }
}

