/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.RoleLoadedListener;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.ServiceAccessRule;
import org.geoserver.security.validation.AbstractSecurityValidator;
import org.geoserver.security.validation.RoleServiceException;
import org.geotools.util.logging.Logging;
import org.springframework.util.StringUtils;

public class RoleServiceValidationWrapper
extends AbstractSecurityValidator
implements GeoServerRoleService {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    protected GeoServerRoleService service;
    protected GeoServerUserGroupService[] services;
    protected boolean checkAgainstRules;

    public RoleServiceValidationWrapper(GeoServerRoleService service, boolean checkAgainstRules, GeoServerUserGroupService ... services) {
        super(service.getSecurityManager());
        this.service = service;
        this.services = services;
        this.checkAgainstRules = checkAgainstRules;
    }

    public RoleServiceValidationWrapper(GeoServerRoleService service, GeoServerUserGroupService ... services) {
        this(service, false, services);
    }

    public GeoServerRoleService getWrappedService() {
        return this.service;
    }

    protected void checkValidUserName(String userName) throws IOException {
        if (!this.isNotEmpty(userName)) {
            throw this.createSecurityException("USERNAME_REQUIRED", new Object[0]);
        }
        if (this.services.length == 0) {
            return;
        }
        for (GeoServerUserGroupService service : this.services) {
            if (service.getUserByUsername(userName) == null) continue;
            return;
        }
        throw this.createSecurityException("USERNAME_NOT_FOUND", userName);
    }

    public void checkRoleIsUsed(GeoServerRole role) throws IOException {
        if (!this.checkAgainstRules) {
            return;
        }
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        ArrayList<String> keys = new ArrayList<String>();
        for (ServiceAccessRule serviceAccessRule : secMgr.getServiceAccessRuleDAO().getRulesAssociatedWithRole(role.getAuthority())) {
            keys.add(serviceAccessRule.getKey());
        }
        for (DataAccessRule dataAccessRule : secMgr.getDataAccessRuleDAO().getRulesAssociatedWithRole(role.getAuthority())) {
            keys.add(dataAccessRule.getKey());
        }
        if (!keys.isEmpty()) {
            String ruleString = StringUtils.collectionToCommaDelimitedString(keys);
            throw this.createSecurityException("ROLE_IN_USE", role.getAuthority(), ruleString);
        }
    }

    public void checkRoleIsMapped(GeoServerRole role) throws IOException {
        GeoServerRole mappedRole = this.service.getAdminRole();
        if (mappedRole != null && mappedRole.equals(role)) {
            throw this.createSecurityException("ADMIN_ROLE_NOT_REMOVABLE", role.getAuthority());
        }
        mappedRole = this.service.getGroupAdminRole();
        if (mappedRole != null && mappedRole.equals(role)) {
            throw this.createSecurityException("GROUP_ADMIN_ROLE_NOT_REMOVABLE", role.getAuthority());
        }
    }

    protected void checkValidGroupName(String groupName) throws IOException {
        if (!this.isNotEmpty(groupName)) {
            throw this.createSecurityException("GROUPNAME_REQUIRED", new Object[0]);
        }
        if (this.services.length == 0) {
            return;
        }
        for (GeoServerUserGroupService service : this.services) {
            if (service.getGroupByGroupname(groupName) == null) continue;
            return;
        }
        throw this.createSecurityException("GROUPNAME_NOT_FOUND", groupName);
    }

    protected void checkRoleName(String roleName) throws IOException {
        if (!this.isNotEmpty(roleName)) {
            throw this.createSecurityException("NAME_REQUIRED", new Object[0]);
        }
    }

    protected void checkExistingRoleName(String roleName) throws IOException {
        this.checkRoleName(roleName);
        if (this.service.getRoleByName(roleName) == null) {
            throw this.createSecurityException("NOT_FOUND", roleName);
        }
    }

    protected void checkReservedNames(String roleName) throws IOException {
        for (GeoServerRole systemRole : GeoServerRole.SystemRoles) {
            if (!systemRole.getAuthority().equals(roleName)) continue;
            throw this.createSecurityException("RESERVED_NAME", roleName);
        }
    }

    protected void checkNotExistingInOtherServices(String roleName) throws IOException {
        this.checkRoleName(roleName);
        for (String serviceName : this.service.getSecurityManager().listRoleServices()) {
            if (this.service.getName().equals(serviceName)) continue;
            GeoServerRole role = null;
            try {
                role = this.service.getSecurityManager().loadRoleService(serviceName).getRoleByName(roleName);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                throw this.createSecurityException("CANNOT_CHECK_ROLE_IN_SERVICE", roleName, serviceName);
            }
            if (role == null) continue;
            throw this.createSecurityException("ALREADY_EXISTS_IN", roleName, serviceName);
        }
    }

    protected void checkNotExistingRoleName(String roleName) throws IOException {
        this.checkRoleName(roleName);
        if (this.service.getRoleByName(roleName) != null) {
            throw this.createSecurityException("ALREADY_EXISTS", roleName);
        }
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        this.service.initializeFromConfig(config);
    }

    @Override
    public boolean canCreateStore() {
        return this.service.canCreateStore();
    }

    @Override
    public GeoServerRoleStore createStore() throws IOException {
        return this.service.createStore();
    }

    @Override
    public String getName() {
        return this.service.getName();
    }

    @Override
    public void setName(String name) {
        this.service.setName(name);
    }

    @Override
    public void setSecurityManager(GeoServerSecurityManager securityManager) {
        this.service.setSecurityManager(securityManager);
    }

    @Override
    public void registerRoleLoadedListener(RoleLoadedListener listener) {
        this.service.registerRoleLoadedListener(listener);
    }

    @Override
    public GeoServerSecurityManager getSecurityManager() {
        return this.service.getSecurityManager();
    }

    @Override
    public void unregisterRoleLoadedListener(RoleLoadedListener listener) {
        this.service.unregisterRoleLoadedListener(listener);
    }

    @Override
    public SortedSet<String> getGroupNamesForRole(GeoServerRole role) throws IOException {
        this.checkExistingRoleName(role.getAuthority());
        return this.service.getGroupNamesForRole(role);
    }

    @Override
    public SortedSet<String> getUserNamesForRole(GeoServerRole role) throws IOException {
        this.checkExistingRoleName(role.getAuthority());
        return this.service.getUserNamesForRole(role);
    }

    @Override
    public SortedSet<GeoServerRole> getRolesForUser(String username) throws IOException {
        this.checkValidUserName(username);
        return this.service.getRolesForUser(username);
    }

    @Override
    public SortedSet<GeoServerRole> getRolesForGroup(String groupname) throws IOException {
        this.checkValidGroupName(groupname);
        return this.service.getRolesForGroup(groupname);
    }

    @Override
    public SortedSet<GeoServerRole> getRoles() throws IOException {
        return this.service.getRoles();
    }

    @Override
    public Map<String, String> getParentMappings() throws IOException {
        return this.service.getParentMappings();
    }

    @Override
    public GeoServerRole createRoleObject(String role) throws IOException {
        this.checkRoleName(role);
        return this.service.createRoleObject(role);
    }

    @Override
    public GeoServerRole getParentRole(GeoServerRole role) throws IOException {
        this.checkExistingRoleName(role.getAuthority());
        return this.service.getParentRole(role);
    }

    @Override
    public GeoServerRole getRoleByName(String role) throws IOException {
        return this.service.getRoleByName(role);
    }

    @Override
    public void load() throws IOException {
        this.service.load();
    }

    @Override
    public Properties personalizeRoleParams(String roleName, Properties roleParams, String userName, Properties userProps) throws IOException {
        return this.service.personalizeRoleParams(roleName, roleParams, userName, userProps);
    }

    @Override
    public GeoServerRole getAdminRole() {
        return this.service.getAdminRole();
    }

    @Override
    public GeoServerRole getGroupAdminRole() {
        return this.service.getGroupAdminRole();
    }

    @Override
    public int getRoleCount() throws IOException {
        return this.service.getRoleCount();
    }

    protected IOException createSecurityException(String errorid, Object ... args) {
        RoleServiceException ex = new RoleServiceException(errorid, args);
        return new IOException("Details are in the nested exception", (Throwable)((Object)ex));
    }
}

